/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.jet.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternExecutionReporter;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.pattern.PatternPreferences;
import org.eclipse.egf.pattern.engine.PatternEngine;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.execution.ConsoleReporter;
import org.eclipse.egf.pattern.execution.InternalPatternContext;
import org.eclipse.egf.pattern.jet.JetPreferences;
import org.eclipse.egf.pattern.jet.Messages;
import org.eclipse.egf.pattern.jet.engine.JetAssemblyContentProvider;
import org.eclipse.egf.pattern.jet.engine.JetAssemblyHelper;
import org.eclipse.egf.pattern.jet.engine.JetNatureHelper;
import org.eclipse.egf.pattern.jet.engine.SkeletonJETCompiler;
import org.eclipse.egf.pattern.utils.FileHelper;
import org.eclipse.egf.pattern.utils.ParameterTypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetEngine
extends PatternEngine {
    public JetEngine(Pattern pattern) throws PatternException {
        super(pattern);
    }

    public void executeWithInjection(PatternContext context, Object ... parameters) throws PatternException {
        this.setupExecutionReporter((InternalPatternContext)context);
        this.doExecute((InternalPatternContext)context, parameters);
    }

    public void execute(PatternContext context) throws PatternException {
        this.setupExecutionReporter((InternalPatternContext)context);
        this.doExecute((InternalPatternContext)context, null);
    }

    private void doExecute(InternalPatternContext context, Object[] executionParameters) throws PatternException {
        try {
            Class<?> templateClass = this.loadTemplateClass(context);
            Object template = templateClass.newInstance();
            Class[] parameterClasses = null;
            Object[] parameterValues = null;
            if (executionParameters == null) {
                parameterClasses = new Class[]{Object.class};
                parameterValues = new Object[]{context};
            } else {
                int size = executionParameters == null ? 1 : executionParameters.length + 1;
                parameterClasses = new Class[size];
                parameterValues = new Object[size];
                parameterClasses[0] = PatternContext.class;
                parameterValues[0] = context;
                int n = 0;
                while (n < executionParameters.length) {
                    parameterClasses[n + 1] = Object.class;
                    parameterValues[n + 1] = executionParameters[n];
                    ++n;
                }
            }
            Method method = templateClass.getMethod("generate", parameterClasses);
            method.invoke(template, parameterValues);
        }
        catch (InvocationTargetException e) {
            throw new PatternException(e.getCause());
        }
        catch (PatternException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatternException((Throwable)e);
        }
    }

    private void setupExecutionReporter(InternalPatternContext context) throws PatternException {
        if (context.hasReporter()) {
            return;
        }
        PatternExecutionReporter reporter = (PatternExecutionReporter)context.getValue("pattern.execution.reporter");
        if (reporter == null) {
            reporter = new ConsoleReporter();
        }
        context.setReporter(reporter);
    }

    private Class<?> loadTemplateClass(InternalPatternContext context) throws PatternException, ClassNotFoundException {
        Pattern pattern = this.getPattern();
        if (pattern == null) {
            throw new PatternException(Messages.assembly_error9);
        }
        String templateClassName = JetNatureHelper.getTemplateClassName(pattern);
        if (templateClassName == null) {
            throw new PatternException(Messages.assembly_error1);
        }
        Class templateClass = context.getBundle(this.getBundleId()).loadClass(templateClassName);
        return templateClass;
    }

    public void translate() throws PatternException {
        Pattern pattern = this.getPattern();
        if (pattern == null) {
            throw new IllegalStateException();
        }
        JetAssemblyHelper helper = new JetAssemblyHelper(this.getPattern(), new JetAssemblyContentProvider(this.getPattern()));
        String templatecontent = helper.visit();
        String templateURI = "Pattern_" + pattern.getName() + " (" + pattern.getID() + ")";
        try {
            SkeletonJETCompiler compiler = new SkeletonJETCompiler(templateURI, new ByteArrayInputStream(templatecontent.getBytes()), JetPreferences.getEncoding());
            compiler.parse();
            if (pattern.getSuperPattern() != null) {
                Pattern parentPattern = pattern.getSuperPattern();
                ((SkeletonJETCompiler.CustomJETSkeleton)compiler.getSkeleton()).setParentClass(JetNatureHelper.getTemplateClassName(parentPattern));
            }
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            compiler.generate(outStream);
            String targetClassName = JetNatureHelper.getTemplateClassName(pattern);
            IPath outputPath = this.computeFilePath(targetClassName);
            IPlatformFcore platformFcore = PatternHelper.getPlatformFcore((PatternElement)this.getPattern());
            if (platformFcore == null) {
                throw new PatternException(Messages.bind((String)Messages.assembly_error4, (Object)pattern.getName(), (Object)pattern.getID()));
            }
            IProject project = platformFcore.getPlatformBundle().getProject();
            if (project == null) {
                throw new PatternException(Messages.bind((String)Messages.assembly_error5, (Object)pattern.getName(), (Object)pattern.getID()));
            }
            FileHelper.setContent((IFile)project.getFile(outputPath), (String)this.getContent(new String(outStream.toByteArray())));
        }
        catch (PatternException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatternException((Throwable)e);
        }
    }

    private String getContent(String content) {
        int indexOf;
        StringBuilder builder = new StringBuilder(content.length() + 500);
        int startIndex = content.indexOf("//Start of work");
        int endIndex = content.indexOf("//End of work");
        int insertionIndex = content.lastIndexOf(125);
        if (startIndex == -1 || endIndex == -1 || insertionIndex == -1) {
            return content;
        }
        builder.append(content.substring(0, startIndex));
        Pattern pattern = this.getPattern();
        builder.append("generate(ctx");
        if (!this.getPattern().getAllParameters().isEmpty()) {
            for (PatternParameter parameter : pattern.getAllParameters()) {
                String local = PatternHelper.localizeName((PatternParameter)parameter);
                builder.append(", ").append(local);
            }
        }
        builder.append(");");
        int startMethodIndex = content.indexOf("//Start of methods", endIndex);
        int endMethodIndex = content.indexOf("//End of methods", endIndex);
        if (startMethodIndex != -1 && endMethodIndex != -1) {
            builder.append(content.substring(endIndex + "//End of work".length(), startMethodIndex));
            builder.append(content.substring(endMethodIndex + "//End of methods".length(), insertionIndex));
        } else {
            builder.append(content.substring(endIndex + "//End of work".length(), insertionIndex));
        }
        builder.append("public String generate(PatternContext ctx");
        if (!this.getPattern().getAllParameters().isEmpty()) {
            for (PatternParameter parameter : pattern.getAllParameters()) {
                String local = PatternHelper.localizeName((PatternParameter)parameter);
                builder.append(", Object ").append(local);
            }
        }
        builder.append(") throws Exception  {").append(EGFCommonConstants.LINE_SEPARATOR);
        builder.append("InternalPatternContext ictx = (InternalPatternContext)ctx;").append(EGFCommonConstants.LINE_SEPARATOR);
        builder.append(content.substring(startIndex + "//Start of work".length(), endIndex));
        builder.append(EGFCommonConstants.LINE_SEPARATOR);
        builder.append("String loop = ictx.getBuffer().toString();").append(EGFCommonConstants.LINE_SEPARATOR);
        if (!this.getPattern().getAllParameters().isEmpty()) {
            builder.append("if (ictx.useReporter()){").append(EGFCommonConstants.LINE_SEPARATOR);
            builder.append("    ictx.getReporter().loopFinished(loop, ictx, parameterValues);").append(EGFCommonConstants.LINE_SEPARATOR);
            builder.append("ictx.getBuffer().setLength(0);}").append(EGFCommonConstants.LINE_SEPARATOR);
        }
        builder.append("return loop;").append(EGFCommonConstants.LINE_SEPARATOR);
        builder.append("} ").append(EGFCommonConstants.LINE_SEPARATOR);
        builder.append("").append(EGFCommonConstants.LINE_SEPARATOR);
        int startVariable = content.indexOf("//Start of init");
        int endVariable = content.indexOf("//End of init");
        if (startVariable != -1 && endVariable != -1 && (indexOf = builder.indexOf("//Here is the constructor")) != -1) {
            CharSequence sequence = content.subSequence(startVariable + "//Start of init".length(), endVariable);
            builder.insert(indexOf += "//Here is the constructor".length(), sequence);
            builder.insert(indexOf, "\nStringBuffer stringBuffer = new StringBuffer();\n");
            startVariable = builder.indexOf("//Start of init");
            endVariable = builder.indexOf("//End of init");
            if (startVariable != -1 && endVariable != -1) {
                builder.delete(startVariable, endVariable + "//End of init".length());
            }
        }
        for (PatternVariable var : pattern.getVariables()) {
            builder.append("protected ").append(ParameterTypeHelper.INSTANCE.getTypeLiteral(var.getType())).append(" ").append(var.getName()).append(" = null;").append(EGFCommonConstants.LINE_SEPARATOR);
        }
        if (startMethodIndex != -1 && endMethodIndex != -1) {
            builder.append(content.substring(startMethodIndex + "//Start of methods".length(), endMethodIndex));
        }
        builder.append(content.substring(insertionIndex));
        return builder.toString();
    }

    private IPath computeFilePath(String classname) {
        String[] names;
        Path result = new Path(PatternPreferences.getGenerationFolderName());
        String[] stringArray = names = classname.split("\\.");
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            result = result.append(name);
            ++n2;
        }
        result = result.addFileExtension("java");
        return result;
    }
}

