/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.common.EGFCommonPlugin;
import org.eclipse.osgi.util.NLS;

public class ExtensionPointHelper {
    public static final String ATT_CLASS = "class";
    public static final String ATT_NAME = "name";
    public static final String ATT_ID = "id";
    public static final String ELEMENT_DESCRIPTION = "description";

    private ExtensionPointHelper() {
    }

    public static IConfigurationElement[] getConfigurationElements(String pluginId, String extensionPointId) {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(pluginId, extensionPointId);
    }

    public static IConfigurationElement[] getConfigurationElements(String pluginId, String extensionPointId, String extensionDeclaringPluginId) {
        IConfigurationElement[] allElements;
        ArrayList<IConfigurationElement> resultingElements = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = allElements = ExtensionPointHelper.getConfigurationElements(pluginId, extensionPointId);
        int n = allElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (ExtensionPointHelper.isDeclaredBy(configurationElement, extensionDeclaringPluginId)) {
                resultingElements.add(configurationElement);
            }
            ++n2;
        }
        return resultingElements.toArray(new IConfigurationElement[resultingElements.size()]);
    }

    public static boolean isDeclaredBy(IConfigurationElement configurationElement, String pluginId) {
        return configurationElement != null && pluginId != null && pluginId.equals(configurationElement.getContributor().getName());
    }

    public static IConfigurationElement getConfigurationElement(String pluginId, String extensionId, String idValue) {
        return ExtensionPointHelper.getConfigurationElement(pluginId, extensionId, ATT_ID, idValue);
    }

    public static IConfigurationElement getConfigurationElement(String pluginId, String extensionId, String attributeName, String attributeValue) {
        IConfigurationElement[] configElements = ExtensionPointHelper.getConfigurationElements(pluginId, extensionId);
        IConfigurationElement result = null;
        int i = 0;
        while (i < configElements.length && result == null) {
            IConfigurationElement configElement = configElements[i];
            if (ExtensionPointHelper.hasValue(configElement, attributeName, attributeValue)) {
                result = configElement;
            }
            ++i;
        }
        return result;
    }

    public static boolean hasValue(IConfigurationElement configurationElement, String attributeName, String attributeValue) {
        boolean result = false;
        if (configurationElement == null || attributeName == null || attributeValue == null) {
            return result;
        }
        String innerAttributeValue = configurationElement.getAttribute(attributeName);
        result = attributeValue.equals(innerAttributeValue);
        return result;
    }

    public static String getId(IConfigurationElement configurationElement) {
        String result = null;
        if (configurationElement != null) {
            result = configurationElement.getAttribute(ATT_ID);
        }
        return result;
    }

    public static String getAttributeValue(IConfigurationElement configurationElement, String attribute) {
        String result = null;
        if (configurationElement != null && attribute != null) {
            result = configurationElement.getAttribute(attribute);
        }
        return result;
    }

    public static Object createExecutableExtension(String pluginId, String extensionPointId, String attributeId, String attributeValue) throws CoreException {
        IConfigurationElement[] configElements = ExtensionPointHelper.getConfigurationElements(pluginId, extensionPointId);
        if (configElements.length == 0) {
            throw new CoreException(EGFCommonPlugin.getDefault().newStatus(4, NLS.bind((String)"ExtensionPointHelper.createExecutableExtension(..) _ extensionPointId ''{0}'' should exist.", (Object)extensionPointId), null));
        }
        boolean isMatchingImperative = false;
        if (attributeId != null && attributeValue != null) {
            isMatchingImperative = true;
        }
        int i = 0;
        while (i < configElements.length) {
            String innerAttributeValue;
            IConfigurationElement configElement = configElements[i];
            boolean isExecutableExtensionCreatable = true;
            if (isMatchingImperative && !attributeValue.equals(innerAttributeValue = configElement.getAttribute(attributeId))) {
                isExecutableExtensionCreatable = false;
            }
            if (isExecutableExtensionCreatable) {
                return ExtensionPointHelper.createInstance(configElement);
            }
            ++i;
        }
        return null;
    }

    public static Object createExecutableExtension(String pluginId, String extensionPointId, String idValue) throws CoreException {
        return ExtensionPointHelper.createExecutableExtension(pluginId, extensionPointId, ATT_ID, idValue);
    }

    public static Object createInstance(IConfigurationElement configurationElement) throws CoreException {
        return ExtensionPointHelper.createInstance(configurationElement, ATT_CLASS);
    }

    public static Object createInstance(IConfigurationElement configurationElement, String attributeName) throws CoreException {
        return configurationElement.createExecutableExtension(attributeName);
    }

    public static String getExtensionPointId(String pluginId, String extensionPointId) {
        return pluginId + "." + extensionPointId;
    }

    public static String getNamespace(IConfigurationElement configurationElement) {
        if (configurationElement == null) {
            return null;
        }
        return configurationElement.getContributor().getName();
    }
}

