/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.collector;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.fcore.Viewpoint;
import org.eclipse.egf.model.fcore.ViewpointContainer;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.egf.model.pattern.PatternViewpoint;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Collector<E extends PatternElement> {
    public static final Set<String> EMPTY_ID_SET = new HashSet<String>();

    protected Collector() {
    }

    protected final void doCollect(EObject source, List<E> result, Set<String> ids) {
        if (FcorePackage.eINSTANCE.equals(source.eClass().getEPackage())) {
            switch (source.eClass().getClassifierID()) {
                case 4: {
                    ViewpointContainer viewpointContainer = ((FactoryComponent)source).getViewpointContainer();
                    if (viewpointContainer != null) {
                        for (Viewpoint viewpoint : viewpointContainer.getViewpoints()) {
                            this.doCollect((EObject)viewpoint, result, ids);
                        }
                    }
                    return;
                }
            }
        } else if (PatternPackage.eINSTANCE.equals(source.eClass().getEPackage())) {
            switch (source.eClass().getClassifierID()) {
                case 5: {
                    this.casePatternViewpoint((PatternViewpoint)source, result, ids);
                    return;
                }
                case 3: {
                    this.casePatternLibrary((PatternLibrary)source, result, ids);
                    return;
                }
                case 0: {
                    this.casePattern((Pattern)source, result, ids);
                    return;
                }
            }
        }
    }

    protected void casePattern(Pattern source, List<E> result, Set<String> ids) {
    }

    protected void casePatternLibrary(PatternLibrary source, List<E> result, Set<String> ids) {
        for (PatternElement elem : source.getElements()) {
            this.doCollect((EObject)elem, result, ids);
        }
    }

    protected void casePatternViewpoint(PatternViewpoint source, List<E> result, Set<String> ids) {
        for (PatternLibrary lib : source.getLibraries()) {
            this.doCollect((EObject)lib, result, ids);
        }
    }

    public void collect(EObject source, List<E> result) {
        this.collect(source, result, EMPTY_ID_SET);
    }

    public void collect(EObject source, List<E> result, Set<String> ids) {
        if (ids == null) {
            throw new IllegalArgumentException();
        }
        if (result == null) {
            throw new IllegalArgumentException();
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.doCollect(source, result, ids);
    }

    public void collect(List<EObject> source, List<E> result) {
        this.collect(source, result, EMPTY_ID_SET);
    }

    public void collect(List<EObject> source, List<E> result, Set<String> ids) {
        if (ids == null) {
            throw new IllegalArgumentException();
        }
        if (result == null) {
            throw new IllegalArgumentException();
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        for (EObject obj : source) {
            this.collect(obj, result, ids);
        }
    }

    public void collect(EObject[] source, List<E> result) {
        this.collect(source, result, EMPTY_ID_SET);
    }

    public void collect(EObject[] source, List<E> result, Set<String> ids) {
        if (ids == null) {
            throw new IllegalArgumentException();
        }
        if (result == null) {
            throw new IllegalArgumentException();
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        EObject[] eObjectArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            EObject obj = eObjectArray[n2];
            this.collect(obj, result, ids);
            ++n2;
        }
    }
}

