/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.text.ide.contentassist;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.elk.core.data.ILayoutMetaData;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutDataContentAssist;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.impl.ElkPropertyToValueMapEntryImpl;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.text.services.ElkGraphGrammarAccess;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.conversion.impl.IDValueConverter;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IProposalConflictHelper;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ElkGraphProposalProvider
extends IdeContentProposalProvider {
    private static final Set<String> DISABLED_KEYWORDS = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new String[]{"}", "]"}));
    private ElkGraphGrammarAccess grammar;
    private IDValueConverter idValueConverter;
    @Inject
    private IProposalConflictHelper conflictHelper;
    public static final String DISCO_LAYOUT_ALG_ID = "org.eclipse.elk.disco.componentCompaction.componentLayoutAlgorithm";

    @Inject
    public void initialize(Provider<IDValueConverter> idValueConverterProvider, ElkGraphGrammarAccess grammarAccess) {
        IDValueConverter _doubleArrow;
        IDValueConverter _get = (IDValueConverter)idValueConverterProvider.get();
        Procedures.Procedure1 _function = it -> it.setRule((AbstractRule)grammarAccess.getIDRule());
        this.idValueConverter = _doubleArrow = (IDValueConverter)ObjectExtensions.operator_doubleArrow((Object)_get, (Procedures.Procedure1)_function);
        this.grammar = grammarAccess;
    }

    protected boolean filterKeyword(Keyword keyword, ContentAssistContext context) {
        return !DISABLED_KEYWORDS.contains(keyword.getValue()) && !Objects.equals(keyword.getValue(), context.getPrefix());
    }

    protected void _createProposals(Keyword keyword, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        ContentAssistEntry entry;
        boolean _filterKeyword = this.filterKeyword(keyword, context);
        if (_filterKeyword && (entry = this.getProposalCreator().createProposal(keyword.getValue(), context)) != null) {
            entry.setKind("KEYWORD");
            entry.setSource((Object)keyword);
            acceptor.accept(entry, this.getProposalPriorities().getKeywordPriority(keyword.getValue(), entry));
        }
    }

    protected void _createProposals(Assignment assignment, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        boolean _matched = false;
        Assignment _keyAssignment_0 = this.grammar.getPropertyAccess().getKeyAssignment_0();
        if (Objects.equals(assignment, _keyAssignment_0)) {
            _matched = true;
            this.completePropertyKey(context, acceptor);
        }
        if (!_matched) {
            Assignment _valueAssignment_2_3;
            Assignment _valueAssignment_2_2;
            Assignment _valueAssignment_2_1;
            Assignment _valueAssignment_2_0 = this.grammar.getPropertyAccess().getValueAssignment_2_0();
            if (Objects.equals(assignment, _valueAssignment_2_0)) {
                _matched = true;
            }
            if (!_matched && Objects.equals(assignment, _valueAssignment_2_1 = this.grammar.getPropertyAccess().getValueAssignment_2_1())) {
                _matched = true;
            }
            if (!_matched && Objects.equals(assignment, _valueAssignment_2_2 = this.grammar.getPropertyAccess().getValueAssignment_2_2())) {
                _matched = true;
            }
            if (!_matched && Objects.equals(assignment, _valueAssignment_2_3 = this.grammar.getPropertyAccess().getValueAssignment_2_3())) {
                _matched = true;
            }
            if (_matched) {
                this.completePropertyValue(context, acceptor);
            }
        }
        if (!_matched) {
            super._createProposals(assignment, context, acceptor);
        }
    }

    protected void completePropertyKey(ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        boolean _existsConflict = this.conflictHelper.existsConflict("a", context);
        if (_existsConflict) {
            return;
        }
        EObject model = context.getCurrentModel();
        if (model instanceof ElkGraphElement) {
            Consumer<LayoutDataContentAssist.Proposal> _function = p -> {
                ContentAssistEntry _contentAssistEntry = new ContentAssistEntry();
                Procedures.Procedure1 _function_1 = it -> {
                    it.setProposal(this.convert(Strings.split((String)proposal.proposal, (String)".")));
                    it.setPrefix(context.getPrefix());
                    it.setKind("PROPERTY");
                    String _elvis = null;
                    _elvis = proposal.label != null ? proposal.label : proposal.proposal;
                    it.setLabel(_elvis);
                    it.setDescription(this.getDescription((ILayoutMetaData)proposal.data));
                    it.setDocumentation(((LayoutOptionData)proposal.data).getDescription());
                    it.setSource(proposal.data);
                };
                ContentAssistEntry entry = (ContentAssistEntry)ObjectExtensions.operator_doubleArrow((Object)_contentAssistEntry, (Procedures.Procedure1)_function_1);
                acceptor.accept(entry, this.getProposalPriorities().getDefaultPriority(entry));
            };
            LayoutDataContentAssist.getLayoutOptionProposals((ElkGraphElement)((ElkGraphElement)model), (String)context.getPrefix()).forEach(_function);
        }
    }

    protected void completePropertyValue(ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        IProperty option;
        EObject model = context.getCurrentModel();
        if (model instanceof ElkPropertyToValueMapEntryImpl && (option = ((ElkPropertyToValueMapEntryImpl)model).getKey()) instanceof LayoutOptionData) {
            if (Objects.equals(CoreOptions.ALGORITHM, option) || Objects.equals(((LayoutOptionData)option).getId(), DISCO_LAYOUT_ALG_ID)) {
                this.proposeAlgorithms(context, acceptor);
            } else {
                this.typeAwarePropertyValueProposal((LayoutOptionData)option, context, acceptor);
            }
        }
    }

    private void typeAwarePropertyValueProposal(LayoutOptionData property, ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        Consumer<LayoutDataContentAssist.Proposal> _function = p -> {
            Procedures.Procedure1 _function_1 = it -> {
                it.setLabel(proposal.label);
                it.setSource((Object)property);
            };
            ContentAssistEntry entry = this.getProposalCreator().createProposal(p.proposal, context, "VALUE", _function_1);
            acceptor.accept(entry, this.getProposalPriorities().getDefaultPriority(entry));
        };
        LayoutDataContentAssist.getLayoutOptionValueProposal((LayoutOptionData)property, (String)context.getPrefix()).forEach(_function);
    }

    protected void proposeAlgorithms(ContentAssistContext context, IIdeContentProposalAcceptor acceptor) {
        boolean _existsConflict = this.conflictHelper.existsConflict("a", context);
        if (_existsConflict) {
            return;
        }
        Consumer<LayoutDataContentAssist.Proposal> _function = p -> {
            ContentAssistEntry _contentAssistEntry = new ContentAssistEntry();
            Procedures.Procedure1 _function_1 = it -> {
                it.setProposal(this.convert(Strings.split((String)proposal.proposal, (String)".")));
                it.setPrefix(context.getPrefix());
                it.setKind("VALUE");
                String _elvis = null;
                _elvis = proposal.label != null ? proposal.label : proposal.proposal;
                it.setLabel(_elvis);
                it.setDescription(this.getDescription((ILayoutMetaData)proposal.data));
                it.setDocumentation(((LayoutAlgorithmData)proposal.data).getDescription());
                it.setSource(proposal.data);
            };
            ContentAssistEntry entry = (ContentAssistEntry)ObjectExtensions.operator_doubleArrow((Object)_contentAssistEntry, (Procedures.Procedure1)_function_1);
            acceptor.accept(entry, this.getProposalPriorities().getDefaultPriority(entry));
        };
        LayoutDataContentAssist.getLayoutAlgorithmProposals((String)context.getPrefix()).forEach(_function);
    }

    private String convert(Iterable<String> suffix) {
        Functions.Function1 _function = it -> this.idValueConverter.toString(it);
        return IterableExtensions.join((Iterable)IterableExtensions.map(suffix, (Functions.Function1)_function), (CharSequence)".");
    }

    private String getDescription(ILayoutMetaData data) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = data.getName();
        _builder.append(_name);
        _builder.append(" (");
        String _id = data.getId();
        _builder.append(_id);
        _builder.append(")");
        return _builder.toString();
    }

    protected Predicate<IEObjectDescription> getCrossrefFilter(CrossReference reference, ContentAssistContext context) {
        EObject model = context.getCurrentModel();
        if (model instanceof ElkEdgeSection) {
            CrossReference _incomingShapeElkConnectableShapeCrossReference_1_0_0_2_0;
            boolean _matched = false;
            CrossReference _incomingShapeElkConnectableShapeCrossReference_4_0_0_2_0 = this.grammar.getElkEdgeSectionAccess().getIncomingShapeElkConnectableShapeCrossReference_4_0_0_2_0();
            if (Objects.equals(reference, _incomingShapeElkConnectableShapeCrossReference_4_0_0_2_0)) {
                _matched = true;
            }
            if (!_matched && Objects.equals(reference, _incomingShapeElkConnectableShapeCrossReference_1_0_0_2_0 = this.grammar.getElkSingleEdgeSectionAccess().getIncomingShapeElkConnectableShapeCrossReference_1_0_0_2_0())) {
                _matched = true;
            }
            if (_matched) {
                return new SectionShapeFilter((ElkEdgeSection)model, 0);
            }
            if (!_matched) {
                CrossReference _outgoingShapeElkConnectableShapeCrossReference_1_0_1_2_0;
                CrossReference _outgoingShapeElkConnectableShapeCrossReference_4_0_1_2_0 = this.grammar.getElkEdgeSectionAccess().getOutgoingShapeElkConnectableShapeCrossReference_4_0_1_2_0();
                if (Objects.equals(reference, _outgoingShapeElkConnectableShapeCrossReference_4_0_1_2_0)) {
                    _matched = true;
                }
                if (!_matched && Objects.equals(reference, _outgoingShapeElkConnectableShapeCrossReference_1_0_1_2_0 = this.grammar.getElkSingleEdgeSectionAccess().getOutgoingShapeElkConnectableShapeCrossReference_1_0_1_2_0())) {
                    _matched = true;
                }
                if (_matched) {
                    return new SectionShapeFilter((ElkEdgeSection)model, 1);
                }
            }
        }
        URI resourceURI = model.eResource().getURI();
        Predicate _function = candidate -> {
            URI _trimFragment = candidate.getEObjectURI().trimFragment();
            return Objects.equals(_trimFragment, resourceURI);
        };
        return _function;
    }

    @FinalFieldsConstructor
    public static class SectionShapeFilter
    implements Predicate<IEObjectDescription> {
        private static final int INCOMING = 0;
        private static final int OUTGOING = 1;
        private final ElkEdgeSection section;
        private final int type;

        public boolean apply(IEObjectDescription input) {
            boolean _switchResult = false;
            int type = this.type;
            switch (type) {
                case 0: {
                    _switchResult = this.isInList(input, (List<? extends EObject>)this.section.getParent().getSources());
                    break;
                }
                case 1: {
                    _switchResult = this.isInList(input, (List<? extends EObject>)this.section.getParent().getTargets());
                    break;
                }
                default: {
                    _switchResult = true;
                }
            }
            return _switchResult;
        }

        private boolean isInList(IEObjectDescription input, List<? extends EObject> list) {
            boolean _xblockexpression = false;
            EObject object = input.getEObjectOrProxy();
            boolean _xifexpression = false;
            boolean _eIsProxy = object.eIsProxy();
            if (_eIsProxy) {
                Functions.Function1 _function = it -> {
                    URI _uRI = EcoreUtil.getURI((EObject)it);
                    URI _eObjectURI = input.getEObjectURI();
                    return Objects.equals(_uRI, _eObjectURI);
                };
                _xifexpression = IterableExtensions.exists(list, (Functions.Function1)_function);
            } else {
                _xifexpression = list.contains(object);
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }

        public SectionShapeFilter(ElkEdgeSection section, int type) {
            this.section = section;
            this.type = type;
        }
    }
}

