/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LInsets;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.nodespacing.LabelSide;

public final class EndLabelProcessor
implements ILayoutProcessor {
    private Map<LNode, Double> northOffset;
    private Map<LNode, Double> southOffset;
    private Map<LPort, Double> portLabelOffsetHint;

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("End label placement", 1.0f);
        float labelSpacing = ((Float)layeredGraph.getProperty(LayeredOptions.SPACING_LABEL)).floatValue();
        this.northOffset = Maps.newHashMap();
        this.southOffset = Maps.newHashMap();
        this.portLabelOffsetHint = Maps.newHashMap();
        for (Layer layer : layeredGraph.getLayers()) {
            for (LNode node : layer.getNodes()) {
                for (LEdge edge : node.getOutgoingEdges()) {
                    for (LLabel label : edge.getLabels()) {
                        if (label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT) != EdgeLabelPlacement.TAIL && label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT) != EdgeLabelPlacement.HEAD) continue;
                        this.placeEndLabel(node, edge, label, labelSpacing);
                    }
                }
            }
        }
        monitor.done();
    }

    private void placeEndLabel(LNode node, LEdge edge, LLabel label, double labelSpacing) {
        LPort port = null;
        if (label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT) == EdgeLabelPlacement.TAIL) {
            port = edge.getSource();
        } else if (label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT) == EdgeLabelPlacement.HEAD) {
            port = edge.getTarget();
        }
        if (!this.northOffset.containsKey((Object)port.getNode())) {
            this.northOffset.put(port.getNode(), 0.0);
        }
        if (!this.southOffset.containsKey((Object)port.getNode())) {
            this.southOffset.put(port.getNode(), 0.0);
        }
        if (!this.portLabelOffsetHint.containsKey((Object)port)) {
            this.portLabelOffsetHint.put(port, 0.0);
        }
        if (label.getProperty(InternalProperties.LABEL_SIDE) == LabelSide.ABOVE) {
            this.placeEndLabelUpwards(node, label, port, labelSpacing);
        } else {
            this.placeEndLabelDownwards(node, label, port, labelSpacing);
        }
    }

    private void placeEndLabelDownwards(LNode node, LLabel label, LPort port, double labelSpacing) {
        KVector labelPosition = label.getPosition();
        KVector absolutePortPosition = KVector.sum((KVector[])new KVector[]{port.getPosition(), port.getNode().getPosition()});
        KVector absolutePortAnchor = port.getAbsoluteAnchor();
        LInsets portMargin = port.getMargin();
        switch (port.getSide()) {
            case WEST: {
                labelPosition.x = Math.min(absolutePortPosition.x, absolutePortAnchor.x) - portMargin.left - label.getSize().x - labelSpacing;
                labelPosition.y = port.getAbsoluteAnchor().y + labelSpacing;
                break;
            }
            case EAST: {
                labelPosition.x = Math.max(absolutePortPosition.x + port.getSize().x, absolutePortAnchor.x) + portMargin.right + labelSpacing;
                labelPosition.y = port.getAbsoluteAnchor().y + labelSpacing;
                break;
            }
            case NORTH: {
                labelPosition.x = port.getAbsoluteAnchor().x + labelSpacing;
                labelPosition.y = Math.min(absolutePortPosition.y, absolutePortAnchor.y) - portMargin.top - label.getSize().y - labelSpacing;
                break;
            }
            case SOUTH: {
                labelPosition.x = port.getAbsoluteAnchor().x + labelSpacing;
                labelPosition.y = Math.max(absolutePortPosition.y + port.getSize().y, absolutePortAnchor.y) + portMargin.bottom + labelSpacing;
            }
        }
    }

    private void placeEndLabelUpwards(LNode node, LLabel label, LPort port, double labelSpacing) {
        KVector labelPosition = label.getPosition();
        KVector absolutePortPosition = KVector.sum((KVector[])new KVector[]{port.getPosition(), port.getNode().getPosition()});
        KVector absolutePortAnchor = port.getAbsoluteAnchor();
        LInsets portMargin = port.getMargin();
        switch (port.getSide()) {
            case WEST: {
                labelPosition.x = Math.min(absolutePortPosition.x, absolutePortAnchor.x) - portMargin.left - label.getSize().x - labelSpacing;
                labelPosition.y = port.getAbsoluteAnchor().y - label.getSize().y - labelSpacing;
                break;
            }
            case EAST: {
                labelPosition.x = Math.max(absolutePortPosition.x + port.getSize().x, absolutePortAnchor.x) + portMargin.right + labelSpacing;
                labelPosition.y = port.getAbsoluteAnchor().y - label.getSize().y - labelSpacing;
                break;
            }
            case NORTH: {
                labelPosition.x = port.getAbsoluteAnchor().x + labelSpacing;
                labelPosition.y = Math.min(absolutePortPosition.y, absolutePortAnchor.y) - portMargin.top - label.getSize().y - labelSpacing;
                break;
            }
            case SOUTH: {
                labelPosition.x = port.getAbsoluteAnchor().x + labelSpacing;
                labelPosition.y = Math.max(absolutePortPosition.y + port.getSize().y, absolutePortAnchor.y) + portMargin.bottom + labelSpacing;
            }
        }
    }
}

