/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.intermediate.BigNodesIntermediateProcessor;
import org.eclipse.elk.alg.layered.intermediate.BigNodesPostProcessor;
import org.eclipse.elk.alg.layered.intermediate.BigNodesPreProcessor;
import org.eclipse.elk.alg.layered.intermediate.BigNodesSplitter;
import org.eclipse.elk.alg.layered.intermediate.CommentPostprocessor;
import org.eclipse.elk.alg.layered.intermediate.CommentPreprocessor;
import org.eclipse.elk.alg.layered.intermediate.EdgeAndLayerConstraintEdgeReverser;
import org.eclipse.elk.alg.layered.intermediate.EndLabelProcessor;
import org.eclipse.elk.alg.layered.intermediate.GraphTransformer;
import org.eclipse.elk.alg.layered.intermediate.HierarchicalPortConstraintProcessor;
import org.eclipse.elk.alg.layered.intermediate.HierarchicalPortDummySizeProcessor;
import org.eclipse.elk.alg.layered.intermediate.HierarchicalPortOrthogonalEdgeRouter;
import org.eclipse.elk.alg.layered.intermediate.HierarchicalPortPositionProcessor;
import org.eclipse.elk.alg.layered.intermediate.HighDegreeNodeLayeringProcessor;
import org.eclipse.elk.alg.layered.intermediate.HyperedgeDummyMerger;
import org.eclipse.elk.alg.layered.intermediate.HypernodesProcessor;
import org.eclipse.elk.alg.layered.intermediate.InLayerConstraintProcessor;
import org.eclipse.elk.alg.layered.intermediate.InteractiveExternalPortPositioner;
import org.eclipse.elk.alg.layered.intermediate.InvertedPortProcessor;
import org.eclipse.elk.alg.layered.intermediate.LabelAndNodeSizeProcessor;
import org.eclipse.elk.alg.layered.intermediate.LabelDummyInserter;
import org.eclipse.elk.alg.layered.intermediate.LabelDummyRemover;
import org.eclipse.elk.alg.layered.intermediate.LabelDummySwitcher;
import org.eclipse.elk.alg.layered.intermediate.LabelManagementProcessor;
import org.eclipse.elk.alg.layered.intermediate.LabelSideSelector;
import org.eclipse.elk.alg.layered.intermediate.LayerConstraintProcessor;
import org.eclipse.elk.alg.layered.intermediate.LayerSizeAndGraphHeightCalculator;
import org.eclipse.elk.alg.layered.intermediate.LongEdgeJoiner;
import org.eclipse.elk.alg.layered.intermediate.LongEdgeSplitter;
import org.eclipse.elk.alg.layered.intermediate.NodeMarginCalculator;
import org.eclipse.elk.alg.layered.intermediate.NodePromotion;
import org.eclipse.elk.alg.layered.intermediate.NorthSouthPortPostprocessor;
import org.eclipse.elk.alg.layered.intermediate.NorthSouthPortPreprocessor;
import org.eclipse.elk.alg.layered.intermediate.PartitionPostprocessor;
import org.eclipse.elk.alg.layered.intermediate.PartitionPreprocessor;
import org.eclipse.elk.alg.layered.intermediate.PortDistributionProcessor;
import org.eclipse.elk.alg.layered.intermediate.PortListSorter;
import org.eclipse.elk.alg.layered.intermediate.PortSideProcessor;
import org.eclipse.elk.alg.layered.intermediate.ReversedEdgeRestorer;
import org.eclipse.elk.alg.layered.intermediate.SausageFolding;
import org.eclipse.elk.alg.layered.intermediate.SelfLoopProcessor;
import org.eclipse.elk.alg.layered.intermediate.SemiInteractiveCrossMinProcessor;
import org.eclipse.elk.alg.layered.intermediate.SplineSelfLoopPositioner;
import org.eclipse.elk.alg.layered.intermediate.SplineSelfLoopPreProcessor;
import org.eclipse.elk.alg.layered.intermediate.SplineSelfLoopRouter;
import org.eclipse.elk.alg.layered.intermediate.compaction.HorizontalGraphCompactor;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.GreedySwitchProcessor;

public enum IntermediateProcessorStrategy {
    LEFT_DIR_PREPROCESSOR,
    DOWN_DIR_PREPROCESSOR,
    UP_DIR_PREPROCESSOR,
    COMMENT_PREPROCESSOR,
    EDGE_AND_LAYER_CONSTRAINT_EDGE_REVERSER,
    SPLINE_SELF_LOOP_PREPROCESSOR,
    INTERACTIVE_EXTERNAL_PORT_POSITIONER,
    PARTITION_PREPROCESSOR,
    BIG_NODES_PREPROCESSOR,
    LABEL_DUMMY_INSERTER,
    HIGH_DEGREE_NODE_LAYER_PROCESSOR,
    PARTITION_POSTPROCESSOR,
    NODE_PROMOTION,
    LAYER_CONSTRAINT_PROCESSOR,
    HIERARCHICAL_PORT_CONSTRAINT_PROCESSOR,
    BIG_NODES_INTERMEDIATEPROCESSOR,
    SEMI_INTERACTIVE_CROSSMIN_PROCESSOR,
    LONG_EDGE_SPLITTER,
    PORT_SIDE_PROCESSOR,
    LABEL_DUMMY_SWITCHER,
    LABEL_MANAGEMENT_PROCESSOR,
    INVERTED_PORT_PROCESSOR,
    SELF_LOOP_PROCESSOR,
    PORT_LIST_SORTER,
    NORTH_SOUTH_PORT_PREPROCESSOR,
    GREEDY_SWITCH,
    PORT_DISTRIBUTER,
    SPLINE_SELF_LOOP_POSITIONER,
    SAUSAGE_COMPACTION,
    IN_LAYER_CONSTRAINT_PROCESSOR,
    HYPEREDGE_DUMMY_MERGER,
    LABEL_SIDE_SELECTOR,
    BIG_NODES_SPLITTER,
    LABEL_AND_NODE_SIZE_PROCESSOR,
    SPLINE_SELF_LOOP_ROUTER,
    NODE_MARGIN_CALCULATOR,
    HIERARCHICAL_PORT_DUMMY_SIZE_PROCESSOR,
    HIERARCHICAL_PORT_POSITION_PROCESSOR,
    LAYER_SIZE_AND_GRAPH_HEIGHT_CALCULATOR,
    BIG_NODES_POSTPROCESSOR,
    COMMENT_POSTPROCESSOR,
    HYPERNODE_PROCESSOR,
    HIERARCHICAL_PORT_ORTHOGONAL_EDGE_ROUTER,
    LONG_EDGE_JOINER,
    NORTH_SOUTH_PORT_POSTPROCESSOR,
    LABEL_DUMMY_REMOVER,
    HORIZONTAL_COMPACTOR,
    REVERSED_EDGE_RESTORER,
    LEFT_DIR_POSTPROCESSOR,
    DOWN_DIR_POSTPROCESSOR,
    UP_DIR_POSTPROCESSOR,
    END_LABEL_PROCESSOR;


    public ILayoutProcessor create() {
        switch (this) {
            case BIG_NODES_INTERMEDIATEPROCESSOR: {
                return new BigNodesIntermediateProcessor();
            }
            case BIG_NODES_POSTPROCESSOR: {
                return new BigNodesPostProcessor();
            }
            case BIG_NODES_PREPROCESSOR: {
                return new BigNodesPreProcessor();
            }
            case BIG_NODES_SPLITTER: {
                return new BigNodesSplitter();
            }
            case COMMENT_POSTPROCESSOR: {
                return new CommentPostprocessor();
            }
            case COMMENT_PREPROCESSOR: {
                return new CommentPreprocessor();
            }
            case DOWN_DIR_PREPROCESSOR: 
            case DOWN_DIR_POSTPROCESSOR: {
                return new GraphTransformer(GraphTransformer.Mode.TRANSPOSE);
            }
            case EDGE_AND_LAYER_CONSTRAINT_EDGE_REVERSER: {
                return new EdgeAndLayerConstraintEdgeReverser();
            }
            case END_LABEL_PROCESSOR: {
                return new EndLabelProcessor();
            }
            case GREEDY_SWITCH: {
                return new GreedySwitchProcessor();
            }
            case HIERARCHICAL_PORT_CONSTRAINT_PROCESSOR: {
                return new HierarchicalPortConstraintProcessor();
            }
            case HIERARCHICAL_PORT_DUMMY_SIZE_PROCESSOR: {
                return new HierarchicalPortDummySizeProcessor();
            }
            case HIERARCHICAL_PORT_ORTHOGONAL_EDGE_ROUTER: {
                return new HierarchicalPortOrthogonalEdgeRouter();
            }
            case HIERARCHICAL_PORT_POSITION_PROCESSOR: {
                return new HierarchicalPortPositionProcessor();
            }
            case HIGH_DEGREE_NODE_LAYER_PROCESSOR: {
                return new HighDegreeNodeLayeringProcessor();
            }
            case HORIZONTAL_COMPACTOR: {
                return new HorizontalGraphCompactor();
            }
            case HYPEREDGE_DUMMY_MERGER: {
                return new HyperedgeDummyMerger();
            }
            case HYPERNODE_PROCESSOR: {
                return new HypernodesProcessor();
            }
            case IN_LAYER_CONSTRAINT_PROCESSOR: {
                return new InLayerConstraintProcessor();
            }
            case INTERACTIVE_EXTERNAL_PORT_POSITIONER: {
                return new InteractiveExternalPortPositioner();
            }
            case LABEL_AND_NODE_SIZE_PROCESSOR: {
                return new LabelAndNodeSizeProcessor();
            }
            case LABEL_DUMMY_INSERTER: {
                return new LabelDummyInserter();
            }
            case LABEL_DUMMY_REMOVER: {
                return new LabelDummyRemover();
            }
            case LABEL_DUMMY_SWITCHER: {
                return new LabelDummySwitcher();
            }
            case LABEL_MANAGEMENT_PROCESSOR: {
                return new LabelManagementProcessor();
            }
            case LABEL_SIDE_SELECTOR: {
                return new LabelSideSelector();
            }
            case LAYER_CONSTRAINT_PROCESSOR: {
                return new LayerConstraintProcessor();
            }
            case LAYER_SIZE_AND_GRAPH_HEIGHT_CALCULATOR: {
                return new LayerSizeAndGraphHeightCalculator();
            }
            case LEFT_DIR_PREPROCESSOR: 
            case LEFT_DIR_POSTPROCESSOR: {
                return new GraphTransformer(GraphTransformer.Mode.MIRROR_X);
            }
            case LONG_EDGE_JOINER: {
                return new LongEdgeJoiner();
            }
            case LONG_EDGE_SPLITTER: {
                return new LongEdgeSplitter();
            }
            case NODE_MARGIN_CALCULATOR: {
                return new NodeMarginCalculator();
            }
            case NODE_PROMOTION: {
                return new NodePromotion();
            }
            case NORTH_SOUTH_PORT_POSTPROCESSOR: {
                return new NorthSouthPortPostprocessor();
            }
            case NORTH_SOUTH_PORT_PREPROCESSOR: {
                return new NorthSouthPortPreprocessor();
            }
            case INVERTED_PORT_PROCESSOR: {
                return new InvertedPortProcessor();
            }
            case PARTITION_POSTPROCESSOR: {
                return new PartitionPostprocessor();
            }
            case PARTITION_PREPROCESSOR: {
                return new PartitionPreprocessor();
            }
            case PORT_DISTRIBUTER: {
                return new PortDistributionProcessor();
            }
            case PORT_LIST_SORTER: {
                return new PortListSorter();
            }
            case PORT_SIDE_PROCESSOR: {
                return new PortSideProcessor();
            }
            case REVERSED_EDGE_RESTORER: {
                return new ReversedEdgeRestorer();
            }
            case SAUSAGE_COMPACTION: {
                return new SausageFolding();
            }
            case SELF_LOOP_PROCESSOR: {
                return new SelfLoopProcessor();
            }
            case SEMI_INTERACTIVE_CROSSMIN_PROCESSOR: {
                return new SemiInteractiveCrossMinProcessor();
            }
            case SPLINE_SELF_LOOP_POSITIONER: {
                return new SplineSelfLoopPositioner();
            }
            case SPLINE_SELF_LOOP_PREPROCESSOR: {
                return new SplineSelfLoopPreProcessor();
            }
            case SPLINE_SELF_LOOP_ROUTER: {
                return new SplineSelfLoopRouter();
            }
            case UP_DIR_PREPROCESSOR: 
            case UP_DIR_POSTPROCESSOR: {
                return new GraphTransformer(GraphTransformer.Mode.MIRROR_AND_TRANSPOSE);
            }
        }
        throw new IllegalArgumentException("No implementation is available for the layout processor " + this.toString());
    }
}

