/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p4nodes;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.elk.alg.layered.ILayoutPhase;
import org.eclipse.elk.alg.layered.IntermediateProcessingConfiguration;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.networksimplex.NEdge;
import org.eclipse.elk.alg.layered.networksimplex.NGraph;
import org.eclipse.elk.alg.layered.networksimplex.NNode;
import org.eclipse.elk.alg.layered.networksimplex.NetworkSimplex;
import org.eclipse.elk.alg.layered.properties.GraphProperties;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.alg.layered.properties.Spacings;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class NetworkSimplexPlacer
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration HIERARCHY_PROCESSING_ADDITIONS = IntermediateProcessingConfiguration.createEmpty().addBeforePhase5(IntermediateProcessorStrategy.HIERARCHICAL_PORT_POSITION_PROCESSOR);

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        if (((Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            return HIERARCHY_PROCESSING_ADDITIONS;
        }
        return null;
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        Spacings spacings = (Spacings)layeredGraph.getProperty(InternalProperties.SPACINGS);
        HashMap nodeMap = Maps.newHashMap();
        int nodeCnt = 0;
        NGraph graph = new NGraph();
        for (Layer l : layeredGraph) {
            LNode prevL = null;
            Object prev = null;
            for (LNode lNode : l) {
                ++nodeCnt;
                NNode nNode = NNode.of().create(graph);
                nNode.origin = lNode;
                nodeMap.put(lNode, nNode);
                lNode.getMargin().top = Math.ceil(lNode.getMargin().top);
                if (prev != null) {
                    NEdge nEdge = new NEdge();
                    nEdge.weight = 0.0;
                    nEdge.delta = (int)Math.floor(prevL.getMargin().top + prevL.getSize().y + prevL.getMargin().bottom + (double)spacings.getVerticalSpacing((LNode)((Object)((NNode)prev).origin), lNode));
                    nEdge.source = prev;
                    nEdge.target = nNode;
                    ((NNode)prev).getOutgoingEdges().add(nEdge);
                    nNode.getIncomingEdges().add(nEdge);
                }
                prevL = lNode;
                prev = nNode;
            }
        }
        for (Layer l : layeredGraph) {
            for (LNode lNode : l) {
                for (LPort p : lNode.getPorts()) {
                    double y = p.getPosition().y + p.getAnchor().y;
                    if (y == Math.floor(y)) continue;
                    double offset = y - (double)Math.round(y);
                    p.getPosition().y -= offset;
                }
            }
        }
        for (Layer l : layeredGraph) {
            for (LNode lNode : l) {
                for (LEdge lEdge : lNode.getOutgoingEdges()) {
                    if (lEdge.isSelfLoop() || lEdge.getTarget().getNode().getLayer() == l) continue;
                    double sourceY = lEdge.getSource().getNode().getMargin().top + lEdge.getSource().getPosition().y + lEdge.getSource().getAnchor().y;
                    double targetY = lEdge.getTarget().getNode().getMargin().top + lEdge.getTarget().getPosition().y + lEdge.getTarget().getAnchor().y;
                    double delta = targetY - sourceY;
                    int portOffset = (int)delta;
                    assert (delta == Math.floor(delta));
                    NNode dummy = NNode.of().create(graph);
                    NEdge leftEdge = new NEdge();
                    leftEdge.origin = lEdge;
                    leftEdge.weight = this.getEdgeWeight(lEdge);
                    leftEdge.delta = portOffset > 0 ? portOffset : 0;
                    leftEdge.source = dummy;
                    leftEdge.target = (NNode)nodeMap.get((Object)lEdge.getSource().getNode());
                    leftEdge.source.getOutgoingEdges().add(leftEdge);
                    leftEdge.target.getIncomingEdges().add(leftEdge);
                    NEdge rightEdge = new NEdge();
                    rightEdge.origin = lEdge;
                    rightEdge.weight = this.getEdgeWeight(lEdge);
                    rightEdge.delta = portOffset < 0 ? -portOffset : 0;
                    rightEdge.source = dummy;
                    rightEdge.target = (NNode)nodeMap.get((Object)lEdge.getTarget().getNode());
                    rightEdge.source.getOutgoingEdges().add(rightEdge);
                    rightEdge.target.getIncomingEdges().add(rightEdge);
                }
            }
        }
        int iterLimit = (Integer)layeredGraph.getProperty(LayeredOptions.THOROUGHNESS) * (int)Math.sqrt(nodeCnt);
        NetworkSimplex.forGraph(graph).withIterationLimit(iterLimit).withBalancing(false).execute(progressMonitor.subTask(1.0f));
        for (NNode n : graph.nodes) {
            if (n.origin == null) continue;
            LNode lNode = (LNode)((Object)n.origin);
            lNode.getPosition().y = (double)n.layer + lNode.getMargin().top;
        }
    }

    private int getEdgeWeight(LEdge edge) {
        int priority = Math.max(1, (Integer)edge.getProperty(LayeredOptions.PRIORITY));
        int edgeTypeWeight = edge.getSource().getNode().getType() == LNode.NodeType.NORMAL && edge.getTarget().getNode().getType() == LNode.NodeType.NORMAL ? 1 : (edge.getSource().getNode().getType() == LNode.NodeType.NORMAL || edge.getTarget().getNode().getType() == LNode.NodeType.NORMAL ? 2 : 8);
        return priority * edgeTypeWeight;
    }
}

