/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui.views;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.elk.core.GraphIssue;
import org.eclipse.elk.core.LayoutOptionValidator;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.service.ILayoutConfigurationStore;
import org.eclipse.elk.core.service.LayoutConfigurationManager;
import org.eclipse.elk.core.ui.Messages;
import org.eclipse.elk.core.ui.util.ElkUiUtil;
import org.eclipse.elk.core.ui.views.LayoutPropertyDescriptor;
import org.eclipse.elk.core.ui.views.LayoutViewPart;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class LayoutPropertySource
implements IPropertySource {
    private ILayoutConfigurationStore layoutConfig;
    private IPropertyDescriptor[] propertyDescriptors;
    private final Set<String> dependencyOptions = new HashSet<String>();
    private final LayoutConfigurationManager configManager;
    private LayoutOptionValidator layoutOptionValidator;

    public LayoutPropertySource(ILayoutConfigurationStore config, LayoutConfigurationManager manager) {
        this.layoutConfig = config;
        this.configManager = manager;
    }

    public void setValidator(LayoutOptionValidator validator) {
        this.layoutOptionValidator = validator;
    }

    protected ILayoutConfigurationStore getLayoutConfig() {
        return this.layoutConfig;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            List optionData = this.configManager.getSupportedOptions(this.layoutConfig);
            this.filterOptions(optionData);
            this.propertyDescriptors = new IPropertyDescriptor[optionData.size()];
            ListIterator optionIter = optionData.listIterator();
            while (optionIter.hasNext()) {
                LayoutOptionData data = (LayoutOptionData)optionIter.next();
                this.propertyDescriptors[optionIter.previousIndex()] = this.createPropertyDescriptor(data);
            }
        }
        return this.propertyDescriptors;
    }

    protected IPropertyDescriptor createPropertyDescriptor(LayoutOptionData data) {
        return new LayoutPropertyDescriptor(this, data, this.layoutConfig.getOptionTargets());
    }

    protected void filterOptions(List<LayoutOptionData> optionData) {
        this.dependencyOptions.add(CoreOptions.ALGORITHM.getId());
        ListIterator<LayoutOptionData> optionIter = optionData.listIterator();
        while (optionIter.hasNext()) {
            boolean visible;
            LayoutOptionData option = optionIter.next();
            boolean bl = visible = option.getVisibility() != LayoutOptionData.Visibility.HIDDEN;
            if (visible) {
                visible = option.getDependencies().isEmpty();
                for (Pair dependency : option.getDependencies()) {
                    LayoutOptionData targetOption = (LayoutOptionData)dependency.getFirst();
                    this.dependencyOptions.add(targetOption.getId());
                    Object expectedValue = dependency.getSecond();
                    Object value = this.configManager.getOptionValue(targetOption, this.layoutConfig);
                    if ((expectedValue != null || value == null) && (expectedValue == null || !expectedValue.equals(value))) continue;
                    visible = true;
                    break;
                }
            }
            if (visible) continue;
            optionIter.remove();
        }
    }

    public Object getPropertyValue(Object id) {
        LayoutMetaDataService layoutServices = LayoutMetaDataService.getInstance();
        LayoutOptionData optionData = layoutServices.getOptionData((String)id);
        if (optionData != null) {
            Object value = this.configManager.getOptionValue(optionData, this.layoutConfig);
            return this.translateToUI(value, optionData);
        }
        return null;
    }

    public Object translateToUI(Object value, LayoutOptionData optionData) {
        if (value == null) {
            return "";
        }
        switch (optionData.getType()) {
            case INT: 
            case FLOAT: {
                return value.toString();
            }
            case BOOLEAN: {
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? 1 : 0;
                }
                if (value instanceof String) {
                    return Boolean.valueOf((String)value) != false ? 1 : 0;
                }
                return value;
            }
            case ENUM: {
                if (value instanceof Enum) {
                    return ((Enum)value).ordinal();
                }
                if (value instanceof String) {
                    String[] choices = optionData.getChoices();
                    int i = 0;
                    while (i < choices.length) {
                        if (choices[i].equals(value)) {
                            return i;
                        }
                        ++i;
                    }
                    return 0;
                }
                return value;
            }
            case ENUMSET: {
                Set set = (Set)value;
                String[] result = new String[set.size()];
                Iterator iterator = set.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    result[i] = o instanceof Enum ? ((Enum)o).name() : (String)o;
                    ++i;
                }
                return result;
            }
            case OBJECT: {
                return value.toString();
            }
        }
        return value;
    }

    public void setPropertyValue(Object id, final Object thevalue) {
        final LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionData((String)id);
        if (optionData != null) {
            LayoutViewPart layoutView;
            Runnable modelChange = new Runnable(){

                @Override
                public void run() {
                    Object value = LayoutPropertySource.this.translateFromUI(thevalue, optionData);
                    LayoutPropertySource.this.layoutConfig.setOptionValue(optionData.getId(), value.toString());
                }
            };
            ElkUiUtil.runModelChange(modelChange, this.layoutConfig.getEditingDomain(), Messages.getString("kiml.ui.11"));
            if (this.dependencyOptions.contains(id) && (layoutView = LayoutViewPart.findView()) != null) {
                layoutView.refresh();
            }
        }
    }

    public Object translateFromUI(Object value, LayoutOptionData optionData) {
        switch (optionData.getType()) {
            case STRING: {
                return (String)value;
            }
            case BOOLEAN: {
                return (Integer)value == 1;
            }
            case ENUM: {
                return optionData.getEnumValue(((Integer)value).intValue());
            }
            case ENUMSET: {
                StringBuilder elementString = new StringBuilder();
                String[] stringArray = (String[])value;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    elementString.append(" ").append(s);
                    ++n2;
                }
                return optionData.parseValue(elementString.toString());
            }
        }
        return optionData.parseValue((String)value);
    }

    public List<GraphIssue> validatePropertyValue(LayoutOptionData optionData, Object value) {
        if (this.layoutOptionValidator == null) {
            return null;
        }
        return this.layoutOptionValidator.checkProperty((IProperty)optionData, value, null);
    }

    public Object getEditableValue() {
        return null;
    }

    public boolean isPropertySet(Object id) {
        return this.layoutConfig.getOptionValue((String)id) != null;
    }

    public void resetPropertyValue(final Object id) {
        LayoutViewPart layoutView;
        Runnable modelChange = new Runnable(){

            @Override
            public void run() {
                LayoutPropertySource.this.layoutConfig.setOptionValue((String)id, null);
            }
        };
        ElkUiUtil.runModelChange(modelChange, this.layoutConfig.getEditingDomain(), Messages.getString("kiml.ui.12"));
        if (this.dependencyOptions.contains(id) && (layoutView = LayoutViewPart.findView()) != null) {
            layoutView.refresh();
        }
    }

    public static String getLayoutHint(String displayedName) {
        String bestHint = null;
        int bestLength = 0;
        for (LayoutAlgorithmData layouterData : LayoutMetaDataService.getInstance().getAlgorithmData()) {
            String name = layouterData.getName();
            if (!displayedName.startsWith(name) || name.length() <= bestLength) continue;
            bestHint = layouterData.getId();
            bestLength = name.length();
        }
        return bestHint;
    }
}

