/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.greedyswitch;

import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.BetweenLayerEdgeAllCrossingsCounter;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.BetweenLayerHyperedgeAllCrossingsCounter;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.BetweenLayerStraightEdgeAllCrossingsCounter;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.InLayerEdgeAllCrossingsCounter;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.NorthSouthEdgeAllCrossingsCounter;

public final class AllCrossingsCounter {
    private final LNode[][] layeredGraph;
    private boolean useHyperedgeCounter;
    private InLayerEdgeAllCrossingsCounter inLayerEdgeCrossingsCounter;
    private BetweenLayerEdgeAllCrossingsCounter inbetweenLayerCounter;
    private NorthSouthEdgeAllCrossingsCounter northSouthPortCrossingCounter;

    public AllCrossingsCounter(LNode[][] layeredGraph) {
        this.layeredGraph = layeredGraph;
        this.useHyperedgeCounter = false;
    }

    public int countAllCrossingsInGraph() {
        return this.countAllCrossingsInGraphWithOrder(this.layeredGraph);
    }

    public int countAllCrossingsInGraphWithOrder(LNode[][] currentOrder) {
        int totalCrossings = 0;
        int layerIndex = 0;
        while (layerIndex < currentOrder.length) {
            LNode[] easternLayer = currentOrder[layerIndex];
            if (layerIndex < currentOrder.length - 1) {
                LNode[] westernLayer = currentOrder[layerIndex + 1];
                totalCrossings += this.countBetweenLayerCrossingsInOrder(easternLayer, westernLayer);
            }
            totalCrossings += this.countNorthSouthPortCrossings(easternLayer);
            totalCrossings += this.countInLayerEdgeCrossingsWithOrder(easternLayer);
            ++layerIndex;
        }
        return totalCrossings;
    }

    public void useHyperedgeCounter() {
        this.useHyperedgeCounter = true;
    }

    private int countBetweenLayerCrossingsInOrder(LNode[] easternLayer, LNode[] westernLayer) {
        if (this.isALayerEmpty(easternLayer, westernLayer)) {
            return 0;
        }
        this.inbetweenLayerCounter = this.useHyperedgeCounter ? new BetweenLayerHyperedgeAllCrossingsCounter(this.layeredGraph) : new BetweenLayerStraightEdgeAllCrossingsCounter(this.layeredGraph);
        return this.inbetweenLayerCounter.countCrossings(easternLayer, westernLayer);
    }

    private boolean isALayerEmpty(LNode[] easternLayer, LNode[] westernLayer) {
        return easternLayer.length == 0 || westernLayer.length == 0;
    }

    private int countInLayerEdgeCrossingsWithOrder(LNode[] layer) {
        this.inLayerEdgeCrossingsCounter = new InLayerEdgeAllCrossingsCounter(layer);
        return this.inLayerEdgeCrossingsCounter.countCrossings();
    }

    private int countNorthSouthPortCrossings(LNode[] layer) {
        this.northSouthPortCrossingCounter = new NorthSouthEdgeAllCrossingsCounter(layer);
        return this.northSouthPortCrossingCounter.countCrossings();
    }
}

