/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.util.IGraphElementVisitor;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.ElkShape;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.MapPropertyHolder;
import org.eclipse.elk.graph.properties.Property;
import org.eclipse.elk.graph.util.ElkReflect;

public class LayoutConfigurator
implements IGraphElementVisitor {
    public static final IProperty<LayoutConfigurator> ADD_LAYOUT_CONFIG = new Property("org.eclipse.elk.addLayoutConfig");
    private final Map<ElkGraphElement, MapPropertyHolder> elementOptionMap = Maps.newHashMap();
    private final Map<Class<? extends ElkGraphElement>, MapPropertyHolder> classOptionMap = Maps.newHashMap();
    private boolean clearLayout = false;
    private final List<IOptionFilter> optionFilters = Lists.newArrayList();
    public static final IPropertyHolderOptionFilter NO_OVERWRITE_HOLDER = (e, p) -> !e.hasProperty(p);
    public static final IOptionFilter NO_OVERWRITE = (e, p) -> !e.hasProperty(p);
    public static final IOptionFilter OPTION_TARGET_FILTER = (e, property) -> {
        LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionData(property.getId());
        if (optionData != null) {
            Set<LayoutOptionData.Target> targets = optionData.getTargets();
            if (e instanceof ElkNode) {
                if (!((ElkNode)e).isHierarchical()) {
                    return targets.contains((Object)LayoutOptionData.Target.NODES);
                }
                return targets.contains((Object)LayoutOptionData.Target.NODES) || targets.contains((Object)LayoutOptionData.Target.PARENTS);
            }
            if (e instanceof ElkEdge) {
                return targets.contains((Object)LayoutOptionData.Target.EDGES);
            }
            if (e instanceof ElkPort) {
                return targets.contains((Object)LayoutOptionData.Target.PORTS);
            }
            if (e instanceof ElkLabel) {
                return targets.contains((Object)LayoutOptionData.Target.LABELS);
            }
        }
        return true;
    };

    public boolean isClearLayout() {
        return this.clearLayout;
    }

    public LayoutConfigurator setClearLayout(boolean doClearLayout) {
        this.clearLayout = doClearLayout;
        return this;
    }

    public LayoutConfigurator addFilter(IOptionFilter filter) {
        this.optionFilters.add(filter);
        return this;
    }

    protected List<IOptionFilter> getFilters() {
        return this.optionFilters;
    }

    public IPropertyHolder configure(ElkGraphElement element) {
        MapPropertyHolder result = this.elementOptionMap.get(element);
        if (result == null) {
            result = new MapPropertyHolder();
            this.elementOptionMap.put(element, result);
        }
        return result;
    }

    public IPropertyHolder getProperties(ElkGraphElement element) {
        return (IPropertyHolder)this.elementOptionMap.get(element);
    }

    public IPropertyHolder configure(Class<? extends ElkGraphElement> elementClass) {
        MapPropertyHolder result = this.classOptionMap.get(elementClass);
        if (result == null) {
            result = new MapPropertyHolder();
            this.classOptionMap.put(elementClass, result);
        }
        return result;
    }

    public IPropertyHolder getProperties(Class<? extends ElkGraphElement> elementClass) {
        return (IPropertyHolder)this.classOptionMap.get(elementClass);
    }

    @Override
    public void visit(ElkGraphElement element) {
        if (this.clearLayout) {
            element.getProperties().clear();
        }
        MapPropertyHolder combined = this.findClassOptions(element);
        combined.copyProperties(this.getProperties(element));
        this.applyProperties(element, (IPropertyHolder)combined);
    }

    protected void applyProperties(ElkGraphElement element, IPropertyHolder properties) {
        if (properties != null) {
            List<IOptionFilter> filters = this.getFilters();
            for (Map.Entry entry : properties.getAllProperties().entrySet()) {
                Object clone;
                boolean accept = filters.stream().allMatch(filter -> filter.accept(element, (IProperty)entry.getKey()));
                if (!accept) continue;
                Object value = entry.getValue();
                if (value instanceof Cloneable && (clone = ElkReflect.clone(value)) != null) {
                    value = clone;
                }
                element.setProperty((IProperty)entry.getKey(), value);
            }
        }
    }

    private MapPropertyHolder findClassOptions(ElkGraphElement element) {
        MapPropertyHolder combined = new MapPropertyHolder();
        if (element instanceof ElkGraphElement) {
            combined.copyProperties((IPropertyHolder)this.classOptionMap.get(ElkGraphElement.class));
        }
        if (element instanceof ElkShape) {
            combined.copyProperties((IPropertyHolder)this.classOptionMap.get(ElkShape.class));
        }
        if (element instanceof ElkLabel) {
            combined.copyProperties((IPropertyHolder)this.classOptionMap.get(ElkLabel.class));
            return combined;
        }
        if (element instanceof ElkConnectableShape) {
            combined.copyProperties((IPropertyHolder)this.classOptionMap.get(ElkConnectableShape.class));
        }
        if (element instanceof ElkNode) {
            combined.copyProperties((IPropertyHolder)this.classOptionMap.get(ElkNode.class));
            return combined;
        }
        if (element instanceof ElkPort) {
            combined.copyProperties((IPropertyHolder)this.classOptionMap.get(ElkPort.class));
            return combined;
        }
        if (element instanceof ElkEdge) {
            combined.copyProperties((IPropertyHolder)this.classOptionMap.get(ElkEdge.class));
        }
        return combined;
    }

    public LayoutConfigurator overrideWith(LayoutConfigurator other) {
        MapPropertyHolder thisHolder;
        for (Map.Entry<ElkGraphElement, MapPropertyHolder> entry : other.elementOptionMap.entrySet()) {
            thisHolder = this.elementOptionMap.get(entry.getKey());
            if (thisHolder == null) {
                thisHolder = new MapPropertyHolder();
                this.elementOptionMap.put(entry.getKey(), thisHolder);
            }
            thisHolder.copyProperties((IPropertyHolder)entry.getValue());
        }
        for (Map.Entry<Object, MapPropertyHolder> entry : other.classOptionMap.entrySet()) {
            thisHolder = this.classOptionMap.get(entry.getKey());
            if (thisHolder == null) {
                thisHolder = new MapPropertyHolder();
                this.classOptionMap.put((Class)entry.getKey(), thisHolder);
            }
            thisHolder.copyProperties((IPropertyHolder)entry.getValue());
        }
        this.clearLayout = other.clearLayout;
        this.optionFilters.clear();
        this.optionFilters.addAll(other.optionFilters);
        return this;
    }

    @FunctionalInterface
    public static interface IOptionFilter {
        public boolean accept(ElkGraphElement var1, IProperty<?> var2);
    }

    @FunctionalInterface
    public static interface IPropertyHolderOptionFilter {
        public boolean accept(IPropertyHolder var1, IProperty<?> var2);
    }
}

