/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphiti;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.elk.alg.graphiti.GraphElementIndicator;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.service.ILayoutConfigurationStore;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.MmFactory;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementEditPart;
import org.eclipse.ui.IWorkbenchPart;

public class GraphitiLayoutConfigurationStore
implements ILayoutConfigurationStore {
    public static final String PREFIX = "layout:";
    private final PictogramElement pictogramElement;
    private final EditingDomain editingDomain;
    private GraphElementIndicator graphElemIndicator;

    public GraphitiLayoutConfigurationStore(PictogramElement thePictogramElement, EditingDomain theEditingDomain, GraphElementIndicator indicator) {
        this.pictogramElement = thePictogramElement;
        this.editingDomain = theEditingDomain;
        this.graphElemIndicator = indicator;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public Object getOptionValue(String optionId) {
        String optionKey = PREFIX + optionId;
        for (Property p : this.pictogramElement.getProperties()) {
            String result;
            if (!optionKey.equals(p.getKey()) || (result = p.getValue()) == null) continue;
            return result;
        }
        return null;
    }

    public void setOptionValue(String optionId, String value) {
        if (value == null) {
            this.removeValue(optionId);
        } else {
            Property p2;
            String optionKey = PREFIX + optionId;
            for (Property p2 : this.pictogramElement.getProperties()) {
                if (!optionKey.equals(p2.getKey())) continue;
                p2.setValue(value.toString());
                return;
            }
            p2 = MmFactory.eINSTANCE.createProperty();
            p2.setKey(optionKey);
            p2.setValue(value.toString());
            this.pictogramElement.getProperties().add((Object)p2);
        }
    }

    private void removeValue(String optionId) {
        Iterator iter = this.pictogramElement.getProperties().iterator();
        String optionKey = PREFIX + optionId;
        while (iter.hasNext()) {
            Property p = (Property)iter.next();
            if (!optionKey.equals(p.getKey())) continue;
            iter.remove();
        }
    }

    public Collection<String> getAffectedOptions() {
        LinkedList<String> options = new LinkedList<String>();
        for (Property p : this.pictogramElement.getProperties()) {
            String key = p.getKey();
            if (key == null || !key.startsWith(PREFIX)) continue;
            options.add(key.substring(PREFIX.length()));
        }
        return options;
    }

    public Set<LayoutOptionData.Target> getOptionTargets() {
        ConnectionDecorator decorator;
        if (this.pictogramElement instanceof Diagram) {
            return EnumSet.of(LayoutOptionData.Target.PARENTS);
        }
        if (this.pictogramElement instanceof Shape) {
            Shape shape = (Shape)this.pictogramElement;
            EnumSet<LayoutOptionData.Target> targets = EnumSet.noneOf(LayoutOptionData.Target.class);
            if (this.graphElemIndicator.isNodeShape(shape)) {
                targets.add(LayoutOptionData.Target.NODES);
                if (shape instanceof ContainerShape) {
                    for (Shape child : ((ContainerShape)shape).getChildren()) {
                        if (!this.graphElemIndicator.isNodeShape(child)) continue;
                        targets.add(LayoutOptionData.Target.PARENTS);
                        break;
                    }
                }
            }
            return targets;
        }
        if (this.pictogramElement instanceof Connection) {
            Connection connection = (Connection)this.pictogramElement;
            AnchorContainer ac = connection.getStart().getParent();
            if (ac instanceof Shape) {
                return EnumSet.of(LayoutOptionData.Target.EDGES);
            }
        } else if (this.pictogramElement instanceof Anchor) {
            Anchor anchor = (Anchor)this.pictogramElement;
            AnchorContainer ac = anchor.getParent();
            if (ac instanceof Shape && this.graphElemIndicator.isPortAnchor(anchor)) {
                return EnumSet.of(LayoutOptionData.Target.PORTS);
            }
        } else if (this.pictogramElement instanceof ConnectionDecorator && this.graphElemIndicator.isEdgeLabel(decorator = (ConnectionDecorator)this.pictogramElement)) {
            return EnumSet.of(LayoutOptionData.Target.LABELS);
        }
        return EnumSet.noneOf(LayoutOptionData.Target.class);
    }

    public ILayoutConfigurationStore getParent() {
        PictogramElement container = this.getContainer();
        if (container != null) {
            return new GraphitiLayoutConfigurationStore(container, this.editingDomain, this.graphElemIndicator);
        }
        return null;
    }

    private PictogramElement getContainer() {
        AnchorContainer ac;
        if (this.pictogramElement instanceof Shape) {
            return ((Shape)this.pictogramElement).getContainer();
        }
        if (this.pictogramElement instanceof Connection) {
            AnchorContainer ac2 = ((Connection)this.pictogramElement).getStart().getParent();
            if (ac2 instanceof Shape) {
                return ((Shape)ac2).getContainer();
            }
        } else if (this.pictogramElement instanceof Anchor && (ac = ((Anchor)this.pictogramElement).getParent()) instanceof Shape) {
            return ((Shape)ac).getContainer();
        }
        return null;
    }

    public static final class Provider
    implements ILayoutConfigurationStore.Provider {
        @Inject
        private GraphElementIndicator graphElemIndicator;

        public ILayoutConfigurationStore get(IWorkbenchPart workbenchPart, Object context) {
            TransactionalEditingDomain editingDomain = null;
            if (workbenchPart instanceof DiagramEditor) {
                editingDomain = ((DiagramEditor)workbenchPart).getEditingDomain();
            }
            if (context instanceof PictogramElement) {
                return new GraphitiLayoutConfigurationStore((PictogramElement)context, (EditingDomain)editingDomain, this.graphElemIndicator);
            }
            if (context instanceof IPictogramElementEditPart) {
                IPictogramElementEditPart editPart = (IPictogramElementEditPart)context;
                return new GraphitiLayoutConfigurationStore(editPart.getPictogramElement(), (EditingDomain)editingDomain, this.graphElemIndicator);
            }
            return null;
        }
    }
}

