/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.loops.routing;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopEdge;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNodeSide;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopOpposingSegment;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopRoutingDirection;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopType;
import org.eclipse.elk.alg.layered.p5edges.loops.routing.ISelfLoopRouter;
import org.eclipse.elk.alg.layered.p5edges.loops.util.SelfLoopBendpointCalculationUtil;
import org.eclipse.elk.alg.layered.p5edges.splines.SplinesMath;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;

public abstract class AbstractSelfLoopRouter
implements ISelfLoopRouter {
    private static final double DISTANCE = 10.0;
    private static final double ANCHOR_HEIGHT = 5.0;

    @Override
    public void routeSelfLoop(SelfLoopEdge slEdge, SelfLoopNode slNode) {
        SelfLoopType type = SelfLoopType.getEdgeType(slEdge, slNode);
        switch (type) {
            case SIDE: {
                this.routeSideSelfLoop(slEdge);
                break;
            }
            case CORNER: {
                this.routeCornerSelfLoop(slEdge);
                break;
            }
            case OPPOSING: {
                this.routeOpposingSelfLoop(slEdge);
                break;
            }
            case THREE_CORNER: {
                this.routeThreeCornerSelfLoop(slEdge);
                break;
            }
            case FOUR_CORNER: {
                this.routeFourCornerSelfLoop(slEdge);
            }
        }
    }

    protected abstract void routeSideSelfLoop(SelfLoopEdge var1);

    protected abstract void routeCornerSelfLoop(SelfLoopEdge var1);

    protected abstract void routeOpposingSelfLoop(SelfLoopEdge var1);

    protected abstract void routeThreeCornerSelfLoop(SelfLoopEdge var1);

    protected abstract void routeFourCornerSelfLoop(SelfLoopEdge var1);

    protected KVector computeSourceBendPoint(SelfLoopEdge slEdge) {
        return this.computeSourceBendPoint(slEdge, true);
    }

    protected KVector computeSourceBendPoint(SelfLoopEdge slEdge, boolean supportsHyperEdges) {
        return this.computeSourceOrTargetBendPoint(slEdge, slEdge.getSource(), supportsHyperEdges);
    }

    protected KVector computeTargetBendPoint(SelfLoopEdge slEdge) {
        return this.computeTargetBendPoint(slEdge, true);
    }

    protected KVector computeTargetBendPoint(SelfLoopEdge slEdge, boolean supportsHyperEdges) {
        return this.computeSourceOrTargetBendPoint(slEdge, slEdge.getTarget(), supportsHyperEdges);
    }

    private KVector computeSourceOrTargetBendPoint(SelfLoopEdge slEdge, SelfLoopPort slPort, boolean supportsHyperEdges) {
        LEdge lEdge = slEdge.getEdge();
        PortSide routingSide = slPort.getPortSide();
        double direction = SplinesMath.portSideToDirection(routingSide);
        LPort lPort = slPort.getLPort();
        KVector lPortPos = lPort.getPosition().clone().add(lPort.getAnchor());
        int level = slPort.getEdgeLevel(lEdge);
        if (!supportsHyperEdges) {
            int order = slEdge.getEdgeOrders().get(routingSide);
            int connectedEdges = Iterables.size(slPort.getConnectedEdges());
            level += -connectedEdges + order;
        }
        double otherEdgeOffset = slPort.getOtherEdgeOffset();
        KVector bendpoint = lPortPos.clone().add(new KVector(direction).scale((double)level * 10.0));
        bendpoint.add(new KVector(direction).scale(otherEdgeOffset));
        return bendpoint;
    }

    protected static KVector computeSingleCornerBendPoint(KVector sourceBendPoint, KVector targetBendPoint, PortSide targetSide) {
        KVector cornerBendPoint = new KVector();
        switch (targetSide) {
            case NORTH: 
            case SOUTH: {
                cornerBendPoint.x = sourceBendPoint.x;
                cornerBendPoint.y = targetBendPoint.y;
                break;
            }
            case EAST: 
            case WEST: {
                cornerBendPoint.x = targetBendPoint.x;
                cornerBendPoint.y = sourceBendPoint.y;
            }
        }
        return cornerBendPoint;
    }

    protected List<KVector> computeCornerBendpoints(SelfLoopNode slNode, SelfLoopEdge slEdge, KVector sourceBendPoint, KVector targetBendPoint) {
        ArrayList<KVector> cornerBendpoints = new ArrayList<KVector>();
        KVector previousBendPoint = sourceBendPoint.clone();
        SelfLoopPort source = slEdge.getSource();
        PortSide sourceSide = source.getPortSide();
        SelfLoopPort target = slEdge.getTarget();
        PortSide targetSide = target.getPortSide();
        SelfLoopRoutingDirection routingDirection = source.getDirection();
        if (source.getDirection() == SelfLoopRoutingDirection.BOTH) {
            routingDirection = target.getDirection() == SelfLoopRoutingDirection.LEFT ? SelfLoopRoutingDirection.RIGHT : SelfLoopRoutingDirection.LEFT;
        }
        PortSide nextside = routingDirection == SelfLoopRoutingDirection.LEFT ? sourceSide.left() : sourceSide.right();
        do {
            SelfLoopNodeSide nodeSide = slNode.getNodeSide(nextside);
            SelfLoopOpposingSegment segment = nodeSide.getOpposingSegments().get(slEdge);
            double middlePadding = 10.0 * (double)segment.getLevel() + segment.getLabelOffset() + 5.0;
            LNode node = source.getLPort().getNode();
            KVector secondCP = SelfLoopBendpointCalculationUtil.calculateOpposingCornerBendPoint(previousBendPoint, nextside, node.getSize(), middlePadding);
            cornerBendpoints.add(secondCP);
            previousBendPoint = secondCP;
        } while ((nextside = routingDirection == SelfLoopRoutingDirection.LEFT ? nextside.left() : nextside.right()) != targetSide);
        KVector secondCP = AbstractSelfLoopRouter.computeSingleCornerBendPoint(previousBendPoint, targetBendPoint, target.getPortSide());
        cornerBendpoints.add(secondCP);
        return cornerBendpoints;
    }
}

