/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.libavoid;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.elk.alg.libavoid.options.LibavoidOptions;
import org.eclipse.elk.alg.libavoid.server.LibavoidServer;
import org.eclipse.elk.alg.libavoid.server.LibavoidServerException;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.WrappedException;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public class LibavoidServerCommunicator {
    private static final boolean DEBUG = false;
    private static final String CHUNK_KEYWORD = "[CHUNK]\n";
    private BiMap<Integer, ElkNode> nodeIdMap = HashBiMap.create();
    private BiMap<Integer, ElkPort> portIdMap = HashBiMap.create();
    private BiMap<Integer, ElkEdge> edgeIdMap = HashBiMap.create();
    private static final int PORT_ID_START = 5;
    private static final int NODE_ID_START = 5;
    private static final int NODE_COMPOUND_NORTH = 1;
    private static final int NODE_COMPOUND_EAST = 2;
    private static final int NODE_COMPOUND_SOUTH = 3;
    private static final int NODE_COMPOUND_WEST = 4;
    private static final int SURROUNDING_RECT_SIZE = 10;
    private int nodeIdCounter = 5;
    private int portIdCounter = 5;
    private int edgeIdCounter = 1;
    private static final int SUBTASK_WORK = 1;
    private static final int LAYOUT_WORK = 4;
    private StringBuilder sb = new StringBuilder();

    private void reset() {
        this.nodeIdCounter = 5;
        this.nodeIdMap.clear();
        this.portIdCounter = 5;
        this.portIdMap.clear();
        this.edgeIdCounter = 1;
        this.edgeIdMap.clear();
        this.sb = new StringBuilder();
    }

    public void requestLayout(ElkNode layoutNode, IElkProgressMonitor progressMonitor, LibavoidServer lvServer) {
        progressMonitor.begin("Libavoid Layout", 4.0f);
        if (layoutNode.getChildren().isEmpty()) {
            progressMonitor.done();
            return;
        }
        lvServer.initialize();
        try {
            try {
                OutputStream outputStream = lvServer.input();
                this.writeTextGraph(layoutNode, outputStream);
                outputStream.flush();
                Map<String, KVectorChain> layoutInformation = this.readLayoutInformation(lvServer, progressMonitor.subTask(1.0f));
                this.applyLayout(layoutNode, layoutInformation, progressMonitor.subTask(1.0f));
                this.calculateJunctionPoints(layoutNode);
                lvServer.cleanup(LibavoidServer.Cleanup.NORMAL);
            }
            catch (IOException exception) {
                lvServer.cleanup(LibavoidServer.Cleanup.ERROR);
                throw new WrappedException("Failed to communicate with the Libavoid process.", (Throwable)exception);
            }
        }
        finally {
            progressMonitor.done();
            this.reset();
        }
    }

    private void applyLayout(ElkNode parentNode, Map<String, KVectorChain> layoutInformation, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Apply layout", 1.0f);
        double maxX = 0.0;
        double maxY = 0.0;
        for (Map.Entry<String, KVectorChain> entry : layoutInformation.entrySet()) {
            KVectorChain points = entry.getValue();
            if (points.size() < 2) {
                throw new IllegalStateException("An edge retrieved from Libavoid has less than 2 points.");
            }
            int edgeId = Integer.valueOf(entry.getKey().split(" ")[1]);
            ElkEdge e = (ElkEdge)this.edgeIdMap.get((Object)edgeId);
            if (e == null) {
                throw new IllegalStateException("A problem within the edge mapping occured.Could not determine edge for id " + edgeId + ".");
            }
            ElkEdgeSection edgeSection = ElkGraphUtil.firstEdgeSection((ElkEdge)e, (boolean)true, (boolean)true);
            ElkUtil.applyVectorChain((KVectorChain)points, (ElkEdgeSection)edgeSection);
            for (KVector point : points) {
                maxX = Math.max(maxX, point.x);
                maxY = Math.max(maxY, point.y);
            }
        }
        for (ElkNode node : parentNode.getChildren()) {
            maxX = Math.max(maxX, node.getX() + node.getWidth());
            maxY = Math.max(maxY, node.getY() + node.getHeight());
        }
        if (parentNode.getWidth() < maxX) {
            parentNode.setWidth(maxX + ((ElkPadding)parentNode.getProperty((IProperty)CoreOptions.PADDING)).right);
        }
        if (parentNode.getHeight() < maxY) {
            parentNode.setHeight(maxY + ((ElkPadding)parentNode.getProperty((IProperty)CoreOptions.PADDING)).bottom);
        }
        progressMonitor.done();
    }

    private void calculateJunctionPoints(ElkNode graph) {
        for (ElkNode n : graph.getChildren()) {
            for (ElkEdge edge : ElkGraphUtil.allOutgoingEdges((ElkNode)n)) {
                KVectorChain junctionPoints = ElkUtil.determineJunctionPoints((ElkEdge)edge);
                edge.setProperty(CoreOptions.JUNCTION_POINTS, (Object)junctionPoints);
            }
        }
    }

    private Map<String, KVectorChain> readLayoutInformation(LibavoidServer libavoidServer, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Read output from Libavoid", 1.0f);
        Map<String, String> outputData = libavoidServer.readOutputData();
        if (outputData == null) {
            libavoidServer.cleanup(LibavoidServer.Cleanup.ERROR);
            throw new LibavoidServerException("No output from the Libavoid process. Try increasing the timeout value in the preferences (KIELER / Layout / Libavoid).");
        }
        HashMap layoutInformation = Maps.newHashMapWithExpectedSize((int)outputData.size());
        for (Map.Entry<String, String> entry : outputData.entrySet()) {
            KVectorChain pointList = new KVectorChain();
            StringTokenizer tokenizer = new StringTokenizer(entry.getValue(), " ");
            while (tokenizer.countTokens() >= 2) {
                double x = LibavoidServerCommunicator.parseDouble(tokenizer.nextToken());
                double y = LibavoidServerCommunicator.parseDouble(tokenizer.nextToken());
                pointList.add((Object)new KVector(x, y));
            }
            layoutInformation.put(entry.getKey(), pointList);
        }
        progressMonitor.done();
        return layoutInformation;
    }

    private void writeTextGraph(ElkNode root, OutputStream stream) {
        this.transformOptions(root);
        if (((Boolean)root.getProperty(CoreOptions.DEBUG_MODE)).booleanValue()) {
            this.sb.append("DEBUG\n");
        }
        this.transformGraph(root);
        this.sb.append(CHUNK_KEYWORD);
        try {
            stream.write(this.sb.toString().getBytes());
        }
        catch (IOException e) {
            throw new WrappedException("Could not write to the outputstream of the libavoid server.", (Throwable)e);
        }
    }

    private void transformOptions(ElkNode node) {
        Direction direction;
        EdgeRouting edgeRouting = (EdgeRouting)node.getProperty(LibavoidOptions.EDGE_ROUTING);
        if (edgeRouting != EdgeRouting.UNDEFINED) {
            this.addOption(LibavoidOptions.EDGE_ROUTING, edgeRouting);
        }
        if ((direction = (Direction)node.getProperty(LibavoidOptions.DIRECTION)) != Direction.UNDEFINED) {
            this.addOption(LibavoidOptions.DIRECTION, direction);
        }
        boolean enableHyperedgesFromCommonSource = (Boolean)node.getProperty(LibavoidOptions.ENABLE_HYPEREDGES_FROM_COMMON_SOURCE);
        this.addOption(LibavoidOptions.ENABLE_HYPEREDGES_FROM_COMMON_SOURCE, enableHyperedgesFromCommonSource);
        double segmentPenalty = (Double)node.getProperty(LibavoidOptions.SEGMENT_PENALTY);
        this.addPenalty(LibavoidOptions.SEGMENT_PENALTY, segmentPenalty);
        double anglePenalty = (Double)node.getProperty(LibavoidOptions.ANGLE_PENALTY);
        this.addPenalty(LibavoidOptions.ANGLE_PENALTY, anglePenalty);
        double crossingPenalty = (Double)node.getProperty(LibavoidOptions.CROSSING_PENALTY);
        this.addPenalty(LibavoidOptions.CROSSING_PENALTY, crossingPenalty);
        double clusterCrossingPenalty = (Double)node.getProperty(LibavoidOptions.CLUSTER_CROSSING_PENALTY);
        this.addPenalty(LibavoidOptions.CLUSTER_CROSSING_PENALTY, clusterCrossingPenalty);
        double fixedSharedPathPenalty = (Double)node.getProperty(LibavoidOptions.FIXED_SHARED_PATH_PENALTY);
        this.addPenalty(LibavoidOptions.FIXED_SHARED_PATH_PENALTY, fixedSharedPathPenalty);
        double portDirectionPenalty = (Double)node.getProperty(LibavoidOptions.PORT_DIRECTION_PENALTY);
        this.addPenalty(LibavoidOptions.PORT_DIRECTION_PENALTY, portDirectionPenalty);
        double shapeBufferDistance = (Double)node.getProperty(LibavoidOptions.SHAPE_BUFFER_DISTANCE);
        this.addPenalty(LibavoidOptions.SHAPE_BUFFER_DISTANCE, shapeBufferDistance);
        double idealNudgingDistance = (Double)node.getProperty(LibavoidOptions.IDEAL_NUDGING_DISTANCE);
        this.addPenalty(LibavoidOptions.IDEAL_NUDGING_DISTANCE, idealNudgingDistance);
        double reverseDirectionPenalty = (Double)node.getProperty(LibavoidOptions.REVERSE_DIRECTION_PENALTY);
        this.addPenalty(LibavoidOptions.REVERSE_DIRECTION_PENALTY, reverseDirectionPenalty);
        boolean nudgeOrthogonalSegmentsConnectedToShapes = (Boolean)node.getProperty(LibavoidOptions.NUDGE_ORTHOGONAL_SEGMENTS_CONNECTED_TO_SHAPES);
        this.addRoutingOption(LibavoidOptions.NUDGE_ORTHOGONAL_SEGMENTS_CONNECTED_TO_SHAPES, nudgeOrthogonalSegmentsConnectedToShapes);
        boolean improveHyperedgeRoutesMovingJunctions = (Boolean)node.getProperty(LibavoidOptions.IMPROVE_HYPEREDGE_ROUTES_MOVING_JUNCTIONS);
        this.addRoutingOption(LibavoidOptions.IMPROVE_HYPEREDGE_ROUTES_MOVING_JUNCTIONS, improveHyperedgeRoutesMovingJunctions);
        boolean penaliseOrthogonalSharedPathsAtConnEnds = (Boolean)node.getProperty(LibavoidOptions.PENALISE_ORTHOGONAL_SHARED_PATHS_AT_CONN_ENDS);
        this.addRoutingOption(LibavoidOptions.PENALISE_ORTHOGONAL_SHARED_PATHS_AT_CONN_ENDS, penaliseOrthogonalSharedPathsAtConnEnds);
        boolean nudgeOrthogonalTouchingColinearSegments = (Boolean)node.getProperty(LibavoidOptions.NUDGE_ORTHOGONAL_TOUCHING_COLINEAR_SEGMENTS);
        this.addRoutingOption(LibavoidOptions.NUDGE_ORTHOGONAL_TOUCHING_COLINEAR_SEGMENTS, nudgeOrthogonalTouchingColinearSegments);
        boolean performUnifyingNudgingPreprocessingStep = (Boolean)node.getProperty(LibavoidOptions.PERFORM_UNIFYING_NUDGING_PREPROCESSING_STEP);
        this.addRoutingOption(LibavoidOptions.PERFORM_UNIFYING_NUDGING_PREPROCESSING_STEP, performUnifyingNudgingPreprocessingStep);
        boolean improveHyperedgeRoutesMovingAddingAndDeletingJunctions = (Boolean)node.getProperty(LibavoidOptions.IMPROVE_HYPEREDGE_ROUTES_MOVING_ADDING_AND_DELETING_JUNCTIONS);
        this.addRoutingOption(LibavoidOptions.IMPROVE_HYPEREDGE_ROUTES_MOVING_ADDING_AND_DELETING_JUNCTIONS, improveHyperedgeRoutesMovingAddingAndDeletingJunctions);
        boolean nudgeSharedPathsWithCommonEndPoint = (Boolean)node.getProperty(LibavoidOptions.NUDGE_SHARED_PATHS_WITH_COMMON_END_POINT);
        this.addRoutingOption(LibavoidOptions.NUDGE_SHARED_PATHS_WITH_COMMON_END_POINT, nudgeSharedPathsWithCommonEndPoint);
    }

    private void addOption(IProperty<?> key, Object value) {
        if (value != null) {
            this.sb.append("OPTION " + this.getOptionId(key) + " " + value.toString());
            this.sb.append("\n");
        }
    }

    private void addRoutingOption(IProperty<?> key, boolean value) {
        this.sb.append("ROUTINGOPTION " + this.getOptionId(key) + " " + Boolean.toString(value));
        this.sb.append("\n");
    }

    private void addPenalty(IProperty<?> key, double value) {
        if (!Double.isNaN(value)) {
            this.sb.append("PENALTY " + this.getOptionId(key) + " " + Double.toString(value));
            this.sb.append("\n");
        }
    }

    private String getOptionId(IProperty<?> key) {
        String optionId = key.getId();
        if (optionId.startsWith("org.eclipse.elk.alg.libavoid.")) {
            optionId = optionId.substring("org.eclipse.elk.alg.libavoid.".length());
        } else if (optionId.startsWith("org.eclipse.elk.")) {
            optionId = optionId.substring("org.eclipse.elk.".length());
        }
        return optionId;
    }

    private void transformGraph(ElkNode root) {
        this.sb.append("GRAPH");
        this.sb.append("\n");
        if (root.getParent() != null) {
            this.transformHierarchicalParent(root);
        } else {
            this.transformHierarchicalParentDummy(root);
        }
        for (ElkNode node : root.getChildren()) {
            this.transformNode(node);
        }
        for (ElkNode node : root.getChildren()) {
            for (ElkEdge edge : ElkGraphUtil.allOutgoingEdges((ElkNode)node)) {
                if (edge.isHierarchical() && !this.isClusterEdge(edge)) continue;
                this.transformEdge(edge);
            }
        }
        for (ElkPort p : root.getPorts()) {
            for (ElkEdge e : ElkGraphUtil.allIncidentEdges((ElkConnectableShape)p)) {
                ElkNode src = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)e.getSources().get(0)));
                ElkNode tgt = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)e.getTargets().get(0)));
                if (!src.getParent().equals(root) && !tgt.getParent().equals(root)) continue;
                this.transformEdge(e);
            }
        }
        this.sb.append("GRAPHEND");
        this.sb.append("\n");
    }

    private boolean isClusterEdge(ElkEdge edge) {
        ElkNode srcNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)edge.getSources().get(0)));
        ElkNode tgtNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)edge.getTargets().get(0)));
        ElkNode srcParent = srcNode.getParent();
        ElkNode tgtParent = tgtNode.getParent();
        return srcParent != null && srcParent.hasProperty(LibavoidOptions.IS_CLUSTER) || tgtParent != null && tgtParent.hasProperty(LibavoidOptions.IS_CLUSTER);
    }

    private void transformHierarchicalParent(ElkNode parent) {
        double bufferDistance = (Double)parent.getProperty(LibavoidOptions.SHAPE_BUFFER_DISTANCE);
        this.libavoidNode(parent, 1, 0.0, -10.0 - bufferDistance, parent.getWidth(), 10.0, 0, 0);
        this.libavoidNode(parent, 2, 0.0 + parent.getWidth() + bufferDistance, 0.0, 10.0, parent.getHeight(), 0, 0);
        this.libavoidNode(parent, 3, 0.0, 0.0 + parent.getHeight() + bufferDistance, parent.getWidth(), 10.0, 0, 0);
        this.libavoidNode(parent, 4, 0.0 - bufferDistance - 10.0, 0.0, 10.0, parent.getHeight(), 0, 0);
        for (ElkPort port : parent.getPorts()) {
            int nodeId = this.determineHierarchicalNodeId(port);
            this.libavoidPort(port, this.portIdCounter, nodeId, parent);
            ++this.portIdCounter;
        }
    }

    private void transformHierarchicalParentDummy(ElkNode root) {
        this.libavoidNode(root, 1, 0.0, 0.0, 0.0, 0.0, 0, 0);
        this.libavoidNode(root, 2, 0.0, 0.0, 0.0, 0.0, 0, 0);
        this.libavoidNode(root, 3, 0.0, 0.0, 0.0, 0.0, 0, 0);
        this.libavoidNode(root, 4, 0.0, 0.0, 0.0, 0.0, 0, 0);
    }

    private void libavoidNode(ElkNode node, int id, double xPos, double yPos, double width, double height, int portLessIncomingEdges, int portLessOutgoingEdges) {
        if (id >= 5) {
            this.nodeIdMap.put((Object)id, (Object)node);
        }
        this.sb.append("NODE " + id + " " + xPos + " " + yPos + " " + (xPos + width) + " " + (yPos + height) + " " + portLessIncomingEdges + " " + portLessOutgoingEdges);
        this.sb.append("\n");
    }

    private void libavoidCluster(ElkNode node, int id, double xPos, double yPos, double width, double height) {
        this.sb.append("CLUSTER " + id + " " + xPos + " " + yPos + " " + (xPos + width) + " " + (yPos + height));
        this.sb.append("\n");
    }

    private void libavoidPort(ElkPort port, int portId, int nodeId, ElkNode compoundNode) {
        this.portIdMap.put((Object)portId, (Object)port);
        PortSide side = (PortSide)port.getProperty(CoreOptions.PORT_SIDE);
        if (compoundNode != null) {
            side = side.opposed();
        }
        double centerX = port.getX() + port.getWidth() / 2.0;
        double centerY = port.getY() + port.getHeight() / 2.0;
        this.sb.append("PORT " + portId + " " + nodeId + " " + side.toString() + " " + centerX + " " + centerY);
        this.sb.append("\n");
    }

    private void transformNode(ElkNode node) {
        if (this.isCluster(node)) {
            this.transformCluster(node);
        } else {
            this.transformNode(node, node.getX(), node.getY());
        }
    }

    private boolean isCluster(ElkNode node) {
        return (Boolean)node.getProperty(LibavoidOptions.IS_CLUSTER) != false && node.getParent() != null && (Boolean)node.getParent().getProperty(LibavoidOptions.IS_CLUSTER) == false && node.getOutgoingEdges().isEmpty() && node.getIncomingEdges().isEmpty() && node.getPorts().isEmpty();
    }

    private void transformNode(ElkNode node, double x, double y) {
        int portLessIncomingEdges = node.getIncomingEdges().size();
        int portLessOutgoingEdges = node.getOutgoingEdges().size();
        this.libavoidNode(node, this.nodeIdCounter, x, y, node.getWidth(), node.getHeight(), portLessIncomingEdges, portLessOutgoingEdges);
        for (ElkPort port : node.getPorts()) {
            this.libavoidPort(port, this.portIdCounter, this.nodeIdCounter, null);
            ++this.portIdCounter;
        }
        ++this.nodeIdCounter;
    }

    private void transformCluster(ElkNode node) {
        this.libavoidCluster(node, this.nodeIdCounter, node.getX(), node.getY(), node.getWidth(), node.getHeight());
        ++this.nodeIdCounter;
        double x = node.getX();
        double y = node.getY();
        for (ElkNode child : node.getChildren()) {
            this.transformNode(child, child.getX() + x, child.getX() + y);
        }
    }

    private void transformEdge(ElkEdge edge) {
        this.edgeIdMap.put((Object)this.edgeIdCounter, (Object)edge);
        ElkNode srcNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)edge.getSources().get(0)));
        ElkNode tgtNode = ElkGraphUtil.connectableShapeToNode((ElkConnectableShape)((ElkConnectableShape)edge.getTargets().get(0)));
        ElkPort srcPort = ElkGraphUtil.connectableShapeToPort((ElkConnectableShape)((ElkConnectableShape)edge.getSources().get(0)));
        ElkPort tgtPort = ElkGraphUtil.connectableShapeToPort((ElkConnectableShape)((ElkConnectableShape)edge.getTargets().get(0)));
        Integer srcId = (Integer)this.nodeIdMap.inverse().get((Object)srcNode);
        Integer tgtId = (Integer)this.nodeIdMap.inverse().get((Object)tgtNode);
        Integer srcPortId = (Integer)this.portIdMap.inverse().get((Object)srcPort);
        Integer tgtPortId = (Integer)this.portIdMap.inverse().get((Object)tgtPort);
        if (srcPortId != null && srcId == null) {
            srcId = this.determineHierarchicalNodeId(srcPort);
        }
        if (tgtPortId != null && tgtId == null) {
            tgtId = this.determineHierarchicalNodeId(tgtPort);
        }
        String edgeType = "EDGE";
        if (srcPortId != null && tgtPortId != null) {
            edgeType = "PEDGEP";
        } else if (srcPortId != null) {
            edgeType = "PEDGE";
        } else if (tgtPortId != null) {
            edgeType = "EDGEP";
        }
        this.sb.append(String.valueOf(edgeType) + " " + this.edgeIdCounter + " " + srcId + " " + tgtId + " " + srcPortId + " " + tgtPortId);
        this.sb.append("\n");
        ++this.edgeIdCounter;
    }

    private static double parseDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException exception) {
            return Double.NaN;
        }
    }

    private int determineHierarchicalNodeId(ElkPort port) {
        PortSide ps = (PortSide)port.getProperty(CoreOptions.PORT_SIDE);
        int nodeId = 0;
        switch (ps) {
            case NORTH: {
                nodeId = 1;
                break;
            }
            case EAST: {
                nodeId = 2;
                break;
            }
            case SOUTH: {
                nodeId = 3;
                break;
            }
            default: {
                nodeId = 4;
            }
        }
        return nodeId;
    }
}

