/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.debug.gdbjtag.qemu.core.preferences;

import org.eclipse.embedcdt.core.preferences.Discoverer;

public class DefaultPreferences
extends org.eclipse.embedcdt.debug.gdbjtag.core.preferences.DefaultPreferences {
    public static final boolean SERVER_DO_START_DEFAULT = true;
    public static final boolean DO_START_GDB_SERVER_DEFAULT = true;
    public static final boolean DO_GDB_SERVER_PREFER_XPACK_BIN_DEFAULT = false;
    public static final String SERVER_EXECUTABLE_DEFAULT = "${qemu_path}/${qemu_executable}";
    public static final String PARAMETRIZED_SERVER_EXECUTABLE_DEFAULT = "${qemu_%s_path}/${qemu_%s_executable}";
    protected static final String CLIENT_EXECUTABLE_DEFAULT = "${cross_prefix}gdb${cross_suffix}";
    @Deprecated
    public static final String SERVER_EXECUTABLE_DEFAULT_NAME = "qemu-system-gnuarmeclipse";
    public static final String QEMU_BOARD_NAME_DEFAULT = "?";
    public static final String QEMU_DEVICE_NAME_DEFAULT = "?";
    public static final int SERVER_GDB_PORT_NUMBER_DEFAULT = 1234;
    public static final String SERVER_OTHER_OPTIONS_DEFAULT = "-d unimp,guest_errors";
    public static final boolean DO_GDB_SERVER_ALLOCATE_CONSOLE_DEFAULT = true;
    public static final int SERVER_GDB_DELAY_SECONDS_DEFAULT = 0;
    public static final boolean QEMU_IS_VERBOSE_DEFAULT = false;
    public static final String CLIENT_OTHER_OPTIONS_DEFAULT = "";
    public static final String CLIENT_COMMANDS_DEFAULT = "set mem inaccessible-by-default off\n";
    public static final boolean USE_REMOTE_TARGET_DEFAULT = true;
    public static final String REMOTE_IP_ADDRESS_LOCALHOST = "localhost";
    public static final String REMOTE_IP_ADDRESS_DEFAULT = "localhost";
    public static final int REMOTE_PORT_NUMBER_DEFAULT = 1234;
    public static final boolean DO_INITIAL_RESET_DEFAULT = false;
    public static final String DO_INITIAL_RESET_COMMAND = "monitor system_reset ";
    public static final String HALT_COMMAND = "";
    public static final boolean ENABLE_SEMIHOSTING_DEFAULT = true;
    public static final String ENABLE_SEMIHOSTING_OPTION = "-semihosting-config enable=on,target=native";
    public static final String INIT_OTHER_DEFAULT = "";
    public static final boolean DO_DEBUG_IN_RAM_DEFAULT = false;
    public static final boolean DO_PRERUN_RESET_DEFAULT = true;
    public static final String DO_PRERUN_RESET_COMMAND = "monitor system_reset ";
    public static final boolean DO_STOP_AT_DEFAULT = true;
    public static final String STOP_AT_NAME_DEFAULT = "main";
    public static final String PRERUN_OTHER_DEFAULT = "";
    public static final boolean DO_CONTINUE_DEFAULT = true;
    public static final String DO_CONTINUE_COMMAND = "continue";
    public static final boolean DISABLE_GRAPHICS_DEFAULT = false;
    private static final String REG_SUBKEY = "\\GNU ARM Eclipse\\QEMU";
    private static final String REG_NAME = "InstallLocation";

    public DefaultPreferences(String pluginId) {
        super(pluginId);
    }

    @Deprecated
    public String getGdbServerExecutable() {
        return this.getString("gdb.server.executable", SERVER_EXECUTABLE_DEFAULT);
    }

    public String getGdbServerExecutable(String prefix, String architecture) {
        if (prefix.isEmpty()) {
            return this.getString(String.valueOf(prefix) + "gdb.server.executable", SERVER_EXECUTABLE_DEFAULT);
        }
        String serverDefault = String.format(PARAMETRIZED_SERVER_EXECUTABLE_DEFAULT, architecture, architecture);
        return this.getString(String.valueOf(prefix) + "gdb.server.executable", serverDefault);
    }

    @Deprecated
    public String getGdbClientExecutable() {
        return this.getString("gdb.client.executable", CLIENT_EXECUTABLE_DEFAULT);
    }

    public String getGdbClientExecutable(String prefix) {
        return this.getString(String.valueOf(prefix) + "gdb.client.executable", CLIENT_EXECUTABLE_DEFAULT);
    }

    @Deprecated
    public boolean getQemuEnableSemihosting() {
        return this.getBoolean("gdb.qemu.enableSemihosting", true);
    }

    public boolean getQemuEnableSemihosting(String prefix) {
        return this.getBoolean(String.valueOf(prefix) + "gdb.qemu.enableSemihosting", true);
    }

    public boolean getTabMainCheckProgram() {
        return this.getBoolean("tab.main.checkProgram", false);
    }

    @Deprecated
    public boolean getGdbServerDoStart() {
        return this.getBoolean("gdb.server.doStart", true);
    }

    public boolean getGdbServerDoStart(String prefix) {
        return this.getBoolean(String.valueOf(prefix) + "gdb.server.doStart", true);
    }

    @Deprecated
    public String getGdbServerOtherOptions() {
        return this.getString("gdb.server.other", SERVER_OTHER_OPTIONS_DEFAULT);
    }

    public String getGdbServerOtherOptions(String prefix) {
        return this.getString(String.valueOf(prefix) + "gdb.server.other", SERVER_OTHER_OPTIONS_DEFAULT);
    }

    @Deprecated
    public String getGdbClientOtherOptions() {
        return this.getString("gdb.client.other", "");
    }

    public String getGdbClientOtherOptions(String prefix) {
        return this.getString(String.valueOf(prefix) + "gdb.client.other", "");
    }

    @Deprecated
    public String getGdbClientCommands() {
        return this.getString("gdb.client.commands", CLIENT_COMMANDS_DEFAULT);
    }

    public String getGdbClientCommands(String prefix) {
        return this.getString(String.valueOf(prefix) + "gdb.client.commands", CLIENT_COMMANDS_DEFAULT);
    }

    @Deprecated
    public boolean getQemuDebugInRam() {
        return this.getBoolean("gdb.qemu.doDebugInRam", false);
    }

    public boolean getQemuDebugInRam(String prefix) {
        return this.getBoolean(String.valueOf(prefix) + "gdb.qemu.doDebugInRam", false);
    }

    @Deprecated
    public boolean getQemuDoInitialReset() {
        return this.getBoolean("gdb.qemu.doInitialReset", false);
    }

    public boolean getQemuDoInitialReset(String prefix) {
        return this.getBoolean(String.valueOf(prefix) + "gdb.qemu.doInitialReset", false);
    }

    @Deprecated
    public String getQemuInitOther() {
        return this.getString("gdb.qemu.init.other", "");
    }

    public String getQemuInitOther(String prefix) {
        return this.getString(String.valueOf(prefix) + "gdb.qemu.init.other", "");
    }

    @Deprecated
    public boolean getQemuDoPreRunReset() {
        return this.getBoolean("gdb.qemu.doPreRunReset", true);
    }

    public boolean getQemuDoPreRunReset(String prefix) {
        return this.getBoolean(String.valueOf(prefix) + "gdb.qemu.doPreRunReset", true);
    }

    @Deprecated
    public String getQemuPreRunOther() {
        return this.getString("gdb.qemu.preRun.other", "");
    }

    public String getQemuPreRunOther(String prefix) {
        return this.getString(String.valueOf(prefix) + "gdb.qemu.preRun.other", "");
    }

    @Deprecated
    public boolean getQemuDisableGraphics() {
        return this.getBoolean("gdb.qemu.disableGraphics", false);
    }

    public boolean getQemuDisableGraphics(String prefix) {
        return this.getBoolean(String.valueOf(prefix) + "gdb.qemu.disableGraphics", false);
    }

    @Deprecated
    protected String getRegistryInstallFolder(String subFolder, String executableName) {
        String path = Discoverer.getRegistryInstallFolder((String)executableName, (String)subFolder, (String)REG_SUBKEY, (String)REG_NAME);
        return path;
    }
}

