package simplewebmodel.metrics;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.refactor.metrics.interfaces.IMetricCalculator;
import org.eclipse.emf.refactor.metrics.ocl.managers.OCLManager;

import simplewebmodel.WebModel;

public class NumberOfDynamicPages implements IMetricCalculator {

	private List<EObject> context; 
	
	private final String oclExpression_v1 = 
		"self.hypertextLayer.pages " +
		"-> select(oclIsKindOf(DynamicPage)) " +
		"-> size()";	
	
	private final String oclExpression_v2 = 
		"DynamicPage.allInstances() -> size()";	

	@Override
	public double calculate() {
		WebModel model = (WebModel) context.get(0);
		OCLManager.evaluateOCLOnContextObject(model, oclExpression_v1);
		return OCLManager.evaluateOCLOnContextObject(model, oclExpression_v2);
	}

	@Override
	public void setContext(List<EObject> context) {
		this.context = context;
	}

}
