/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.ecore;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.emfstore.common.model.ESModelElementId;
import org.eclipse.emf.emfstore.common.model.ESSingletonIdResolver;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.ModelFactory;

public class EDatatypeIdResolver
implements ESSingletonIdResolver {
    private final Map<String, EDataType> datatypes = new LinkedHashMap<String, EDataType>();

    public EDatatypeIdResolver() {
        this.datatypes.put("Literal", EcorePackage.eINSTANCE.getEString());
        this.datatypes.put("String", EcorePackage.eINSTANCE.getEString());
        this.datatypes.put("EString", EcorePackage.eINSTANCE.getEString());
        this.datatypes.put("Date", EcorePackage.eINSTANCE.getEDate());
        this.datatypes.put("EDate", EcorePackage.eINSTANCE.getEDate());
        this.datatypes.put("Int", EcorePackage.eINSTANCE.getEInt());
        this.datatypes.put("EInt", EcorePackage.eINSTANCE.getEInt());
        this.datatypes.put("Integer", EcorePackage.eINSTANCE.getEIntegerObject());
        this.datatypes.put("EInteger", EcorePackage.eINSTANCE.getEIntegerObject());
        this.datatypes.put("EIntegerObject", EcorePackage.eINSTANCE.getEIntegerObject());
        this.datatypes.put("Double", EcorePackage.eINSTANCE.getEDouble());
        this.datatypes.put("EDouble", EcorePackage.eINSTANCE.getEDouble());
        this.datatypes.put("EDoubleObject", EcorePackage.eINSTANCE.getEDoubleObject());
        this.datatypes.put("Long", EcorePackage.eINSTANCE.getELong());
        this.datatypes.put("ELong", EcorePackage.eINSTANCE.getELong());
        this.datatypes.put("ELongObject", EcorePackage.eINSTANCE.getELongObject());
        this.datatypes.put("Float", EcorePackage.eINSTANCE.getEFloat());
        this.datatypes.put("EFloat", EcorePackage.eINSTANCE.getEFloat());
        this.datatypes.put("EFloatObject", EcorePackage.eINSTANCE.getEFloatObject());
        this.datatypes.put("Short", EcorePackage.eINSTANCE.getEShort());
        this.datatypes.put("EShort", EcorePackage.eINSTANCE.getEShort());
        this.datatypes.put("EShortObject", EcorePackage.eINSTANCE.getEShortObject());
        this.datatypes.put("Boolean", EcorePackage.eINSTANCE.getEBoolean());
        this.datatypes.put("EBoolean", EcorePackage.eINSTANCE.getEBoolean());
        this.datatypes.put("EBooleanObject", EcorePackage.eINSTANCE.getEBooleanObject());
        this.datatypes.put("Byte", EcorePackage.eINSTANCE.getEByte());
        this.datatypes.put("EByte", EcorePackage.eINSTANCE.getEByte());
        this.datatypes.put("EByteObject", EcorePackage.eINSTANCE.getEByteObject());
        this.datatypes.put("EByteArray", EcorePackage.eINSTANCE.getEByteArray());
        this.datatypes.put("EChar", EcorePackage.eINSTANCE.getEChar());
        this.datatypes.put("ECharacterObject", EcorePackage.eINSTANCE.getECharacterObject());
        this.datatypes.put("EBigDecimal", EcorePackage.eINSTANCE.getEBigDecimal());
        this.datatypes.put("EBigInteger", EcorePackage.eINSTANCE.getEBigInteger());
    }

    public EObject getSingleton(ESModelElementId singletonId) {
        if (singletonId == null) {
            return null;
        }
        return (EObject)this.datatypes.get(singletonId.getId());
    }

    public ESModelElementId getSingletonModelElementId(EObject singleton) {
        if (!EDataType.class.isInstance(singleton)) {
            return null;
        }
        for (Map.Entry<String, EDataType> entry : this.datatypes.entrySet()) {
            if (entry.getValue() != singleton) continue;
            ModelElementId id = ModelFactory.eINSTANCE.createModelElementId();
            id.setId(entry.getKey());
            return (ESModelElementId)id.toAPI();
        }
        return null;
    }

    public boolean isSingleton(EObject eDataType) {
        if (!EDataType.class.isInstance(eDataType)) {
            return false;
        }
        return this.datatypes.containsValue(eDataType);
    }
}

