/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.soda.dk.core.EscObject;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.parameter.Parameters;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;
import org.eclipse.soda.dk.parameter.service.ParameterService;

public class MapParameters
extends Parameters
implements ParameterService {
    protected int offset = -1;

    public MapParameters(String key, ParameterService[] parameters) {
        super(key, parameters);
    }

    public MapParameters(String key, ParameterService[] parameters, int offset) {
        super(key, parameters);
        this.setOffset(offset);
    }

    public Object decodeValue(MessageService message, ParameterCursorService cursor) {
        int length = this.parameters.length;
        Hashtable<Object, Object> result = new Hashtable<Object, Object>((length << 1) - 1);
        int count = 0;
        int index = 0;
        while (index < length) {
            ParameterService parameter = this.parameters[index];
            Object value = parameter.decodeValue(message, cursor);
            if (!parameter.isConstantParameter() && value != null) {
                String key = parameter.getKey();
                if (key != null) {
                    result.put(key, value);
                }
                result.put(EscObject.createInteger(count), value);
                ++count;
            }
            ++index;
        }
        return result;
    }

    public MessageService encodeValue(MessageService message, Object value, ParameterCursorService cursor) {
        MessageService resultMessage = message;
        if (value instanceof Map) {
            Map values = (Map)value;
            int index = this.parameters.length - 1;
            while (index >= 0) {
                String key = this.parameters[index].getKey();
                resultMessage = this.parameters[index].encodeValue(resultMessage, values.get(key), cursor);
                --index;
            }
        } else {
            StringBuffer buffer = new StringBuffer();
            buffer.append("key=");
            buffer.append(this.getKey());
            buffer.append(",value=");
            buffer.append(value);
            throw new IllegalArgumentException(buffer.toString());
        }
        return resultMessage;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}

