/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.parameter;

import java.util.Map;
import org.eclipse.soda.dk.core.EscConfiguration;
import org.eclipse.soda.dk.parameter.BaseKeyParameter;
import org.eclipse.soda.dk.parameter.service.ParameterCursorService;

public class NumberParameter
extends BaseKeyParameter {
    public NumberParameter(String key) {
        super(key);
    }

    public NumberParameter() {
    }

    public Object decodeBytes(byte[] container, ParameterCursorService cursor) {
        return NumberParameter.createNumber(NumberParameter.getLong(container, this.getOffsetAbsolute(cursor), this.getLength(cursor)));
    }

    public byte[] encodeBytes(byte[] container, Object data, ParameterCursorService cursor) {
        int bytesLength = cursor != null ? cursor.getMessageLength() : container.length << 3;
        return NumberParameter.setBits(container, bytesLength, this.getOffsetAbsolute(cursor), this.getLength(cursor), this.longValue(data), this.isInsert(cursor));
    }

    public long longValue(Object data) {
        if (data == null) {
            StringBuffer buffer = new StringBuffer(512);
            buffer.append("key=");
            buffer.append(this.getKey());
            buffer.append(",data=");
            buffer.append(data);
            throw new IllegalArgumentException(buffer.toString());
        }
        if (data instanceof Map) {
            Object value;
            Map map = (Map)data;
            String key = this.getKey();
            if (key != null && key.length() > 0 && (value = map.get(key)) != null) {
                return EscConfiguration.longValue(value);
            }
        }
        return EscConfiguration.longValue(data);
    }
}

