/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.udp.transport;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.nls.Nls;
import org.eclipse.soda.dk.transport.ThreadTransport;
import org.eclipse.soda.dk.transport.service.TransportService;
import org.eclipse.soda.dk.udp.transport.UdpMessage;
import org.eclipse.soda.dk.udp.transport.UdpTransportResourceBundle;
import org.eclipse.soda.dk.udp.transport.service.UdpTransportService;

public class UdpTransport
extends ThreadTransport
implements TransportService,
UdpTransportService {
    public static final String CLASS_NAME = "org.eclipse.soda.dk.udp.transport.UdpTransport";
    protected static final int DEFAULT_LOCALPORT = 0;
    public static final int SOCKET_CONNECT_EXCEPTION_RESOURCE = 2100;
    public static final int UNKNOWN_HOST_EXCEPTION_RESOURCE = 2101;
    private static ResourceBundle DefaultResourceBundle;
    private InetAddress localHostAddress;
    protected int localPortNum;
    private int packetSize;
    private int readTimeout;
    protected InetAddress remoteHostAddress;
    private int remotePortNum;
    private DatagramSocket socket;
    private String localhost;
    private int localport;
    private int packetsize;
    private String remotehost;
    private int remoteport;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.soda.dk.udp.transport.UdpTransportResourceBundle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DefaultResourceBundle = Nls.getResourceBundle((Class)clazz);
    }

    public UdpTransport() {
    }

    public UdpTransport(String remoteHostString, int remotePortNum, String localHostString, int localPortNum, int packetSize, int readTimeout) throws RuntimeException {
        this.setReadTimeout(readTimeout);
        try {
            this.remoteHostAddress = InetAddress.getByName(remoteHostString);
        }
        catch (UnknownHostException e) {
            this.handleError(e, 2101);
            throw new RuntimeException(String.valueOf(e));
        }
        try {
            this.localHostAddress = InetAddress.getByName(localHostString);
        }
        catch (UnknownHostException e) {
            this.handleError(e, 2101);
            throw new RuntimeException(e.toString());
        }
        this.remotePortNum = remotePortNum;
        this.localPortNum = localPortNum;
        this.packetSize = packetSize;
    }

    protected boolean attemptRecoveryFromError(int errorNumber, Throwable error) {
        if (errorNumber == 2101) {
            return false;
        }
        if (errorNumber == 2100) {
            return false;
        }
        return super.attemptRecoveryFromError(errorNumber, error);
    }

    public void close() {
        if (this.getSocket() != null) {
            this.getSocket().close();
            this.setSocket(null);
        }
    }

    public void connect() throws Exception {
        if (this.getSocket() == null) {
            try {
                this.setSocket(this.createSocket());
                this.getSocket().setSoTimeout(this.getReadTimeout());
                super.connect();
            }
            catch (IOException e) {
                this.handleError(e, 2100);
                this.setSocket(null);
                throw e;
            }
        }
    }

    protected synchronized DatagramSocket createSocket() throws IOException {
        return new DatagramSocket(this.localPortNum, this.localHostAddress);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    protected int getErrorSeverity(int errorNumber, Throwable error) {
        if (errorNumber == 2101) {
            return 1;
        }
        if (errorNumber == 2100) {
            return 1;
        }
        return super.getErrorSeverity(errorNumber, error);
    }

    public String getLocalhost() {
        return this.localhost;
    }

    public int getLocalport() {
        return this.localport;
    }

    public int getPacketsize() {
        return this.packetsize;
    }

    protected int getReadTimeout() {
        return this.readTimeout;
    }

    public String getRemotehost() {
        return this.remotehost;
    }

    public int getRemoteport() {
        return this.remoteport;
    }

    public String getResource(int resourceId) {
        try {
            return DefaultResourceBundle.getString(UdpTransportResourceBundle.getKey(resourceId));
        }
        catch (Exception exception) {
            return super.getResource(resourceId);
        }
    }

    protected synchronized DatagramSocket getSocket() {
        return this.socket;
    }

    public void processInput() throws Exception {
        while (this.isRunning() && this.isActive()) {
            try {
                DatagramPacket packet = new DatagramPacket(new byte[this.packetSize], this.packetSize);
                this.getSocket().receive(packet);
                if (!this.hasListeners() || packet.getLength() <= 0) continue;
                byte[] data = new byte[packet.getLength()];
                System.arraycopy(packet.getData(), 0, data, 0, packet.getLength());
                this.fireMessageReceived(UdpTransport.getCurrentTimestamp(), (MessageService)new UdpMessage(data, packet.getAddress().getHostAddress(), packet.getPort()));
            }
            catch (InterruptedIOException e) {
                this.handleError(e, 2015, this.getHistory());
            }
            catch (IOException exception) {
                this.handleError(exception, 2015, this.getHistory());
            }
        }
    }

    public void setLocalhost(String localhost) {
        this.localhost = localhost;
    }

    public void setLocalport(int localport) {
        this.localport = localport;
    }

    public void setPacketsize(int packetsize) {
        this.packetsize = packetsize;
    }

    protected void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setRemotehost(String remotehost) {
        this.remotehost = remotehost;
    }

    public void setRemoteport(int remoteport) {
        this.remoteport = remoteport;
    }

    protected void setSocket(DatagramSocket socket) {
        this.socket = socket;
    }

    public void setup() {
        super.setup();
        this.setRemotehost(this.getString("udptransport.remotehost", this.getRemotehost()));
        this.setRemoteport(this.getInt("udptransport.remoteport", this.getRemoteport()));
        this.setLocalhost(this.getString("udptransport.localhost", this.getLocalhost()));
        this.setLocalport(this.getInt("udptransport.localport", this.getLocalport()));
        this.setPacketsize(this.getInt("udptransport.packetsize", this.getPacketsize()));
        this.setRetryTime(this.getLong("udptransport.retrytime", this.getRetryTime()));
        this.setNoActivityTimeout(this.getLong("udptransport.noactivitytimeout", this.getNoActivityTimeout()));
    }

    public synchronized void write(byte[] sendBytes) throws Exception {
        DatagramPacket sendPacket = new DatagramPacket(sendBytes, sendBytes.length, this.remoteHostAddress, this.remotePortNum);
        this.getSocket().send(sendPacket);
    }
}

