/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.internal.equinox.console.cmdprov.bundle;

import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.soda.sat.core.framework.BaseBundleActivator;
import org.eclipse.soda.sat.core.service.BundleDependencyService;
import org.eclipse.soda.sat.core.util.MiscUtility;
import org.eclipse.soda.sat.internal.equinox.console.cmdprov.BundleDependencyCommandProvider;
import org.eclipse.soda.sat.internal.equinox.console.cmdprov.ConfigurationAdminCommandProvider;
import org.eclipse.soda.sat.internal.equinox.console.cmdprov.LogUtilityCommandProvider;
import org.eclipse.soda.sat.internal.equinox.console.cmdprov.MissingImportedServicesCommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;

public class Activator
extends BaseBundleActivator {
    private static final String CONFIGURATION_ADMIN_SERVICE_NAME;
    private static final String COMMAND_PROVIDER_SERVICE_NAME;
    private CommandProvider configurationAdminCommandProvider;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ConfigurationAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CONFIGURATION_ADMIN_SERVICE_NAME = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        COMMAND_PROVIDER_SERVICE_NAME = clazz2.getName();
    }

    protected void activate() {
        this.addExportedBundleDependencyCommandProvider();
        this.addExportedLogUtilityCommandProvider();
        this.addExportedMissingImportedServicesCommandProvider();
    }

    private void addExportedBundleDependencyCommandProvider() {
        boolean enabled = this.isBundleDependencyServiceEnabled();
        if (!enabled) {
            return;
        }
        BundleContext context = this.getBundleContext();
        BundleDependencyService bds = this.getBundleDependencyService();
        BundleDependencyCommandProvider service = new BundleDependencyCommandProvider(context, bds);
        this.addExportedService(COMMAND_PROVIDER_SERVICE_NAME, service, null);
    }

    private void addExportedConfigurationAdminCommandProvider(ConfigurationAdmin admin) {
        BundleContext context = this.getBundleContext();
        ConfigurationAdminCommandProvider service = new ConfigurationAdminCommandProvider(context, admin);
        this.setConfigurationAdminCommandProvider(service);
        this.addExportedService(COMMAND_PROVIDER_SERVICE_NAME, service, null);
    }

    private void addExportedLogUtilityCommandProvider() {
        BundleContext context = this.getBundleContext();
        LogUtilityCommandProvider service = new LogUtilityCommandProvider(context);
        this.addExportedService(COMMAND_PROVIDER_SERVICE_NAME, service, null);
    }

    private void addExportedMissingImportedServicesCommandProvider() {
        boolean enabled = this.isBundleDependencyServiceEnabled();
        if (!enabled) {
            return;
        }
        BundleContext context = this.getBundleContext();
        BundleDependencyService bds = this.getBundleDependencyService();
        MissingImportedServicesCommandProvider service = new MissingImportedServicesCommandProvider(context, bds);
        this.addExportedService(COMMAND_PROVIDER_SERVICE_NAME, service, null);
    }

    private BundleDependencyService getBundleDependencyService() {
        return (BundleDependencyService)this.getImportedService(BundleDependencyService.SERVICE_NAME);
    }

    private final CommandProvider getConfigurationAdminCommandProvider() {
        return this.configurationAdminCommandProvider;
    }

    protected String[] getImportedServiceNames() {
        return new String[]{BundleDependencyService.SERVICE_NAME};
    }

    protected String[] getOptionalImportedServiceNames() {
        return new String[]{CONFIGURATION_ADMIN_SERVICE_NAME};
    }

    protected void handleAcquiredOptionalImportedService(String serviceName, Object service) {
        if (serviceName.equals(CONFIGURATION_ADMIN_SERVICE_NAME)) {
            ConfigurationAdmin admin = (ConfigurationAdmin)service;
            this.addExportedConfigurationAdminCommandProvider(admin);
        } else {
            super.handleAcquiredOptionalImportedService(serviceName, service);
        }
    }

    protected void handleReleasedOptionalImportedService(String serviceName, Object service) {
        if (serviceName.equals(CONFIGURATION_ADMIN_SERVICE_NAME)) {
            this.removeExportedConfigurationAdminCommandProvider();
        } else {
            super.handleReleasedOptionalImportedService(serviceName, service);
        }
    }

    private boolean isBundleDependencyServiceEnabled() {
        MiscUtility utility = MiscUtility.getInstance();
        boolean status = utility.getBooleanProperty("org.eclipse.soda.sat.core.bds.status", true);
        return status;
    }

    private void removeExportedConfigurationAdminCommandProvider() {
        CommandProvider service = this.getConfigurationAdminCommandProvider();
        this.removeExportedService(COMMAND_PROVIDER_SERVICE_NAME, service);
        this.setConfigurationAdminCommandProvider(null);
    }

    private final void setConfigurationAdminCommandProvider(CommandProvider configurationAdminCommandProvider) {
        this.configurationAdminCommandProvider = configurationAdminCommandProvider;
    }
}

