/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardPreferences;
import org.eclipse.soda.sat.plugin.activator.ui.internal.TypeScopePreferencesCompositeBuilder;
import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.util.FactoryUtility;
import org.eclipse.soda.sat.plugin.ui.util.UiUtility;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ActivatorWizardPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String ACTIVATOR_KEY = "ActivatorWizardPreferencePage.Activator";
    private static final String DESCRIPTION_KEY = "ActivatorWizardPreferencePage.Description";
    private static final String CLASS_NAME_KEY = "ActivatorWizardPreferencePage.ClassName";
    private static final String CLASS_NAME_TEXT_TOOL_TIP_KEY = "ActivatorWizardPreferencePage.ClassNameTextToolTip";
    private static final String CREATE_EXPORTED_PROXY_SERVICES_KEY = "ActivatorWizardPreferencePage.CreateExportedProxyServices";
    private static final String DO_NOT_SHOW_PREVIEW_PAGE_KEY = "ActivatorWizardPreferencePage.DoNotShowPreviewPage";
    private static final String EXPORT_SERVICES_WITH_PROPERTIES_KEY = "ActivatorWizardPreferencePage.ExportServicesWithProperties";
    private static final String EXPORTED_SERVICES_KEY = "ActivatorWizardPreferencePage.ExportedServices";
    private static final String GENERATE_IMPORTED_SERVICE_GETTER_METHODS_KEY = "ActivatorWizardPreferencePage.GenerateImportedServiceGetterMethods";
    private static final String INVALID_CLASS_NAME_ERROR_KEY = "ActivatorWizardPreferencePage.InvalidClassName";
    private static final String INVALID_PACKAGE_NAME_SUFFIX_ERROR_KEY = "ActivatorWizardPreferencePage.InvalidPackageNameSuffix";
    private static final String IMPORTED_SERVICES_KEY = "ActivatorWizardPreferencePage.ImportedServices";
    private static final String MISCELLANEOUS_KEY = "ActivatorWizardPreferencePage.Miscellaneous";
    private static final String OPTIONALLY_IMPORT_SERVICES_KEY = "ActivatorWizardPreferencePage.OptionallyImportServices";
    private static final String OVERWRITE_MANIFEST_KEY = "ActivatorWizardPreferencePage.OverwriteManifest";
    private static final String PACKAGE_NAME_SUFFIX_KEY = "ActivatorWizardPreferencePage.PackageNameSuffix";
    private static final String PACKAGE_NAME_SUFFIX_TEXT_TOOL_TIP_KEY = "ActivatorWizardPreferencePage.PackageNameSuffixTextToolTip";
    private static final String STORE_EXPORTED_SERVICES_IN_FIELDS_KEY = "ActivatorWizardPreferencePage.StoreExportedServicesInFields";
    private static final char COLON_CHARACTER = ':';
    private static final String HELP_CONTEXT_ID = "org.eclipse.soda.sat.plugin.activator.ui.preferences";
    private Text classNameText;
    private Text packageNameSuffixText;
    private Button optionallyImportServicesButton;
    private Button generateImportedServiceGetterMethodsButton;
    private Button storeExportedServicesInFieldsButton;
    private Button exportServicesWithPropertiesButton;
    private Button createExportedProxyServicesButton;
    private Button doNotShowPreviewPageButton;
    private Button overwriteManifestButton;
    private TypeScopePreferencesCompositeBuilder typeScopePreferencesCompositeBuilder;

    public ActivatorWizardPreferencePage() {
        String description = String.valueOf(Messages.getString(DESCRIPTION_KEY)) + ':';
        this.setDescription(description);
    }

    private void buildActivatorPreferences(Composite parent) {
        String text = Messages.getString(ACTIVATOR_KEY);
        Group composite = this.createGroup(parent, text, 2);
        this.buildClassNameRow((Composite)composite);
        this.buildPackageNameSuffixRow((Composite)composite);
    }

    private Button buildCheckbox(Composite parent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        return button;
    }

    private void buildClassNameRow(Composite parent) {
        String value = String.valueOf(Messages.getString(CLASS_NAME_KEY)) + ':';
        this.buildLabel(parent, value);
        String tooltip = Messages.getString(CLASS_NAME_TEXT_TOOL_TIP_KEY);
        Text text = this.buildText(parent, 0, tooltip);
        this.setClassNameText(text);
        KeyListener keyListener = this.createJavaIdentifierKeyListener();
        text.addKeyListener(keyListener);
    }

    private Composite buildComposite(Composite parent) {
        UiUtility utility = UiUtility.getInstance();
        utility.setHelp((Control)parent, HELP_CONTEXT_ID);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.buildActivatorPreferences(composite);
        this.buildServicesPreferences(composite);
        this.buildMiscellaneousPreferences(composite);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void buildCreateExportedProxyServicesRow(Composite parent) {
        String value = Messages.getString(CREATE_EXPORTED_PROXY_SERVICES_KEY);
        Button button = this.buildCheckbox(parent, value);
        this.setCreateExportedProxyServicesButton(button);
    }

    private void buildDoNotShowPreviewPageRow(Composite parent) {
        String value = Messages.getString(DO_NOT_SHOW_PREVIEW_PAGE_KEY);
        Button button = this.buildCheckbox(parent, value);
        this.setDoNotShowPreviewPageButton(button);
    }

    private void buildExportedServicesPreferences(Composite parent) {
        String text = Messages.getString(EXPORTED_SERVICES_KEY);
        Group composite = this.createGroup(parent, text);
        this.buildStoreExportedServicesInFieldsRow((Composite)composite);
        this.buildRegisterExportedServicesWithPropertiesRow((Composite)composite);
        this.buildCreateExportedProxyServicesRow((Composite)composite);
    }

    private void buildGenerateImportedServiceGetterMethodsRow(Composite parent) {
        String value = Messages.getString(GENERATE_IMPORTED_SERVICE_GETTER_METHODS_KEY);
        Button button = this.buildCheckbox(parent, value);
        this.setGenerateImportedServiceGetterMethodsButton(button);
    }

    private void buildImportedServicesAreOptionalRow(Composite parent) {
        String value = Messages.getString(OPTIONALLY_IMPORT_SERVICES_KEY);
        Button button = this.buildCheckbox(parent, value);
        this.setOptionallyImportServicesButton(button);
    }

    private void buildImportedServicesPreferences(Composite parent) {
        String text = Messages.getString(IMPORTED_SERVICES_KEY);
        Group composite = this.createGroup(parent, text);
        this.buildImportedServicesAreOptionalRow((Composite)composite);
        this.buildGenerateImportedServiceGetterMethodsRow((Composite)composite);
    }

    private void buildLabel(Composite parent, String value) {
        Label label = new Label(parent, 16384);
        label.setText(value);
    }

    private void buildMiscellaneousPreferences(Composite parent) {
        String text = Messages.getString(MISCELLANEOUS_KEY);
        Group composite = this.createGroup(parent, text);
        this.buildDoNotShowPreviewPageRow((Composite)composite);
        this.buildOverwriteBundleActivatorManifestHeaderRow((Composite)composite);
    }

    private void buildOverwriteBundleActivatorManifestHeaderRow(Composite parent) {
        String value = Messages.getString(OVERWRITE_MANIFEST_KEY);
        Button button = this.buildCheckbox(parent, value);
        this.setOverwriteManifestButton(button);
    }

    private void buildPackageNameSuffixRow(Composite parent) {
        String value = String.valueOf(Messages.getString(PACKAGE_NAME_SUFFIX_KEY)) + ':';
        this.buildLabel(parent, value);
        String tooltip = Messages.getString(PACKAGE_NAME_SUFFIX_TEXT_TOOL_TIP_KEY);
        Text text = this.buildText(parent, 0, tooltip);
        this.setPackageNameSuffixText(text);
        KeyListener keyListener = this.createPackageNameSuffixKeyListener();
        text.addKeyListener(keyListener);
    }

    private void buildRegisterExportedServicesWithPropertiesRow(Composite parent) {
        String value = Messages.getString(EXPORT_SERVICES_WITH_PROPERTIES_KEY);
        Button button = this.buildCheckbox(parent, value);
        this.setExportServicesWithPropertiesButton(button);
    }

    private void buildServicesPreferences(Composite parent) {
        this.buildImportedServicesPreferences(parent);
        this.buildExportedServicesPreferences(parent);
        this.buildTypeScopePreferences(parent);
    }

    private void buildStoreExportedServicesInFieldsRow(Composite parent) {
        String value = Messages.getString(STORE_EXPORTED_SERVICES_IN_FIELDS_KEY);
        Button button = this.buildCheckbox(parent, value);
        this.setStoreExportedServicesInFieldsButton(button);
    }

    private Text buildText(Composite parent, int size, String tooltip) {
        Text text = new Text(parent, 2048);
        int limit = size > 0 ? size : Text.LIMIT;
        text.setTextLimit(limit);
        text.setToolTipText(tooltip);
        GridData data = new GridData(768);
        text.setLayoutData((Object)data);
        return text;
    }

    private void buildTypeScopePreferences(Composite parent) {
        TypeScopePreferencesCompositeBuilder builder = new TypeScopePreferencesCompositeBuilder();
        this.setTypeScopePreferencesCompositeBuilder(builder);
        builder.setGroupStyle(768);
        builder.build(parent);
    }

    protected Control createContents(Composite parent) {
        Composite composite = this.buildComposite(parent);
        this.initialize();
        this.hookupModifyListener();
        return composite;
    }

    private Group createGroup(Composite parent, String text) {
        return this.createGroup(parent, text, 1);
    }

    private Group createGroup(Composite parent, String text, int columns) {
        Group group = new Group(parent, 0);
        group.setText(text);
        GridLayout layout = new GridLayout(columns, false);
        group.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        return group;
    }

    private KeyListener createJavaIdentifierKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                boolean valid;
                char ch = event.character;
                event.doit = valid = Character.isJavaIdentifierStart(ch) || Character.isJavaIdentifierPart(ch);
            }
        };
    }

    private ModifyListener createModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ActivatorWizardPreferencePage.this.handleModifiedText();
            }
        };
    }

    private KeyListener createPackageNameSuffixKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                boolean valid;
                char ch = event.character;
                event.doit = valid = ch == '.' || Character.isJavaIdentifierPart(ch);
            }
        };
    }

    private String getClassName() {
        Text text = this.getClassNameText();
        String value = text.getText();
        return value;
    }

    private Text getClassNameText() {
        return this.classNameText;
    }

    private Button getCreateExportedProxyServicesButton() {
        return this.createExportedProxyServicesButton;
    }

    private Button getDoNotShowPreviewPageButton() {
        return this.doNotShowPreviewPageButton;
    }

    private Button getExportServicesWithPropertiesButton() {
        return this.exportServicesWithPropertiesButton;
    }

    private Button getGenerateImportedServiceGetterMethodsButton() {
        return this.generateImportedServiceGetterMethodsButton;
    }

    private IActivatorWizardPreferences getModel() {
        FactoryUtility utility = FactoryUtility.getInstance();
        IActivatorWizardPreferences model = utility.getPreferences();
        return model;
    }

    private Button getOptionallyImportServicesButton() {
        return this.optionallyImportServicesButton;
    }

    private Button getOverwriteManifestButton() {
        return this.overwriteManifestButton;
    }

    private String getPackageNameSuffix() {
        Text text = this.getPackageNameSuffixText();
        String value = text.getText();
        return value;
    }

    private Text getPackageNameSuffixText() {
        return this.packageNameSuffixText;
    }

    private Button getStoreExportedServicesInFieldsButton() {
        return this.storeExportedServicesInFieldsButton;
    }

    private TypeScopePreferencesCompositeBuilder getTypeScopePreferencesCompositeBuilder() {
        return this.typeScopePreferencesCompositeBuilder;
    }

    private void handleModifiedText() {
        this.validate();
    }

    private void hookupModifyListener() {
        ModifyListener listener = this.createModifyListener();
        Text text = this.getClassNameText();
        text.addModifyListener(listener);
        text = this.getPackageNameSuffixText();
        text.addModifyListener(listener);
    }

    public void init(IWorkbench workbench) {
    }

    private void initialize() {
        IActivatorWizardPreferences model = this.getModel();
        String value = model.getClassName();
        Text text = this.getClassNameText();
        text.setText(value);
        value = model.getPackageNameSuffix();
        text = this.getPackageNameSuffixText();
        text.setText(value);
        boolean state = model.getOptionallyImportServices();
        Button button = this.getOptionallyImportServicesButton();
        button.setSelection(state);
        state = model.getGenerateRequiredImportedServiceGetterMethods();
        button = this.getGenerateImportedServiceGetterMethodsButton();
        button.setSelection(state);
        state = model.getStoreExportedServicesInFields();
        button = this.getStoreExportedServicesInFieldsButton();
        button.setSelection(state);
        state = model.getExportServicesWithProperties();
        button = this.getExportServicesWithPropertiesButton();
        button.setSelection(state);
        state = model.getCreateExportedProxyServices();
        button = this.getCreateExportedProxyServicesButton();
        button.setSelection(state);
        TypeScopePreferencesCompositeBuilder builder = this.getTypeScopePreferencesCompositeBuilder();
        state = model.getLimitServicesToInterfaceTypes();
        builder.setLimitServicesToInterfaceTypes(state);
        state = model.getLimitServicesToTypesVisibleToTheProject();
        builder.setLimitServicesToTypesVisibleToProject(state);
        state = model.getDoNotShowPreviewPage();
        button = this.getDoNotShowPreviewPageButton();
        button.setSelection(state);
        state = model.getOverwriteManifest();
        button = this.getOverwriteManifestButton();
        button.setSelection(state);
    }

    public boolean isValid() {
        boolean valid = super.isValid();
        if (!valid) {
            return false;
        }
        valid = this.validate();
        return valid;
    }

    private boolean isValidClassName() {
        String value = this.getClassName();
        IActivatorWizardPreferences model = this.getModel();
        boolean valid = model.isValidClassName(value);
        return valid;
    }

    private boolean isValidPackageNameSuffix() {
        String value = this.getPackageNameSuffix();
        IActivatorWizardPreferences model = this.getModel();
        boolean valid = model.isValidPackageNameSuffix(value);
        return valid;
    }

    protected void performDefaults() {
        IActivatorWizardPreferences model = this.getModel();
        Text text = this.getClassNameText();
        String value = model.getDefaultClassName();
        text.setText(value);
        text = this.getPackageNameSuffixText();
        value = model.getDefaultPackageNameSuffix();
        text.setText(value);
        Button button = this.getOptionallyImportServicesButton();
        boolean state = model.getDefaultOptionallyImportServices();
        button.setSelection(state);
        button = this.getGenerateImportedServiceGetterMethodsButton();
        state = model.getDefaultGenerateRequiredImportedServiceGetterMethods();
        button.setSelection(state);
        button = this.getStoreExportedServicesInFieldsButton();
        state = model.getDefaultStoreExportedServicesInFields();
        button.setSelection(state);
        button = this.getExportServicesWithPropertiesButton();
        state = model.getDefaultExportServicesWithProperties();
        button.setSelection(state);
        button = this.getCreateExportedProxyServicesButton();
        state = model.getDefaultCreateExportedProxyServices();
        button.setSelection(state);
        TypeScopePreferencesCompositeBuilder builder = this.getTypeScopePreferencesCompositeBuilder();
        state = model.getDefaultLimitServicesToInterfaceTypes();
        builder.setLimitServicesToInterfaceTypes(state);
        state = model.getDefaultLimitServicesToTypesVisibleToTheProject();
        builder.setLimitServicesToTypesVisibleToProject(state);
        button = this.getDoNotShowPreviewPageButton();
        state = model.getDefaultDoNotShowPreviewPage();
        button.setSelection(state);
        button = this.getOverwriteManifestButton();
        state = model.getDefaultOverwriteManifest();
        button.setSelection(state);
        super.performDefaults();
    }

    public boolean performOk() {
        boolean valid = this.isValid();
        if (valid) {
            this.savePreferences();
        }
        return valid;
    }

    private void savePreferences() {
        IActivatorWizardPreferences model = this.getModel();
        Text text = this.getClassNameText();
        String value = text.getText();
        model.setClassName(value);
        text = this.getPackageNameSuffixText();
        value = text.getText();
        model.setPackageNameSuffix(value);
        Button button = this.getOptionallyImportServicesButton();
        boolean state = button.getSelection();
        model.setOptionallyImportServices(state);
        button = this.getGenerateImportedServiceGetterMethodsButton();
        state = button.getSelection();
        model.setGenerateRequiredImportedServiceGetterMethods(state);
        button = this.getStoreExportedServicesInFieldsButton();
        state = button.getSelection();
        model.setStoreExportedServicesInFields(state);
        button = this.getExportServicesWithPropertiesButton();
        state = button.getSelection();
        model.setExportServicesWithProperties(state);
        button = this.getCreateExportedProxyServicesButton();
        state = button.getSelection();
        model.setCreateExportedProxyServices(state);
        TypeScopePreferencesCompositeBuilder builder = this.getTypeScopePreferencesCompositeBuilder();
        state = builder.getLimitServicesToInterfaceTypes();
        model.setLimitServicesToInterfaceTypes(state);
        state = builder.getLimitServicesToTypesVisibleToProject();
        model.setLimitServicesToTypesVisibleToTheProject(state);
        button = this.getDoNotShowPreviewPageButton();
        state = button.getSelection();
        model.setDoNotShowPreviewPage(state);
        button = this.getOverwriteManifestButton();
        state = button.getSelection();
        model.setOverwriteManifest(state);
        model.save();
    }

    private void setClassNameText(Text classNameText) {
        this.classNameText = classNameText;
    }

    private void setCreateExportedProxyServicesButton(Button createExportedProxyServicesButton) {
        this.createExportedProxyServicesButton = createExportedProxyServicesButton;
    }

    private void setDoNotShowPreviewPageButton(Button doNotShowPreviewPageButton) {
        this.doNotShowPreviewPageButton = doNotShowPreviewPageButton;
    }

    private void setExportServicesWithPropertiesButton(Button exportServicesWithPropertiesButton) {
        this.exportServicesWithPropertiesButton = exportServicesWithPropertiesButton;
    }

    private void setGenerateImportedServiceGetterMethodsButton(Button generateImportedServiceGetterMethodsButton) {
        this.generateImportedServiceGetterMethodsButton = generateImportedServiceGetterMethodsButton;
    }

    private void setOptionallyImportServicesButton(Button optionallyImportServicesButton) {
        this.optionallyImportServicesButton = optionallyImportServicesButton;
    }

    private void setOverwriteManifestButton(Button overwriteBundleActivatorManifestHeaderButton) {
        this.overwriteManifestButton = overwriteBundleActivatorManifestHeaderButton;
    }

    private void setPackageNameSuffixText(Text packageNameSuffixText) {
        this.packageNameSuffixText = packageNameSuffixText;
    }

    private void setStoreExportedServicesInFieldsButton(Button storeExportedServicesInFieldsButton) {
        this.storeExportedServicesInFieldsButton = storeExportedServicesInFieldsButton;
    }

    private void setTypeScopePreferencesCompositeBuilder(TypeScopePreferencesCompositeBuilder typeScopePreferencesCompositeBuilder) {
        this.typeScopePreferencesCompositeBuilder = typeScopePreferencesCompositeBuilder;
    }

    protected void updateApplyButton() {
        super.updateApplyButton();
        this.setErrorMessage(null);
    }

    private boolean validate() {
        boolean valid = this.isValidClassName();
        if (!valid) {
            String pattern = Messages.getString(INVALID_CLASS_NAME_ERROR_KEY);
            String className = this.getClassName();
            Object[] values = new Object[]{className};
            String message = MessageFormat.format(pattern, values);
            this.setErrorMessage(message);
            return false;
        }
        valid = this.isValidPackageNameSuffix();
        if (!valid) {
            String pattern = Messages.getString(INVALID_PACKAGE_NAME_SUFFIX_ERROR_KEY);
            String packageNameSuffix = this.getPackageNameSuffix();
            Object[] values = new Object[]{packageNameSuffix};
            String message = MessageFormat.format(pattern, values);
            this.setErrorMessage(message);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

