/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardModel;
import org.eclipse.soda.sat.plugin.activator.IActivatorWizardPreferences;
import org.eclipse.soda.sat.plugin.activator.IImportedServiceDetails;
import org.eclipse.soda.sat.plugin.activator.ui.internal.bundle.Activator;
import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.BuildPropertiesFileManager;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.JavaUtility;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.api.IManifestFileManager;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.api.IPropertiesFileManager;
import org.eclipse.soda.sat.plugin.activator.util.FactoryUtility;
import org.eclipse.soda.sat.plugin.ui.util.IHandyPromptDialog;
import org.eclipse.soda.sat.plugin.ui.util.UiUtility;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CreateActivatorArtifactsOperation
extends WorkspaceModifyOperation {
    private static final String CONFIRM_OVERWRITE_DIALOG_TITLE_KEY = "CreateActivatorArtifactsOperation.ConfirmOverwriteDialogTitle";
    private static final String CONFIRM_OVERWRITE_FILE_KEY = "CreateActivatorArtifactsOperation.ConfirmOverwriteFile";
    private static final String LAZY_BUNDLE_ACTIVATOR_PROPERTIES_FOR_BUNDLE_COMMENT = "CreateActivatorArtifactsOperation.LazyBundleActivatorPropertiesForBundleComment";
    private static final String MANIFEST_HEADER_IS_ALREADY_SET_KEY = "CreateActivatorArtifactsOperation.ManifestHeaderIsAlreadySet";
    private static final String OVERWRITE_IN_FUTURE_WITHOUT_WARNING_KEY = "CreateActivatorArtifactsOperation.OverwriteInFutureWithoutWarning";
    private static final String PROPERTIES_FOR_BUNDLE_COMMENT = "CreateActivatorArtifactsOperation.PropertiesForBundleComment";
    private static final String BUNDLE_ACTIVATOR_HEADER = "Bundle-Activator";
    private static final String IMPORTED_SERVICES_HEADER = "Imported-Services";
    private static final String FILTER_PARAMETER = "filter";
    private static final String BUILD_PROPERTIES_FILENAME = "build.properties";
    private static final String COMPILATION_UNIT_EDITOR_ID = "org.eclipse.jdt.ui.CompilationUnitEditor";
    private static final String JAVA_EXTENSION = ".java";
    private static final String LAZY_BUNDLE_ACTIVATOR = "org.eclipse.soda.sat.core.framework.LazyBundleActivator";
    private IActivatorWizardModel model;
    private IPackageFragmentRoot packageFragmentRoot;
    private IManifestFileManager manifestFileManager;

    CreateActivatorArtifactsOperation(IActivatorWizardModel model, IPackageFragmentRoot packageFragmentRoot, IManifestFileManager manager, IPropertiesFileManager lazyBundleActivatorPropertiesFileManager) {
        this.setModel(model);
        this.setPackageFragmentRoot(packageFragmentRoot);
        this.setManifestFileManager(manager);
    }

    private void createCompilationUnit(IProgressMonitor monitor) throws JavaModelException {
        IPackageFragment packageFragment = this.getPackageFragment();
        boolean packageFragmentExists = packageFragment.exists();
        if (!packageFragmentExists) {
            packageFragment = this.createPackageFragment(monitor);
        }
        IActivatorWizardModel model = this.getModel();
        String name = model.getClassName();
        String contents = model.generate();
        ICompilationUnit compilationUnit = packageFragment.createCompilationUnit(String.valueOf(name) + JAVA_EXTENSION, contents, false, monitor);
        IFile file = (IFile)compilationUnit.getCorrespondingResource();
        UiUtility utility = UiUtility.getInstance();
        try {
            utility.openEditor(file, COMPILATION_UNIT_EDITOR_ID);
        }
        catch (PartInitException exception) {
            this.logError(exception);
        }
    }

    private IHandyPromptDialog createConfirmOverwriteDialog(String message) {
        String title = Messages.getString(CONFIRM_OVERWRITE_DIALOG_TITLE_KEY);
        org.eclipse.soda.sat.plugin.ui.util.FactoryUtility utility = org.eclipse.soda.sat.plugin.ui.util.FactoryUtility.getInstance();
        Shell shell = this.getShell();
        IHandyPromptDialog dialog = utility.createHandyPromptDialog(shell, message);
        dialog.setTitle(title);
        dialog.useQuestionIcon();
        dialog.setCancelButtonText(null);
        dialog.defaultButtonIsNo();
        return dialog;
    }

    private void createFile(IProgressMonitor monitor, IFile file, String contents) throws CoreException {
        byte[] bytes = contents.getBytes();
        ByteArrayInputStream stream = null;
        try {
            try {
                stream = new ByteArrayInputStream(bytes);
                file.create((InputStream)stream, false, monitor);
            }
            finally {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
        }
        catch (IOException exception) {
            this.logError(exception);
        }
    }

    private void createFolders(String folders, IProgressMonitor monitor) throws CoreException {
        if (folders == null) {
            return;
        }
        IJavaProject javaProject = this.getJavaProject();
        IProject project = javaProject.getProject();
        StringTokenizer tokenizer = new StringTokenizer(folders, "\\/");
        String token = new String();
        while (tokenizer.hasMoreTokens()) {
            Path path;
            IFolder folder;
            boolean exists;
            int length = (token = String.valueOf(token) + tokenizer.nextToken()).length();
            if (length == 0 || (exists = (folder = project.getFolder((IPath)(path = new Path(token)))).exists())) continue;
            folder.create(false, true, monitor);
            token = String.valueOf(token) + File.separatorChar;
        }
    }

    private void createLazyBundleActivatorPropertiesFile(IProgressMonitor monitor) throws CoreException {
        boolean overwrite;
        IActivatorWizardModel model = this.getModel();
        boolean lazy = model.getCreateBundleActivatorLazily();
        if (!lazy) {
            return;
        }
        String path = model.getLazyBundleActivatorPropertiesFilename();
        String folders = this.getFolders(path);
        this.createFolders(folders, monitor);
        IFile file = this.getFile(path);
        boolean exists = file.exists();
        if (exists && !(overwrite = this.openConfirmOverwriteFileDialog(path))) {
            return;
        }
        String contents = this.createLazyBundleActivatorPropertiesFileContent();
        this.createFile(monitor, file, contents);
    }

    private String createLazyBundleActivatorPropertiesFileContent() {
        char equalsChar = '=';
        char newLineChar = '\n';
        StringBuffer buffer = new StringBuffer(2000);
        String pattern = Messages.getString(LAZY_BUNDLE_ACTIVATOR_PROPERTIES_FOR_BUNDLE_COMMENT);
        IActivatorWizardModel model = this.getModel();
        String bundleSymbolicName = model.getBundleSymbolicName();
        Object[] values = new Object[]{bundleSymbolicName};
        String comment = MessageFormat.format(pattern, values);
        buffer.append(comment);
        buffer.append(newLineChar);
        buffer.append(newLineChar);
        buffer.append(BUNDLE_ACTIVATOR_HEADER);
        buffer.append(equalsChar);
        String fullyQualifiedClassName = this.getFullyQualifiedClassName();
        buffer.append(fullyQualifiedClassName);
        buffer.append(newLineChar);
        buffer.append(IMPORTED_SERVICES_HEADER);
        buffer.append(equalsChar);
        List<IImportedServiceDetails> importedServiceDetails = this.getRequiredImportedServiceDetails();
        boolean empty = importedServiceDetails.isEmpty();
        if (!empty) {
            char commaChar = ',';
            char continuationChar = '\\';
            char quoteChar = '\"';
            char semicolonChar = ';';
            char spaceChar = ' ';
            buffer.append(continuationChar);
            buffer.append(newLineChar);
            buffer.append(spaceChar);
            int size = importedServiceDetails.size();
            IImportedServiceDetails lastDetails = importedServiceDetails.get(size - 1);
            for (IImportedServiceDetails details : importedServiceDetails) {
                boolean last;
                String serviceName = details.getName();
                buffer.append(serviceName);
                String filter = details.getFilter();
                if (filter != null) {
                    buffer.append(semicolonChar);
                    buffer.append(FILTER_PARAMETER);
                    buffer.append(equalsChar);
                    buffer.append(quoteChar);
                    buffer.append(filter);
                    buffer.append(quoteChar);
                }
                if (last = details.equals(lastDetails)) continue;
                buffer.append(commaChar);
                buffer.append(continuationChar);
                buffer.append(newLineChar);
                buffer.append(spaceChar);
            }
        }
        buffer.append(newLineChar);
        String value = buffer.toString();
        return value;
    }

    private IPackageFragment createPackageFragment(IProgressMonitor monitor) throws JavaModelException {
        IPackageFragmentRoot packageFragmentRoot = this.getPackageFragmentRoot();
        IActivatorWizardModel model = this.getModel();
        String packageName = model.getPackageName();
        IPackageFragment packageFragment = packageFragmentRoot.createPackageFragment(packageName, false, monitor);
        return packageFragment;
    }

    private void createPropertiesFile(IProgressMonitor monitor) throws CoreException {
        boolean fromPackageResource;
        IActivatorWizardModel model = this.getModel();
        int policy = model.getLoadPropertiesPolicy();
        boolean bl = fromPackageResource = policy == 1;
        if (!fromPackageResource) {
            return;
        }
        IPath path = this.getProjectRelativePath();
        String folders = path.toOSString();
        String filename = model.getPropertiesFilename();
        IFile file = this.getFile(folders, filename);
        this.createPropertiesFile(monitor, file);
    }

    private void createPropertiesFile(IProgressMonitor monitor, IFile file) throws CoreException {
        boolean exists = file.exists();
        if (exists) {
            return;
        }
        String contents = this.createPropertiesFileContent();
        this.createFile(monitor, file, contents);
    }

    private String createPropertiesFileContent() {
        IActivatorWizardModel model = this.getModel();
        String bundleSymbolicName = model.getBundleSymbolicName();
        String pattern = Messages.getString(PROPERTIES_FOR_BUNDLE_COMMENT);
        Object[] values = new Object[]{bundleSymbolicName};
        String comment = MessageFormat.format(pattern, values);
        char newLineChar = '\n';
        StringBuffer buffer = new StringBuffer(200);
        buffer.append(comment);
        buffer.append(newLineChar);
        buffer.append(newLineChar);
        String value = buffer.toString();
        return value;
    }

    private void deleteManifestHeader(String header) throws Exception {
        IManifestFileManager manager = this.getManifestFileManager();
        String value = manager.getHeader(header);
        if (value == null) {
            return;
        }
        boolean ok = this.isOkToOverwriteManifest(header);
        if (!ok) {
            return;
        }
        manager.delete(header);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask("Activator Wizard...", 100);
                this.createCompilationUnit(monitor);
                this.updateManifest();
                this.createPropertiesFile(monitor);
                this.createLazyBundleActivatorPropertiesFile(monitor);
                this.updateBuildProperties();
            }
            catch (Exception exception) {
                this.logError(exception);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private IFile getBuildPropertiesFile() {
        IFile file = this.getFile(BUILD_PROPERTIES_FILENAME);
        return file;
    }

    private IFile getFile(String path) {
        String folders = this.getFolders(path);
        String filename = this.getFilename(path);
        IFile file = this.getFile(folders, filename);
        return file;
    }

    private IFile getFile(String folders, String filename) {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        IFile file = JavaUtility.getFile(root, folders, filename);
        return file;
    }

    private String getFilename(String path) {
        int index = path.lastIndexOf(File.separatorChar);
        if (index == -1) {
            return path;
        }
        String filename = path.substring(index + 1);
        return filename;
    }

    private String getFolders(String path) {
        int index = path.lastIndexOf(File.separatorChar);
        if (index == -1) {
            return null;
        }
        String folders = path.substring(0, index);
        return folders;
    }

    private String getFullyQualifiedClassName() {
        String fullyQualifiedClassName;
        IActivatorWizardModel model = this.getModel();
        String packageName = model.getPackageName();
        String className = model.getClassName();
        int length = packageName.length();
        if (length == 0) {
            fullyQualifiedClassName = className;
        } else {
            StringBuffer buffer = new StringBuffer(150);
            buffer.append(packageName);
            buffer.append('.');
            buffer.append(className);
            fullyQualifiedClassName = buffer.toString();
        }
        return fullyQualifiedClassName;
    }

    private IJavaProject getJavaProject() {
        IPackageFragment packageFragment = this.getPackageFragment();
        IJavaProject javaProject = packageFragment.getJavaProject();
        return javaProject;
    }

    private IManifestFileManager getManifestFileManager() {
        return this.manifestFileManager;
    }

    private IActivatorWizardModel getModel() {
        return this.model;
    }

    private IPackageFragment getPackageFragment() {
        IPackageFragmentRoot packageFragmentRoot = this.getPackageFragmentRoot();
        IActivatorWizardModel model = this.getModel();
        String packageName = model.getPackageName();
        IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(packageName);
        return packageFragment;
    }

    private IPackageFragmentRoot getPackageFragmentRoot() {
        return this.packageFragmentRoot;
    }

    private IActivatorWizardPreferences getPreferences() {
        FactoryUtility utility = FactoryUtility.getInstance();
        IActivatorWizardPreferences preferences = utility.getPreferences();
        return preferences;
    }

    private IPath getProjectRelativePath() {
        IPackageFragment packageFragment = this.getPackageFragment();
        IContainer container = (IContainer)packageFragment.getResource();
        IPath path = container.getProjectRelativePath();
        return path;
    }

    private List<IImportedServiceDetails> getRequiredImportedServiceDetails() {
        IActivatorWizardModel model = this.getModel();
        List list = model.getImportedServicesDetails();
        int size = list.size();
        ArrayList<IImportedServiceDetails> result = new ArrayList<IImportedServiceDetails>(size);
        for (IImportedServiceDetails details : list) {
            boolean optional = details.isOptional();
            if (optional) continue;
            result.add(details);
        }
        result.trimToSize();
        return result;
    }

    private Shell getShell() {
        UiUtility utility = UiUtility.getInstance();
        Shell shell = utility.getShell();
        return shell;
    }

    private boolean isOkToOverwriteManifest(String header) {
        boolean overwrite;
        block5: {
            block4: {
                overwrite = false;
                IManifestFileManager manager = this.getManifestFileManager();
                String value = manager.getHeader(header);
                if (value != null) break block4;
                return true;
            }
            IActivatorWizardPreferences preferences = this.getPreferences();
            overwrite = preferences.getOverwriteManifest();
            if (!overwrite) break block5;
            return true;
        }
        try {
            overwrite = this.openConfirmOverwriteManifestHeaderDialog(header);
        }
        catch (Exception exception) {
            this.logError(exception);
        }
        return overwrite;
    }

    private boolean isUsingDefaultLazyBundleActivatorPropertiesFilename() {
        IActivatorWizardModel model = this.getModel();
        String value = model.getLazyBundleActivatorPropertiesFilename();
        String defaultValue = model.getDefaultLazyBundleActivatorPropertiesFilename();
        boolean usingDefault = defaultValue.equals(value);
        return usingDefault;
    }

    private void logError(Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(4, throwable);
    }

    private boolean openConfirmOverwriteDialog(String message) {
        IHandyPromptDialog dialog = this.createConfirmOverwriteDialog(message);
        int rc = dialog.open();
        boolean overwrite = rc == 2;
        return overwrite;
    }

    private boolean openConfirmOverwriteFileDialog(String filename) {
        String pattern = Messages.getString(CONFIRM_OVERWRITE_FILE_KEY);
        Object[] values = new Object[]{filename};
        String message = MessageFormat.format(pattern, values);
        boolean overwrite = this.openConfirmOverwriteDialog(message);
        return overwrite;
    }

    private boolean openConfirmOverwriteManifestHeaderDialog(String header) {
        String pattern = Messages.getString(MANIFEST_HEADER_IS_ALREADY_SET_KEY);
        Object[] values = new Object[]{header};
        String message = MessageFormat.format(pattern, values);
        IHandyPromptDialog dialog = this.createConfirmOverwriteDialog(message);
        String overwriteInFuture = Messages.getString(OVERWRITE_IN_FUTURE_WITHOUT_WARNING_KEY);
        int id = dialog.addCheckbox(overwriteInFuture, false);
        int rc = dialog.open();
        boolean overwrite = rc == 2;
        boolean selected = dialog.isCheckboxSelected(id);
        if (selected) {
            IActivatorWizardPreferences preferences = this.getPreferences();
            preferences.setOverwriteManifest(true);
            preferences.save();
        }
        return overwrite;
    }

    private void putManifestHeader(String header, String value) throws Exception {
        boolean ok;
        IManifestFileManager manager = this.getManifestFileManager();
        String current = manager.getHeader(header);
        boolean match = value.equals(current);
        if (!match && !(ok = this.isOkToOverwriteManifest(header))) {
            return;
        }
        manager.put(header, value);
    }

    private void setManifestFileManager(IManifestFileManager manifestFileManager) {
        this.manifestFileManager = manifestFileManager;
    }

    private void setModel(IActivatorWizardModel model) {
        this.model = model;
    }

    private void setPackageFragmentRoot(IPackageFragmentRoot packageFragmentRoot) {
        this.packageFragmentRoot = packageFragmentRoot;
    }

    private void updateBinIncludesInBuildProperties(BuildPropertiesFileManager manager) {
        IActivatorWizardModel model = this.getModel();
        boolean lazy = model.getCreateBundleActivatorLazily();
        if (!lazy) {
            return;
        }
        String value = model.getLazyBundleActivatorPropertiesFilename();
        manager.addToken("bin.includes", value);
    }

    private void updateBuildProperties() throws CoreException, IOException {
        IFile file = this.getBuildPropertiesFile();
        boolean exists = file.exists();
        if (!exists) {
            return;
        }
        BuildPropertiesFileManager manager = new BuildPropertiesFileManager(file);
        this.updateSecondaryDependenciesInBuildProperties(manager);
        this.updateBinIncludesInBuildProperties(manager);
        manager.save();
    }

    private void updateManifest() throws Exception {
        IManifestFileManager manager = this.getManifestFileManager();
        if (manager == null) {
            return;
        }
        this.updateManifestActivatorHeader();
        this.updateManifestLazyBundleActivatorHeader();
        manager.save();
    }

    private void updateManifestActivatorHeader() throws Exception {
        IActivatorWizardModel model = this.getModel();
        boolean lazyBundleActivator = model.getCreateBundleActivatorLazily();
        String value = lazyBundleActivator ? LAZY_BUNDLE_ACTIVATOR : this.getFullyQualifiedClassName();
        this.putManifestHeader(BUNDLE_ACTIVATOR_HEADER, value);
    }

    private void updateManifestLazyBundleActivatorHeader() throws Exception {
        IActivatorWizardModel model = this.getModel();
        boolean lazy = model.getCreateBundleActivatorLazily();
        String header = "SAT-LazyBundleActivator";
        if (!lazy) {
            this.deleteManifestHeader(header);
        } else {
            boolean usingDefaultLazyBundleActivatorPropertiesFilename = this.isUsingDefaultLazyBundleActivatorPropertiesFilename();
            if (usingDefaultLazyBundleActivatorPropertiesFilename) {
                this.deleteManifestHeader(header);
            } else {
                String value = model.getLazyBundleActivatorPropertiesFilename();
                this.putManifestHeader(header, value);
            }
        }
    }

    private void updateSecondaryDependenciesInBuildProperties(BuildPropertiesFileManager manager) {
        IActivatorWizardModel model = this.getModel();
        List list = model.getBundleDependencies();
        for (String token : list) {
            manager.addToken("additional.bundles", token);
        }
    }
}

