/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ComponentExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SelfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.common.java.DependencyOrderer;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;

public class StateInitVarOrderer
extends DependencyOrderer<Declaration> {
    protected Set<Declaration> findDirectDependencies(Declaration stateVar) {
        Object values;
        if (stateVar instanceof DiscVariable) {
            DiscVariable dvar = (DiscVariable)stateVar;
            if (dvar.getValue() == null) {
                return Sets.set();
            }
            values = dvar.getValue().getValues();
            if (values == null) {
                return Sets.set();
            }
        } else {
            ContVariable cvar = (ContVariable)stateVar;
            if (cvar.getValue() == null) {
                return Sets.set();
            }
            values = Lists.list((Object)cvar.getValue());
        }
        Set rslt = Sets.set();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            Expression value = (Expression)iterator.next();
            StateInitVarOrderer.collectStateVars(value, rslt);
        }
        return rslt;
    }

    private static void collectStateVars(Expression expr, Set<Declaration> variables) {
        if (expr instanceof BoolExpression) {
            return;
        }
        if (expr instanceof IntExpression) {
            return;
        }
        if (expr instanceof RealExpression) {
            return;
        }
        if (expr instanceof StringExpression) {
            return;
        }
        if (expr instanceof TimeExpression) {
            return;
        }
        if (expr instanceof CastExpression) {
            StateInitVarOrderer.collectStateVars(((CastExpression)expr).getChild(), variables);
            return;
        }
        if (expr instanceof UnaryExpression) {
            StateInitVarOrderer.collectStateVars(((UnaryExpression)expr).getChild(), variables);
            return;
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            StateInitVarOrderer.collectStateVars(bexpr.getLeft(), variables);
            StateInitVarOrderer.collectStateVars(bexpr.getRight(), variables);
            return;
        }
        if (expr instanceof IfExpression) {
            IfExpression iexpr = (IfExpression)expr;
            for (Expression guard : iexpr.getGuards()) {
                StateInitVarOrderer.collectStateVars(guard, variables);
            }
            StateInitVarOrderer.collectStateVars(iexpr.getThen(), variables);
            for (ElifExpression elif : iexpr.getElifs()) {
                for (Expression guard : elif.getGuards()) {
                    StateInitVarOrderer.collectStateVars(guard, variables);
                }
                StateInitVarOrderer.collectStateVars(elif.getThen(), variables);
            }
            StateInitVarOrderer.collectStateVars(iexpr.getElse(), variables);
            return;
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression sexpr = (SwitchExpression)expr;
            StateInitVarOrderer.collectStateVars(sexpr.getValue(), variables);
            for (SwitchCase cse : sexpr.getCases()) {
                if (cse.getKey() != null) {
                    StateInitVarOrderer.collectStateVars(cse.getKey(), variables);
                }
                StateInitVarOrderer.collectStateVars(cse.getValue(), variables);
            }
            return;
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            StateInitVarOrderer.collectStateVars(pexpr.getChild(), variables);
            StateInitVarOrderer.collectStateVars(pexpr.getIndex(), variables);
            return;
        }
        if (expr instanceof SliceExpression) {
            SliceExpression sexpr = (SliceExpression)expr;
            StateInitVarOrderer.collectStateVars(sexpr.getChild(), variables);
            if (sexpr.getBegin() != null) {
                StateInitVarOrderer.collectStateVars(sexpr.getBegin(), variables);
            }
            if (sexpr.getEnd() != null) {
                StateInitVarOrderer.collectStateVars(sexpr.getEnd(), variables);
            }
            return;
        }
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression fexpr = (FunctionCallExpression)expr;
            for (Expression arg : fexpr.getArguments()) {
                StateInitVarOrderer.collectStateVars(arg, variables);
            }
            StateInitVarOrderer.collectStateVars(fexpr.getFunction(), variables);
            return;
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            for (Expression elem : lexpr.getElements()) {
                StateInitVarOrderer.collectStateVars(elem, variables);
            }
            return;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            for (Expression elem : sexpr.getElements()) {
                StateInitVarOrderer.collectStateVars(elem, variables);
            }
            return;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            for (Expression field : texpr.getFields()) {
                StateInitVarOrderer.collectStateVars(field, variables);
            }
            return;
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            for (DictPair pair : dexpr.getPairs()) {
                StateInitVarOrderer.collectStateVars(pair.getKey(), variables);
                StateInitVarOrderer.collectStateVars(pair.getValue(), variables);
            }
            return;
        }
        if (expr instanceof ConstantExpression) {
            return;
        }
        if (expr instanceof EnumLiteralExpression) {
            return;
        }
        if (expr instanceof FieldExpression) {
            return;
        }
        if (expr instanceof StdLibFunctionExpression) {
            return;
        }
        if (expr instanceof FunctionExpression) {
            return;
        }
        if (expr instanceof DiscVariableExpression) {
            DiscVariable var = ((DiscVariableExpression)expr).getVariable();
            variables.add((Declaration)var);
            return;
        }
        if (expr instanceof AlgVariableExpression) {
            AlgVariable var = ((AlgVariableExpression)expr).getVariable();
            List<Expression> values = CifEquationUtils.getValuesForAlgVar(var, false);
            for (Expression value : values) {
                StateInitVarOrderer.collectStateVars(value, variables);
            }
            return;
        }
        if (expr instanceof ContVariableExpression) {
            ContVariableExpression cexpr = (ContVariableExpression)expr;
            ContVariable var = ((ContVariableExpression)expr).getVariable();
            if (cexpr.isDerivative()) {
                List<Expression> derivs = CifEquationUtils.getDerivativesForContVar(var, false);
                for (Expression deriv : derivs) {
                    StateInitVarOrderer.collectStateVars(deriv, variables);
                }
                return;
            }
            variables.add((Declaration)var);
            return;
        }
        if (expr instanceof InputVariableExpression) {
            return;
        }
        if (expr instanceof LocationExpression) {
            return;
        }
        if (expr instanceof ComponentExpression) {
            return;
        }
        if (expr instanceof SelfExpression) {
            return;
        }
        throw new RuntimeException("Unexpected expr: " + String.valueOf(expr));
    }
}

