/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.annotations.builtin;

import java.util.List;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotationArgument;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProblemReporter;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;

public class RequirementReachableAnnotationProvider
extends AnnotationProvider {
    @Override
    public final void checkAnnotation(AnnotatedObject annotatedObject, Annotation annotation, AnnotationProblemReporter reporter) {
        CifType valueType;
        if (!(annotatedObject instanceof ComplexComponent)) {
            reporter.reportProblem(annotation, "annotation must be specified on a specification, component, component definition or component instantiation.", annotation.getPosition(), SemanticProblemSeverity.ERROR);
        }
        if (annotation.getArguments().size() != 1) {
            reporter.reportProblem(annotation, "annotation must have exactly one argument.", annotation.getPosition(), SemanticProblemSeverity.ERROR);
            return;
        }
        AnnotationArgument arg = (AnnotationArgument)Lists.first((List)annotation.getArguments());
        if (arg.getName() != null) {
            reporter.reportProblem(annotation, "unsupported named argument.", arg.getPosition(), SemanticProblemSeverity.ERROR);
        }
        if (!((valueType = CifTypeUtils.normalizeType((CifType)arg.getValue().getType())) instanceof BoolType)) {
            reporter.reportProblem(annotation, Strings.fmt((String)"argument must have a value of type \"bool\", but has a value of type \"%s\".", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)valueType)}), arg.getValue().getPosition(), SemanticProblemSeverity.ERROR);
        }
    }

    @Override
    public final void checkGlobal(Specification spec, AnnotationProblemReporter reporter) {
    }
}

