/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.setext.texteditorbase;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public class GenericSpellingReconcileStrategy
extends SpellingReconcileStrategy {
    private static final boolean DEBUG = false;
    private final Set<String> spellingContentTypes;

    public GenericSpellingReconcileStrategy(ISourceViewer viewer, SpellingService spellingService, Set<String> spellingContentTypes) {
        super(viewer, spellingService);
        this.spellingContentTypes = spellingContentTypes;
    }

    public void reconcile(IRegion region) {
        this.removeAnnos(region);
        super.reconcile(region);
    }

    private void removeAnnos(IRegion region) {
        IAnnotationModel model = this.getAnnotationModel();
        if (model == null) {
            return;
        }
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Position position;
            boolean overlap;
            Annotation annotation = (Annotation)iter.next();
            if (!(annotation instanceof SpellingAnnotation) || !(overlap = (position = model.getPosition(annotation)).overlapsWith(region.getOffset(), region.getLength()))) continue;
            model.removeAnnotation(annotation);
        }
    }

    private boolean keepSpellingAnno(SpellingAnnotation annotation, Position position) {
        IDocumentExtension3 document = (IDocumentExtension3)this.getDocument();
        IDocumentPartitioner partitioner = document.getDocumentPartitioner("__dftl_partitioning");
        String contentType = partitioner.getContentType(position.getOffset());
        Assert.notNull((Object)contentType);
        boolean rslt = this.spellingContentTypes.contains(contentType);
        return rslt;
    }

    protected ISpellingProblemCollector createSpellingProblemCollector() {
        IAnnotationModel model = this.getAnnotationModel();
        if (model == null) {
            return null;
        }
        return new SpellingProblemCollector(model);
    }

    private String getAnnotationText(Position position) {
        try {
            IDocument doc = this.getDocument();
            String txt = doc.get(position.getOffset(), position.getLength());
            return "\"" + txt + "\"";
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private class SpellingProblemCollector
    implements ISpellingProblemCollector {
        private final IAnnotationModel annotationModel;
        private List<Pair<SpellingAnnotation, Position>> addAnnos;
        private final Object lockObject;

        public SpellingProblemCollector(IAnnotationModel annotationModel) {
            Assert.notNull((Object)annotationModel);
            this.annotationModel = annotationModel;
            this.lockObject = annotationModel instanceof ISynchronizable ? ((ISynchronizable)annotationModel).getLockObject() : annotationModel;
        }

        public void accept(SpellingProblem problem) {
            Position position = new Position(problem.getOffset(), problem.getLength());
            this.addAnnos.add((Pair<SpellingAnnotation, Position>)Pair.pair((Object)new SpellingAnnotation(problem), (Object)position));
        }

        public void beginCollecting() {
            this.addAnnos = new LinkedList<Pair<SpellingAnnotation, Position>>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endCollecting() {
            Object object = this.lockObject;
            synchronized (object) {
                for (Pair<SpellingAnnotation, Position> entry : this.addAnnos) {
                    SpellingAnnotation annotation = (SpellingAnnotation)entry.left;
                    Position position = (Position)entry.right;
                    if (!GenericSpellingReconcileStrategy.this.keepSpellingAnno(annotation, position)) continue;
                    this.annotationModel.addAnnotation((Annotation)annotation, position);
                }
            }
            this.addAnnos = null;
        }
    }
}

