/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import org.eclipse.escet.cif.checkers.CifCheckNoCompDefInst;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifMath;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SpecNoTooManyPossibleInitialStatesCheck
extends CifCheckNoCompDefInst {
    private CifValueUtils.Count count = new CifValueUtils.Count(1.0, true);

    protected void preprocessDiscVariable(DiscVariable discVar, CifCheckViolations violations) {
        CifValueUtils.Count varCount = CifValueUtils.getPossibleInitialValuesCount((DiscVariable)discVar);
        Assert.check((varCount.value() > 0.0 ? 1 : 0) != 0);
        this.count = this.count.combine(varCount);
    }

    protected void preprocessInputVariable(InputVariable inputVar, CifCheckViolations violations) {
        CifValueUtils.Count varCount = CifValueUtils.getPossibleInitialValuesCount((InputVariable)inputVar);
        Assert.check((varCount.value() > 0.0 ? 1 : 0) != 0);
        this.count = this.count.combine(varCount);
    }

    protected void preprocessAutomaton(Automaton aut, CifCheckViolations violations) {
        CifValueUtils.Count autCount = CifValueUtils.getPossibleInitialLocationsCount((Automaton)aut);
        this.count = this.count.combine(autCount);
    }

    protected void postprocessSpecification(Specification spec, CifCheckViolations violations) {
        double value = this.count.value();
        if (value > 2.147483647E9) {
            if (Double.isInfinite(value)) {
                violations.add((PositionObject)spec, "The specification has practically infinitely many possible initial states", new Object[0]);
            } else {
                Object countTxt = CifMath.realToStr((double)value);
                if (!this.count.isPrecise()) {
                    countTxt = "approximately " + (String)countTxt;
                }
                violations.add((PositionObject)spec, "The specification has %s possible initial states, more than the maximum of 2,147,483,647", countTxt);
            }
        }
    }
}

