/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.List;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTuple;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.FormatDecoder;
import org.eclipse.escet.common.java.FormatDescription;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class CifMath {
    private CifMath() {
    }

    public static int abs(int x, Expression expr) throws CifEvalException {
        if (x == Integer.MIN_VALUE) {
            String msg = CifMath.fmt("Integer overflow: abs(%d).", x);
            throw new CifEvalException(msg, expr);
        }
        return Math.abs(x);
    }

    public static double abs(double x) {
        return Math.abs(x);
    }

    public static double acos(double x, Expression expr) throws CifEvalException {
        double rslt = Math.acos(x);
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: acos(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        if (Double.isNaN(rslt)) {
            String msg = CifMath.fmt("Invalid operation: acos(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double acosh(double x, Expression expr) throws CifEvalException {
        double rslt = FastMath.acosh((double)x);
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: acosh(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        if (Double.isNaN(rslt)) {
            String msg = CifMath.fmt("Invalid operation: acosh(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double asin(double x, Expression expr) throws CifEvalException {
        double rslt = Math.asin(x);
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: asin(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        if (Double.isNaN(rslt)) {
            String msg = CifMath.fmt("Invalid operation: asin(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double asinh(double x, Expression expr) throws CifEvalException {
        double rslt = FastMath.asinh((double)x);
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: asinh(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        if (Double.isNaN(rslt)) {
            String msg = CifMath.fmt("Invalid operation: asinh(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double atan(double x, Expression expr) throws CifEvalException {
        double rslt = Math.atan(x);
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: atan(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        if (Double.isNaN(rslt)) {
            String msg = CifMath.fmt("Invalid operation: atan(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double atanh(double x, Expression expr) throws CifEvalException {
        double rslt = FastMath.atanh((double)x);
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: atanh(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        if (Double.isNaN(rslt)) {
            String msg = CifMath.fmt("Invalid operation: atanh(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static int add(int x, int y, Expression expr) throws CifEvalException {
        long rslt = (long)x + (long)y;
        if (Integer.MIN_VALUE <= rslt && rslt <= Integer.MAX_VALUE) {
            return (int)rslt;
        }
        String msg = CifMath.fmt("Integer overflow: %d + %d.", x, y);
        throw new CifEvalException(msg, expr);
    }

    public static double add(double x, double y, Expression expr) throws CifEvalException {
        double rslt = x + y;
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: %s + %s.", x, y);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static String boolToStr(boolean x) {
        return x ? "true" : "false";
    }

    public static double cbrt(double x) {
        double rslt = Math.cbrt(x);
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static int ceil(double x, Expression expr) throws CifEvalException {
        double rslt = Math.ceil(x);
        if (rslt < -2.147483648E9 || rslt > 2.147483647E9) {
            String msg = CifMath.fmt("Integer overflow: ceil(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return (int)rslt;
    }

    public static double cos(double x, Expression expr) throws CifEvalException {
        double rslt = Math.cos(x);
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: cos(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        if (Double.isNaN(rslt)) {
            String msg = CifMath.fmt("Invalid operation: cos(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double cosh(double x, Expression expr) throws CifEvalException {
        double rslt = Math.cosh(x);
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: cosh(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        if (Double.isNaN(rslt)) {
            String msg = CifMath.fmt("Invalid operation: cosh(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static List<Object> delete(List<Object> lst, int origIdx, Expression expr) throws CifEvalException {
        int idx = origIdx;
        if (idx < 0) {
            idx = lst.size() + idx;
        }
        if (idx < 0 || idx >= lst.size()) {
            String msg = CifMath.fmt("Index out of bounds: del(%s, %s).", CifEvalUtils.objToStr(lst), origIdx);
            throw new CifEvalException(msg, expr);
        }
        List rslt = Lists.copy(lst);
        rslt.remove(idx);
        return rslt;
    }

    public static int div(int x, int y, Expression expr) throws CifEvalException {
        if (y == 0) {
            String msg = CifMath.fmt("Division by zero: %d div %d.", x, y);
            throw new CifEvalException(msg, expr);
        }
        if (x == Integer.MIN_VALUE && y == -1) {
            String msg = CifMath.fmt("Integer overflow: %d div %d.", x, y);
            throw new CifEvalException(msg, expr);
        }
        return x / y;
    }

    public static double divide(double x, double y, Expression expr) throws CifEvalException {
        if (y == 0.0) {
            String msg = CifMath.fmt("Division by zero: %s / %s.", x, y);
            throw new CifEvalException(msg, expr);
        }
        double rslt = x / y;
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: %s * %s.", x, y);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double exp(double x, Expression expr) throws CifEvalException {
        double rslt = Math.exp(x);
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: exp(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static int floor(double x, Expression expr) throws CifEvalException {
        double rslt = Math.floor(x);
        if (rslt < -2.147483648E9 || rslt > 2.147483647E9) {
            String msg = CifMath.fmt("Integer overflow: floor(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return (int)rslt;
    }

    public static String fmt(String pattern, Object ... args) {
        FormatDecoder decoder = new FormatDecoder();
        List parts = decoder.decode(pattern);
        StringBuilder rslt = new StringBuilder();
        int implicitIndex = 0;
        for (FormatDescription part : parts) {
            if (part.conversion == FormatDescription.Conversion.LITERAL) {
                rslt.append(part.text);
                continue;
            }
            int idx = !part.index.isEmpty() ? part.getExplicitIndex() - 1 : implicitIndex++;
            Object value = args[idx];
            switch (part.conversion) {
                case BOOLEAN: 
                case INTEGER: 
                case REAL: {
                    String txt = Strings.fmt((String)part.toString(false), (Object[])new Object[]{value});
                    rslt.append(txt);
                    break;
                }
                case STRING: {
                    if (!(value instanceof String)) {
                        value = CifEvalUtils.objToStr(value);
                    }
                    String txt = Strings.fmt((String)part.toString(false), (Object[])new Object[]{value});
                    rslt.append(txt);
                    break;
                }
                default: {
                    String msg = "Unexpected: " + String.valueOf(part.conversion);
                    throw new RuntimeException(msg);
                }
            }
        }
        return rslt.toString();
    }

    public static double intToReal(int x) {
        return x;
    }

    public static String intToStr(int x) {
        return Integer.toString(x);
    }

    public static double ln(double x, Expression expr) throws CifEvalException {
        if (x <= 0.0) {
            String msg = CifMath.fmt("Invalid operation: ln(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return Math.log(x);
    }

    public static double log(double x, Expression expr) throws CifEvalException {
        if (x <= 0.0) {
            String msg = CifMath.fmt("Invalid operation: log(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return Math.log10(x);
    }

    public static int max(int x, int y) {
        return Math.max(x, y);
    }

    public static double max(double x, double y) {
        return Math.max(x, y);
    }

    public static int min(int x, int y) {
        return Math.min(x, y);
    }

    public static double min(double x, double y) {
        return Math.min(x, y);
    }

    public static int mod(int x, int y, Expression expr) throws CifEvalException {
        if (y == 0) {
            String msg = CifMath.fmt("Division by zero: %d mod %d.", x, y);
            throw new CifEvalException(msg, expr);
        }
        return x % y;
    }

    public static int multiply(int x, int y, Expression expr) throws CifEvalException {
        long rslt = (long)x * (long)y;
        if (Integer.MIN_VALUE <= rslt && rslt <= Integer.MAX_VALUE) {
            return (int)rslt;
        }
        String msg = CifMath.fmt("Integer overflow: %d * %d.", x, y);
        throw new CifEvalException(msg, expr);
    }

    public static double multiply(double x, double y, Expression expr) throws CifEvalException {
        double rslt = x * y;
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: %s * %s.", x, y);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static int negate(int x, Expression expr) throws CifEvalException {
        if (x == Integer.MIN_VALUE) {
            String msg = CifMath.fmt("Integer overflow: -%d.", x);
            throw new CifEvalException(msg, expr);
        }
        return -x;
    }

    public static double negate(double x) {
        return x == 0.0 ? 0.0 : -x;
    }

    public static CifTuple pop(List<Object> lst, Expression expr) throws CifEvalException {
        if (lst.isEmpty()) {
            String msg = "Invalid operation: pop([]).";
            throw new CifEvalException(msg, expr);
        }
        List<Object> lst2 = CifMath.slice(lst, (Integer)1, null);
        CifTuple rslt = new CifTuple();
        rslt.add(lst.get(0));
        rslt.add(lst2);
        return rslt;
    }

    public static int pow(int x, int y, Expression expr) throws CifEvalException {
        Assert.check((y >= 0 ? 1 : 0) != 0);
        double rslt = Math.pow(x, y);
        if (-2.147483648E9 <= rslt && rslt <= 2.147483647E9) {
            return (int)rslt;
        }
        String msg = CifMath.fmt("Integer overflow: pow(%d, %d).", x, y);
        throw new CifEvalException(msg, expr);
    }

    public static double pow(double x, double y, Expression expr) throws CifEvalException {
        double rslt = Math.pow(x, y);
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: pow(%s, %s).", x, y);
            throw new CifEvalException(msg, expr);
        }
        if (Double.isNaN(rslt)) {
            String msg = CifMath.fmt("Invalid operation: pow(%s, %s).", x, y);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static String realToStr(double x) {
        Assert.check((!Double.isNaN(x) ? 1 : 0) != 0);
        Assert.check((!Double.isInfinite(x) ? 1 : 0) != 0);
        return Double.toString(x).replace('E', 'e');
    }

    public static Object project(List<Object> lst, int origIdx, Expression expr) throws CifEvalException {
        int idx = origIdx;
        if (idx < 0) {
            idx = lst.size() + idx;
        }
        if (idx < 0 || idx >= lst.size()) {
            String msg = CifMath.fmt("Index out of bounds: %s[%s].", CifEvalUtils.objToStr(lst), origIdx);
            throw new CifEvalException(msg, expr);
        }
        return lst.get(idx);
    }

    public static Object project(Map<Object, Object> dict, Object key, Expression expr) throws CifEvalException {
        Object rslt = dict.get(key);
        if (rslt == null) {
            String msg = CifMath.fmt("Key not found: %s[%s].", CifEvalUtils.objToStr(dict), key);
            throw new CifEvalException(msg, expr);
        }
        return rslt;
    }

    public static String project(String str, int origIdx, Expression expr) throws CifEvalException {
        int idx = origIdx;
        if (idx < 0) {
            idx = str.length() + idx;
        }
        if (idx < 0 || idx >= str.length()) {
            String msg = CifMath.fmt("Index out of bounds: \"%s\"[%s].", Strings.escape((String)str), origIdx);
            throw new CifEvalException(msg, expr);
        }
        return str.substring(idx, idx + 1);
    }

    public static Object project(CifTuple tuple, int idx, Expression expr) throws CifEvalException {
        if (idx < 0 || idx >= tuple.size()) {
            String msg = CifMath.fmt("Index out of bounds: %s[%s].", CifEvalUtils.objToStr(tuple), idx);
            throw new CifEvalException(msg, expr);
        }
        return tuple.get(idx);
    }

    public static int round(double x, Expression expr) throws CifEvalException {
        if (x < -2.1474836485E9 || x >= 2.1474836475E9) {
            String msg = CifMath.fmt("Integer overflow: round(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        long rslt = Math.round(x);
        return (int)rslt;
    }

    public static double scale(double v, double inmin, double inmax, double outmin, double outmax, Expression expr) throws CifEvalException {
        double inrange = CifMath.subtract(inmax, inmin, expr);
        if (inrange == 0.0) {
            String msg = CifMath.fmt("Empty input interval: scale(%s, %s, %s, %s, %s).", CifMath.realToStr(v), CifMath.realToStr(inmin), CifMath.realToStr(inmax), CifMath.realToStr(outmin), CifMath.realToStr(outmax));
            throw new CifEvalException(msg, expr);
        }
        double fraction = CifMath.divide(CifMath.subtract(v, inmin, expr), inrange, expr);
        return CifMath.add(outmin, CifMath.multiply(fraction, CifMath.subtract(outmax, outmin, expr), expr), expr);
    }

    public static int sign(int x) {
        return x == 0 ? 0 : (x < 0 ? -1 : 1);
    }

    public static int sign(double x) {
        return x == 0.0 ? 0 : (x < 0.0 ? -1 : 1);
    }

    public static double sin(double x, Expression expr) throws CifEvalException {
        double rslt = Math.sin(x);
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: sin(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        if (Double.isNaN(rslt)) {
            String msg = CifMath.fmt("Invalid operation: sin(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double sinh(double x, Expression expr) throws CifEvalException {
        double rslt = Math.sinh(x);
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: sinh(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        if (Double.isNaN(rslt)) {
            String msg = CifMath.fmt("Invalid operation: sinh(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static List<Object> slice(List<Object> lst, Integer beginIndex, Integer endIndex) {
        return Lists.slice(lst, (Integer)beginIndex, (Integer)endIndex);
    }

    public static String slice(String str, Integer beginIndex, Integer endIndex) {
        return Strings.slice((String)str, (Integer)beginIndex, (Integer)endIndex);
    }

    public static double sqrt(double x, Expression expr) throws CifEvalException {
        if (x < 0.0) {
            String msg = CifMath.fmt("Invalid operation: sqrt(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return Math.sqrt(x);
    }

    public static boolean strToBool(String x, Expression expr) throws CifEvalException {
        if (x.equals("true")) {
            return true;
        }
        if (x.equals("false")) {
            return false;
        }
        String msg = CifMath.fmt("Cast from type \"string\" to type \"bool\" failed: the string value does not represent a boolean value: \"%s\".", Strings.escape((String)x));
        throw new CifEvalException(msg, expr);
    }

    public static int strToInt(String x, Expression expr) throws CifEvalException {
        try {
            return Integer.parseInt(x);
        }
        catch (NumberFormatException e) {
            String msg = CifMath.fmt("Cast from type \"string\" to type \"int\" failed: the string value does not represent an integer value, or the integer value resulted in integer overflow: \"%s\".", Strings.escape((String)x));
            throw new CifEvalException(msg, expr);
        }
    }

    public static double strToReal(String x, Expression expr) throws CifEvalException {
        double rslt;
        try {
            rslt = Double.parseDouble(x);
            if (Double.isNaN(rslt)) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            String msg = CifMath.fmt("Cast from type \"string\" to type \"real\" failed: the string value does not represent a real value: \"%s\".", Strings.escape((String)x));
            throw new CifEvalException(msg, expr);
        }
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Cast from type \"string\" to type \"real\" failed, due to real overflow: \"%s\".", Strings.escape((String)x));
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static int subtract(int x, int y, Expression expr) throws CifEvalException {
        long rslt = (long)x - (long)y;
        if (Integer.MIN_VALUE <= rslt && rslt <= Integer.MAX_VALUE) {
            return (int)rslt;
        }
        String msg = CifMath.fmt("Integer overflow: %d - %d.", x, y);
        throw new CifEvalException(msg, expr);
    }

    public static double subtract(double x, double y, Expression expr) throws CifEvalException {
        double rslt = x - y;
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: %s - %s.", x, y);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double tan(double x, Expression expr) throws CifEvalException {
        double rslt = Math.tan(x);
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: tan(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        if (Double.isNaN(rslt)) {
            String msg = CifMath.fmt("Invalid operation: tan(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }

    public static double tanh(double x, Expression expr) throws CifEvalException {
        double rslt = Math.tanh(x);
        if (Double.isInfinite(rslt)) {
            String msg = CifMath.fmt("Real overflow: tanh(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        if (Double.isNaN(rslt)) {
            String msg = CifMath.fmt("Invalid operation: tanh(%s).", x);
            throw new CifEvalException(msg, expr);
        }
        return rslt == -0.0 ? 0.0 : rslt;
    }
}

