/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.mgmt.internal;

import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public final class BundleUtil {
    public static String[] getBundleExportedPackages(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List providedWires = wiring.getProvidedWires("osgi.wiring.package");
        ArrayList<String> packages = new ArrayList<String>();
        for (BundleWire wire : providedWires) {
            String packageName = String.format("%s;%s", wire.getCapability().getAttributes().get("osgi.wiring.package"), wire.getCapability().getAttributes().get("version"));
            if (packages.contains(packageName)) continue;
            packages.add(packageName);
        }
        return packages.toArray(new String[packages.size()]);
    }

    public static String[] getBundleImportedPackages(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List providedWires = wiring.getRequiredWires("osgi.wiring.package");
        ArrayList<String> packages = new ArrayList<String>();
        for (BundleWire wire : providedWires) {
            String packageName = String.format("%s;%s", wire.getCapability().getAttributes().get("osgi.wiring.package"), wire.getCapability().getAttributes().get("version"));
            if (packages.contains(packageName)) continue;
            packages.add(packageName);
        }
        return packages.toArray(new String[packages.size()]);
    }

    public static String getBundleState(Bundle b) {
        switch (b.getState()) {
            case 32: {
                return "ACTIVE";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 1: {
                return "UNINSTALLED";
            }
        }
        return "UNKNOWN";
    }

    public static boolean isBundleFragment(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        return (wiring.getRevision().getTypes() & 1) != 0;
    }

    public static int getBundleStartLevel(Bundle bundle) {
        BundleStartLevel startLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
        return startLevel.getStartLevel();
    }

    public static boolean isBundlePersistentlyStarted(Bundle bundle) {
        BundleStartLevel startLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
        return startLevel.isPersistentlyStarted();
    }

    public static boolean isBundleActivationPolicyUsed(Bundle bundle) {
        BundleStartLevel startLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
        return startLevel.isActivationPolicyUsed();
    }

    public static boolean isRequired(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        return wiring.getProvidedWires("osgi.wiring.bundle").size() > 0;
    }

    public static boolean isRemovalPending(Bundle bundle) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        return !wiring.isCurrent() && wiring.isInUse();
    }
}

