/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.WorkflowInterruptedException;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandExecutionContextImpl;
import org.eclipse.xpand2.XpandFacade;
import org.eclipse.xpand2.output.FileHandle;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xpand2.output.Output;
import org.eclipse.xpand2.output.OutputImpl;
import org.eclipse.xpand2.output.PostProcessor;
import org.eclipse.xpand2.output.VetoStrategy;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.type.impl.java.JavaBeansMetaModel;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GeneratedMetamodel;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.XtextStandaloneSetup;
import org.eclipse.xtext.generator.Binding;
import org.eclipse.xtext.generator.CompositeGeneratorException;
import org.eclipse.xtext.generator.GeneratorWarning;
import org.eclipse.xtext.generator.IClassAnnotation;
import org.eclipse.xtext.generator.LanguageConfig;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.NewlineNormalizer;
import org.eclipse.xtext.util.MergeableManifest2;
import org.eclipse.xtext.util.Strings;

@Deprecated
public class Generator
extends AbstractWorkflowComponent2 {
    private static final Logger LOG = Logger.getLogger(Generator.class);
    public static final String SRC_GEN_TEST = "SRC_GEN_TEST";
    public static final String SRC_TEST = "SRC_TEST";
    public static final String PLUGIN_TEST = "PLUGIN_TEST";
    public static final String SRC_GEN_UI = "SRC_GEN_UI";
    public static final String SRC_UI = "SRC_UI";
    public static final String PLUGIN_UI = "PLUGIN_UI";
    public static final String SRC_GEN_IDE = "SRC_GEN_IDE";
    public static final String SRC_IDE = "SRC_IDE";
    public static final String PLUGIN_IDE = "PLUGIN_IDE";
    public static final String SRC = "SRC";
    public static final String SRC_GEN = "SRC_GEN";
    public static final String MODEL = "MODEL";
    public static final String PLUGIN_RT = "PLUGIN";
    private static final String FILE_HEADER_VAR_TIME = "${time}";
    private static final String FILE_HEADER_VAR_DATE = "${date}";
    private static final String FILE_HEADER_VAR_YEAR = "${year}";
    private static final String FILE_HEADER_VAR_USER = "${user}";
    private static final String FILE_HEADER_VAR_VERSION = "${version}";
    private Naming naming = new Naming();
    private String encoding;
    private String pathRtProject = ".";
    private String pathIdeProject = null;
    private String pathUiProject = null;
    private String pathTestProject = null;
    private String srcPath = "/src";
    private String srcGenPath = "/src-gen";
    private String fileHeader = "/*\n * generated by Xtext\n */";
    private final List<PostProcessor> postProcessors = Lists.newArrayList();
    private final List<IClassAnnotation> classAnnotations = Lists.newArrayList();
    private final List<LanguageConfig> languageConfigs = new ArrayList<LanguageConfig>();
    private boolean mergeManifest = true;
    private String activator;
    private String projectNameRt;
    private String projectNameUi;
    private String projectNameIde;

    public void setNaming(Naming naming) {
        this.naming = naming;
    }

    public Generator() {
        new XtextStandaloneSetup().createInjectorAndDoEMFRegistration();
    }

    protected void checkConfigurationInternal(Issues issues) {
        this.naming.setProjectNameRt(this.getProjectNameRt());
        this.naming.setProjectNameIde(this.getProjectNameIde());
        this.naming.setIdeBasePackage(!this.isIde() && this.isUi() ? this.getProjectNameUi() : this.getProjectNameIde());
        this.naming.setProjectNameUi(this.getProjectNameUi());
        this.naming.setUiBasePackage(this.getProjectNameUi());
        this.naming.setActivatorName(this.getActivator());
        this.naming.setPathTestProject(this.getPathTestProject());
        this.naming.setFileHeader(this.getFileHeader());
        this.naming.setClassAnnotations(this.getClassAnnotationsAsString());
        this.naming.setAnnotationImports(this.getAnnotationImportsAsString());
        this.naming.setHasUI(this.isUi());
        this.naming.setHasIde(this.isIde());
        HashMap<String, Grammar> uris = new HashMap<String, Grammar>();
        for (LanguageConfig config : this.languageConfigs) {
            config.registerNaming(this.naming);
            config.checkConfiguration(issues);
            Grammar grammar = config.getGrammar();
            List select = EcoreUtil2.typeSelect((List)grammar.getMetamodelDeclarations(), GeneratedMetamodel.class);
            for (GeneratedMetamodel generatedMetamodel : select) {
                String nsURI = generatedMetamodel.getEPackage().getNsURI();
                if (uris.containsKey(nsURI)) {
                    issues.addError("Duplicate generated grammar with nsURI '" + nsURI + "' in " + ((Grammar)uris.get(nsURI)).getName() + " and " + grammar.getName());
                    continue;
                }
                uris.put(nsURI, grammar);
            }
        }
        if (this.getProjectNameRt() == null) {
            issues.addError("The property 'projectNameRt' is mandatory");
        }
        if (this.isUiMergedIntoRt() && this.getPathIdeProject() != null && !this.isIdeMergedIntoRt()) {
            issues.addError("Cannot have a dedicated ide project when ui project is merged into runtime project");
        }
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        new XtextStandaloneSetup().createInjectorAndDoEMFRegistration();
        try {
            XpandExecutionContext exeCtx = this.createExecutionContext();
            for (LanguageConfig config : this.languageConfigs) {
                this.generate(config, exeCtx, issues);
                this.addToStandaloneSetup(config, exeCtx);
                this.generateGuiceModuleRt(config, exeCtx);
                if (!this.isUi()) continue;
                this.generateGuiceModuleUi(config, exeCtx);
                this.generateExecutableExtensionsFactory(config, exeCtx);
            }
            this.generatePluginXmlRt(this.languageConfigs, exeCtx);
            this.generateManifestRt(this.languageConfigs, exeCtx);
            if (this.isUi()) {
                this.generatePluginXmlUi(this.languageConfigs, exeCtx);
                this.generateManifestUi(this.languageConfigs, exeCtx);
                this.generateActivator(this.languageConfigs, exeCtx);
            }
            if (this.isIde()) {
                this.generateManifestIde(this.languageConfigs, exeCtx);
            }
            if (this.isTest()) {
                this.generateManifestTests(this.languageConfigs, exeCtx);
            }
        }
        catch (WorkflowInterruptedException e) {
            throw e;
        }
        catch (CompositeGeneratorException e) {
            this.handleCompositeException(issues, e);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void handleCompositeException(Issues issues, CompositeGeneratorException e) {
        for (Exception ex : e.getExceptions()) {
            if (ex instanceof CompositeGeneratorException) {
                this.handleCompositeException(issues, (CompositeGeneratorException)ex);
                continue;
            }
            if (ex instanceof GeneratorWarning) continue;
            issues.addError((WorkflowComponent)this, "GeneratorException: ", null, (Throwable)ex, null);
        }
    }

    private boolean handleWarnings(Issues issues, CompositeGeneratorException e) {
        for (Exception ex : e.getExceptions()) {
            if (ex instanceof CompositeGeneratorException) {
                if (this.handleWarnings(issues, (CompositeGeneratorException)ex)) continue;
                return false;
            }
            if (ex instanceof GeneratorWarning) {
                issues.addWarning((WorkflowComponent)this, "Warning: " + ex.getMessage(), null, null, null);
                continue;
            }
            return false;
        }
        return true;
    }

    public void addPostProcessor(PostProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
    }

    public List<PostProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public String getPathRtProject() {
        return this.pathRtProject;
    }

    public void setPathRtProject(String pathRtProject) {
        this.pathRtProject = pathRtProject;
    }

    public String getPathIdeProject() {
        return this.pathIdeProject;
    }

    public void setPathIdeProject(String pathIdeProject) {
        this.pathIdeProject = pathIdeProject;
    }

    public String getPathUiProject() {
        return this.pathUiProject;
    }

    public void setPathUiProject(String pathUiProject) {
        this.pathUiProject = pathUiProject;
    }

    public String getPathTestProject() {
        return this.pathTestProject;
    }

    public void setPathTestProject(String pathTestProject) {
        this.pathTestProject = pathTestProject;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public String getSrcGenPath() {
        return this.srcGenPath;
    }

    public void setSrcGenPath(String srcGenPath) {
        this.srcGenPath = srcGenPath;
    }

    public String getFileHeader() {
        String result = this.fileHeader;
        if (result != null) {
            String version;
            String user;
            SimpleDateFormat dateFormat;
            if (result.contains(FILE_HEADER_VAR_TIME)) {
                dateFormat = new SimpleDateFormat("HH:mm:ss");
                String time = dateFormat.format(new Date());
                result = result.replace(FILE_HEADER_VAR_TIME, time);
            }
            if (result.contains(FILE_HEADER_VAR_DATE)) {
                dateFormat = new SimpleDateFormat("MMM d, yyyy");
                String date = dateFormat.format(new Date());
                result = result.replace(FILE_HEADER_VAR_DATE, date);
            }
            if (result.contains(FILE_HEADER_VAR_YEAR)) {
                dateFormat = new SimpleDateFormat("yyyy");
                String year = dateFormat.format(new Date());
                result = result.replace(FILE_HEADER_VAR_YEAR, year);
            }
            if (result.contains(FILE_HEADER_VAR_USER) && (user = System.getProperty("user.name")) != null) {
                result = result.replace(FILE_HEADER_VAR_USER, user);
            }
            if (result.contains(FILE_HEADER_VAR_VERSION) && (version = this.getVersion()) != null) {
                result = result.replace(FILE_HEADER_VAR_VERSION, version);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersion() {
        InputStream is = null;
        try {
            URL url = new URL(Plugin.INSTANCE.getBaseURL() + "META-INF/MANIFEST.MF");
            is = url.openStream();
            Manifest manifest = new Manifest(is);
            String string = manifest.getMainAttributes().getValue("Bundle-Version");
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setFileHeader(String fileHeader) {
        this.fileHeader = fileHeader;
    }

    private XpandExecutionContext createExecutionContext() {
        OutputImpl output = new OutputImpl();
        output.addOutlet(this.createOutlet(false, this.getEncoding(), PLUGIN_RT, false, this.getPathRtProject()));
        output.addOutlet(this.createOutlet(false, this.getEncoding(), SRC, false, this.getPathRtProject() + this.getSrcPath()));
        output.addOutlet(this.createOutlet(false, this.getEncoding(), SRC_GEN, true, this.getPathRtProject() + this.getSrcGenPath()));
        output.addOutlet(this.createOutlet(false, this.getEncoding(), MODEL, false, this.getPathRtProject() + "/model"));
        if (this.getPathUiProject() != null) {
            output.addOutlet(this.createOutlet(false, this.getEncoding(), PLUGIN_UI, false, this.getPathUiProject()));
            output.addOutlet(this.createOutlet(false, this.getEncoding(), SRC_UI, false, this.getPathUiProject() + this.getSrcPath()));
            output.addOutlet(this.createOutlet(false, this.getEncoding(), SRC_GEN_UI, true, this.getPathUiProject() + this.getSrcGenPath()));
        } else {
            output.addOutlet(this.createOutlet(false, this.getEncoding(), PLUGIN_UI, false, this.getPathRtProject()));
            output.addOutlet(this.createOutlet(false, this.getEncoding(), SRC_UI, false, this.getPathRtProject() + this.getSrcPath()));
            output.addOutlet(this.createOutlet(false, this.getEncoding(), SRC_GEN_UI, true, this.getPathRtProject() + this.getSrcGenPath()));
        }
        if (this.getPathIdeProject() != null) {
            output.addOutlet(this.createOutlet(false, this.getEncoding(), PLUGIN_IDE, false, this.getPathIdeProject()));
            output.addOutlet(this.createOutlet(false, this.getEncoding(), SRC_IDE, false, this.getPathIdeProject() + this.getSrcPath()));
            output.addOutlet(this.createOutlet(false, this.getEncoding(), SRC_GEN_IDE, true, this.getPathIdeProject() + this.getSrcGenPath()));
        } else if (this.getPathUiProject() != null) {
            output.addOutlet(this.createOutlet(false, this.getEncoding(), PLUGIN_IDE, false, this.getPathUiProject()));
            output.addOutlet(this.createOutlet(false, this.getEncoding(), SRC_IDE, false, this.getPathUiProject() + this.getSrcPath()));
            output.addOutlet(this.createOutlet(false, this.getEncoding(), SRC_GEN_IDE, true, this.getPathUiProject() + this.getSrcGenPath()));
        } else {
            output.addOutlet(this.createOutlet(false, this.getEncoding(), PLUGIN_IDE, false, this.getPathRtProject()));
            output.addOutlet(this.createOutlet(false, this.getEncoding(), SRC_IDE, false, this.getPathRtProject() + this.getSrcPath()));
            output.addOutlet(this.createOutlet(false, this.getEncoding(), SRC_GEN_IDE, true, this.getPathRtProject() + this.getSrcGenPath()));
        }
        if (!Strings.isEmpty((String)this.getPathTestProject())) {
            output.addOutlet(this.createOutlet(false, this.getEncoding(), PLUGIN_TEST, false, this.getPathTestProject()));
            output.addOutlet(this.createOutlet(false, this.getEncoding(), SRC_TEST, false, this.getPathTestProject() + this.getSrcPath()));
            output.addOutlet(this.createOutlet(false, this.getEncoding(), SRC_GEN_TEST, true, this.getPathTestProject() + this.getSrcGenPath()));
        } else {
            output.addOutlet(this.createOutlet(false, this.getEncoding(), PLUGIN_TEST, false, this.getPathRtProject()));
            output.addOutlet(this.createOutlet(false, this.getEncoding(), SRC_TEST, false, this.getPathRtProject() + this.getSrcPath()));
            output.addOutlet(this.createOutlet(false, this.getEncoding(), SRC_GEN_TEST, true, this.getPathRtProject() + this.getSrcGenPath()));
        }
        HashMap globalVars = Maps.newHashMap();
        globalVars.put("__Naming__", new Variable("__Naming__", (Object)this.naming));
        XpandExecutionContextImpl execCtx = new XpandExecutionContextImpl((Output)output, null, (Map)globalVars, null, null);
        execCtx.getResourceManager().setFileEncoding("ISO-8859-1");
        execCtx.registerMetaModel((MetaModel)new JavaBeansMetaModel());
        execCtx = (XpandExecutionContextImpl)execCtx.cloneWithVariable(new Variable("modelPluginID", (Object)this.getProjectNameRt()));
        return execCtx;
    }

    protected Outlet createOutlet(boolean append, String encoding, String name, boolean overwrite, String path) {
        Outlet outlet = new Outlet(append, encoding, name, overwrite, path);
        outlet.addPostprocessor((PostProcessor)new NewlineNormalizer(this.getLineDelimiter()));
        for (PostProcessor pp : this.getPostProcessors()) {
            outlet.addPostprocessor(pp);
        }
        return outlet;
    }

    private String getEncoding() {
        return this.encoding != null ? this.encoding : System.getProperty("file.encoding");
    }

    public void addLanguage(LanguageConfig langConfig) {
        langConfig.initialize(this.isUi());
        this.languageConfigs.add(langConfig);
    }

    public void addClassAnnotation(IClassAnnotation annotation) {
        this.classAnnotations.add(annotation);
    }

    private String getClassAnnotationsAsString() {
        if (this.classAnnotations.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IClassAnnotation annotation : this.classAnnotations) {
            stringBuilder.append(annotation.toString()).append(Strings.newLine());
        }
        return stringBuilder.toString();
    }

    private String getAnnotationImportsAsString() {
        if (this.classAnnotations.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IClassAnnotation annotation : this.classAnnotations) {
            String importString = annotation.getAnnotationImport();
            if (Strings.isEmpty((String)importString)) continue;
            stringBuilder.append("import ").append(importString).append(';').append(Strings.newLine());
        }
        return stringBuilder.toString();
    }

    private List<Grammar> getGrammars(List<LanguageConfig> configs) {
        ArrayList<Grammar> grammars = new ArrayList<Grammar>();
        for (LanguageConfig conf : configs) {
            grammars.add(conf.getGrammar());
        }
        return grammars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePluginXmlRt(List<LanguageConfig> configs, XpandExecutionContext ctx) {
        String filePath = this.fileExists(ctx, "plugin.xml", PLUGIN_RT) ? "plugin.xml_gen" : "plugin.xml";
        this.deleteFile(ctx, filePath, PLUGIN_RT);
        ctx.getOutput().openFile(filePath, PLUGIN_RT);
        ctx.getOutput().getOutlet(PLUGIN_RT).addVetoStrategy((VetoStrategy)new EmptyPluginXmlVeto());
        try {
            XpandFacade facade = XpandFacade.create((XpandExecutionContext)ctx);
            List<Grammar> grammars = this.getGrammars(configs);
            facade.evaluate("org::eclipse::xtext::generator::Plugin::pre", grammars, new Object[0]);
            for (LanguageConfig conf : this.languageConfigs) {
                conf.addToPluginXmlRt(conf, ctx);
                if (!this.isUiMergedIntoRt()) continue;
                conf.addToPluginXmlUi(conf, ctx);
            }
            facade.evaluate("org::eclipse::xtext::generator::Plugin::post", grammars, new Object[0]);
        }
        finally {
            ctx.getOutput().closeFile();
        }
    }

    private void generateExecutableExtensionsFactory(LanguageConfig config, XpandExecutionContext exeCtx) {
        XpandFacade facade = XpandFacade.create((XpandExecutionContext)exeCtx);
        facade.evaluate("org::eclipse::xtext::generator::ExecutableExtensionFactory::file", (Object)config.getGrammar(), new Object[]{this.getActivator()});
    }

    private void generateActivator(List<LanguageConfig> configs, XpandExecutionContext exeCtx) {
        XpandFacade facade = XpandFacade.create((XpandExecutionContext)exeCtx);
        facade.evaluate("org::eclipse::xtext::generator::Activator::file", this.getGrammars(configs), new Object[]{this.getActivator()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePluginXmlUi(List<LanguageConfig> configs, XpandExecutionContext ctx) {
        if (this.isUi() && !this.isUiMergedIntoRt()) {
            String filePath = this.fileExists(ctx, "plugin.xml", PLUGIN_UI) ? "plugin.xml_gen" : "plugin.xml";
            this.deleteFile(ctx, filePath, PLUGIN_UI);
            ctx.getOutput().openFile(filePath, PLUGIN_UI);
            try {
                XpandFacade facade = XpandFacade.create((XpandExecutionContext)ctx);
                List<Grammar> grammars = this.getGrammars(configs);
                facade.evaluate("org::eclipse::xtext::generator::Plugin::pre", grammars, new Object[0]);
                for (LanguageConfig conf : this.languageConfigs) {
                    conf.addToPluginXmlUi(conf, ctx);
                }
                facade.evaluate("org::eclipse::xtext::generator::Plugin::post", grammars, new Object[0]);
            }
            finally {
                ctx.getOutput().closeFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToStandaloneSetup(LanguageConfig config, XpandExecutionContext ctx) {
        ctx.getOutput().openFile(this.naming.asPath(this.naming.setupImpl(config.getGrammar())) + ".java", SRC_GEN);
        try {
            XpandFacade facade = XpandFacade.create((XpandExecutionContext)ctx);
            facade.evaluate("org::eclipse::xtext::generator::StandaloneSetup::pre", (Object)config.getGrammar(), new Object[]{config.getFileExtensions(config.getGrammar())});
            config.addToStandaloneSetup(config, ctx);
            facade.evaluate("org::eclipse::xtext::generator::StandaloneSetup::post", (Object)config.getGrammar(), new Object[0]);
        }
        finally {
            ctx.getOutput().closeFile();
        }
    }

    private void generateGuiceModuleRt(LanguageConfig config, XpandExecutionContext ctx) {
        XpandFacade facade = XpandFacade.create((XpandExecutionContext)ctx);
        Set<Binding> bindings = config.getGuiceBindingsRt(config.getGrammar());
        String superClassName = config.getDefaultRuntimeModuleClassName(config.getGrammar());
        if (superClassName == null) {
            superClassName = "org.eclipse.xtext.service.DefaultRuntimeModule";
        }
        facade.evaluate("org::eclipse::xtext::generator::GuiceModuleRt::generate", (Object)config.getGrammar(), new Object[]{superClassName, bindings, config.getFileExtensions(config.getGrammar())});
    }

    private void generateGuiceModuleUi(LanguageConfig config, XpandExecutionContext ctx) {
        if (this.isUi()) {
            XpandFacade facade = XpandFacade.create((XpandExecutionContext)ctx);
            Set<Binding> bindings = config.getGuiceBindingsUi(config.getGrammar());
            String superClassName = config.getDefaultUiModuleClassName(config.getGrammar());
            if (superClassName == null) {
                superClassName = "org.eclipse.xtext.ui.DefaultUiModule";
            }
            facade.evaluate("org::eclipse::xtext::generator::GuiceModuleUi::generate", (Object)config.getGrammar(), new Object[]{superClassName, bindings});
        }
    }

    private boolean isUi() {
        return this.getPathUiProject() != null;
    }

    private boolean isIde() {
        return this.getPathIdeProject() != null;
    }

    private boolean isTest() {
        return this.getPathTestProject() != null;
    }

    private void generate(LanguageConfig config, XpandExecutionContext ctx, Issues issues) {
        block2: {
            try {
                config.generate(config, ctx);
            }
            catch (CompositeGeneratorException e) {
                if (this.handleWarnings(issues, e)) break block2;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateManifestRt(List<LanguageConfig> configs, XpandExecutionContext ctx) {
        String manifestPath = "META-INF/MANIFEST.MF";
        LinkedHashSet<String> exported = new LinkedHashSet<String>();
        LinkedHashSet<String> requiredBundles = new LinkedHashSet<String>();
        LinkedHashSet<String> imported = new LinkedHashSet<String>();
        String activator = null;
        if (this.isUiMergedIntoRt()) {
            activator = this.getActivator();
        }
        for (LanguageConfig config : configs) {
            exported.addAll(Arrays.asList(config.getExportedPackagesRt(config.getGrammar())));
            requiredBundles.addAll(Arrays.asList(config.getRequiredBundlesRt(config.getGrammar())));
            imported.addAll(Arrays.asList(config.getImportedPackagesRt(config.getGrammar())));
            if (this.isUiMergedIntoRt()) {
                exported.addAll(Arrays.asList(config.getExportedPackagesUi(config.getGrammar())));
                imported.addAll(Arrays.asList(config.getImportedPackagesUi(config.getGrammar())));
                requiredBundles.addAll(Arrays.asList(config.getRequiredBundlesUi(config.getGrammar())));
            }
            if (!this.isIdeMergedIntoRt()) continue;
            exported.addAll(Arrays.asList(config.getExportedPackagesIde(config.getGrammar())));
            imported.addAll(Arrays.asList(config.getImportedPackagesIde(config.getGrammar())));
            requiredBundles.addAll(Arrays.asList(config.getRequiredBundlesIde(config.getGrammar())));
        }
        if (this.isMergeManifest()) {
            String path = ctx.getOutput().getOutlet(PLUGIN_RT).getPath() + "/" + manifestPath;
            this.mergeManifest(this.getProjectNameRt(), path, exported, requiredBundles, imported, activator);
        } else {
            manifestPath = manifestPath + "_gen";
            this.deleteFile(ctx, manifestPath, PLUGIN_RT);
            ctx.getOutput().openFile(manifestPath, PLUGIN_RT);
            try {
                XpandFacade facade = XpandFacade.create((XpandExecutionContext)ctx);
                this.generateManifest(facade, this.getProjectNameRt(), this.getProjectNameRt(), this.getBundleVersion(), exported, requiredBundles, imported, activator);
            }
            finally {
                ctx.getOutput().closeFile();
            }
        }
    }

    private void mergeManifest(String projectName, String path, Set<String> exported, Set<String> requiredBundles, Set<String> imported, String activator) {
        File file = new File(path);
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(file);
            MergeableManifest2 manifest = new MergeableManifest2((InputStream)in, projectName);
            manifest.addExportedPackages(exported);
            manifest.addRequiredBundles(requiredBundles);
            manifest.addImportedPackages(imported);
            if (activator != null && !manifest.getMainAttributes().containsKey((Object)"Bundle-Activator")) {
                manifest.getMainAttributes().put("Bundle-Activator", activator);
            }
            if (manifest.isModified()) {
                out = new FileOutputStream(file);
                manifest.write(out);
                out.close();
            }
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
    }

    public void setMergeManifest(boolean mergeManifest) {
        this.mergeManifest = mergeManifest;
    }

    private boolean isMergeManifest() {
        return this.mergeManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateManifestUi(List<LanguageConfig> configs, XpandExecutionContext ctx) {
        if (this.isUi() && !this.isUiMergedIntoRt()) {
            String manifestPath = "META-INF/MANIFEST.MF";
            LinkedHashSet<String> exported = new LinkedHashSet<String>();
            LinkedHashSet<String> imported = new LinkedHashSet<String>();
            LinkedHashSet<String> requiredBundles = new LinkedHashSet<String>();
            for (LanguageConfig config : this.languageConfigs) {
                exported.addAll(Arrays.asList(config.getExportedPackagesUi(config.getGrammar())));
                imported.addAll(Arrays.asList(config.getImportedPackagesUi(config.getGrammar())));
                requiredBundles.addAll(Arrays.asList(config.getRequiredBundlesUi(config.getGrammar())));
                if (this.isIde()) continue;
                exported.addAll(Arrays.asList(config.getExportedPackagesIde(config.getGrammar())));
                imported.addAll(Arrays.asList(config.getImportedPackagesIde(config.getGrammar())));
                requiredBundles.addAll(Arrays.asList(config.getRequiredBundlesIde(config.getGrammar())));
            }
            if (this.isMergeManifest()) {
                String path = ctx.getOutput().getOutlet(PLUGIN_UI).getPath() + "/" + manifestPath;
                this.mergeManifest(this.getProjectNameUi(), path, exported, requiredBundles, imported, this.getActivator());
            } else {
                manifestPath = manifestPath + "_gen";
                this.deleteFile(ctx, manifestPath, PLUGIN_UI);
                ctx.getOutput().openFile(manifestPath, PLUGIN_UI);
                try {
                    XpandFacade facade = XpandFacade.create((XpandExecutionContext)ctx);
                    this.generateManifest(facade, this.getProjectNameUi(), this.getProjectNameUi(), this.getBundleVersion(), exported, requiredBundles, imported, this.getActivator());
                }
                finally {
                    ctx.getOutput().closeFile();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateManifestIde(List<LanguageConfig> configs, XpandExecutionContext ctx) {
        if (this.isIde() && !this.isIdeMergedIntoRt()) {
            String manifestPath = "META-INF/MANIFEST.MF";
            LinkedHashSet<String> exported = new LinkedHashSet<String>();
            LinkedHashSet<String> imported = new LinkedHashSet<String>();
            LinkedHashSet<String> requiredBundles = new LinkedHashSet<String>();
            for (LanguageConfig config : this.languageConfigs) {
                exported.addAll(Arrays.asList(config.getExportedPackagesIde(config.getGrammar())));
                imported.addAll(Arrays.asList(config.getImportedPackagesIde(config.getGrammar())));
                requiredBundles.addAll(Arrays.asList(config.getRequiredBundlesIde(config.getGrammar())));
            }
            if (this.isMergeManifest()) {
                String path = ctx.getOutput().getOutlet(PLUGIN_IDE).getPath() + "/" + manifestPath;
                this.mergeManifest(this.getProjectNameIde(), path, exported, requiredBundles, imported, null);
            } else {
                manifestPath = manifestPath + "_gen";
                this.deleteFile(ctx, manifestPath, PLUGIN_IDE);
                ctx.getOutput().openFile(manifestPath, PLUGIN_IDE);
                try {
                    XpandFacade facade = XpandFacade.create((XpandExecutionContext)ctx);
                    this.generateManifest(facade, this.getProjectNameIde(), this.getProjectNameIde(), this.getBundleVersion(), exported, requiredBundles, imported, null);
                }
                finally {
                    ctx.getOutput().closeFile();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateManifestTests(List<LanguageConfig> configs, XpandExecutionContext ctx) {
        if (this.isTest()) {
            String manifestPath = "META-INF/MANIFEST.MF";
            LinkedHashSet<String> exported = new LinkedHashSet<String>();
            LinkedHashSet<String> imported = new LinkedHashSet<String>();
            LinkedHashSet<String> requiredBundles = new LinkedHashSet<String>();
            for (LanguageConfig config : this.languageConfigs) {
                exported.addAll(Arrays.asList(config.getExportedPackagesTests(config.getGrammar())));
                imported.addAll(Arrays.asList(config.getImportedPackagesTests(config.getGrammar())));
                requiredBundles.addAll(Arrays.asList(config.getRequiredBundlesTests(config.getGrammar())));
            }
            if (this.isMergeManifest()) {
                String path = ctx.getOutput().getOutlet(PLUGIN_TEST).getPath() + "/" + manifestPath;
                this.mergeManifest(this.getProjectNameTests(), path, exported, requiredBundles, imported, null);
            } else {
                manifestPath = manifestPath + "_gen";
                this.deleteFile(ctx, manifestPath, PLUGIN_TEST);
                ctx.getOutput().openFile(manifestPath, PLUGIN_TEST);
                try {
                    XpandFacade facade = XpandFacade.create((XpandExecutionContext)ctx);
                    this.generateManifest(facade, this.getProjectNameTests(), this.getProjectNameTests(), this.getBundleVersion(), exported, requiredBundles, imported, this.getActivator());
                }
                finally {
                    ctx.getOutput().closeFile();
                }
            }
        }
    }

    private void deleteFile(XpandExecutionContext ctx, String filePath, String outlet) {
        String pathname = ctx.getOutput().getOutlet(outlet).getPath() + "/" + filePath;
        File file = new File(pathname);
        if (file.exists() && !file.delete()) {
            throw new IllegalStateException("couldn't delete file '" + pathname);
        }
    }

    private boolean fileExists(XpandExecutionContext ctx, String filePath, String outlet) {
        String pathname = ctx.getOutput().getOutlet(outlet).getPath() + "/" + filePath;
        File file = new File(pathname);
        return file.exists();
    }

    private boolean isUiMergedIntoRt() {
        return this.getPathRtProject().equals(this.getPathUiProject());
    }

    private boolean isIdeMergedIntoRt() {
        return this.getPathRtProject().equals(this.getPathIdeProject());
    }

    private String getBundleVersion() {
        return "0.0.1";
    }

    public void setProjectNameRt(String projectNameRt) {
        this.projectNameRt = projectNameRt;
    }

    private String getProjectNameRt() {
        return this.projectNameRt;
    }

    public void setProjectNameUi(String projectNameUi) {
        this.projectNameUi = projectNameUi;
    }

    private String getProjectNameUi() {
        if (this.projectNameUi == null) {
            return this.getProjectNameRt() + ".ui";
        }
        return this.projectNameUi;
    }

    public void setProjectNameIde(String projectNameIde) {
        this.projectNameIde = projectNameIde;
    }

    private String getProjectNameIde() {
        if (this.projectNameIde == null) {
            return this.getProjectNameRt() + ".ide";
        }
        return this.projectNameIde;
    }

    private String getProjectNameTests() {
        if (this.pathTestProject != null) {
            return this.pathTestProject.substring(this.pathTestProject.lastIndexOf(47) + 1);
        }
        return this.getProjectNameRt() + ".tests";
    }

    private void generateManifest(XpandFacade facade, String name, String symbolicName, String version, Set<String> exported, Set<String> requiredBundles, Set<String> imported, String activator) {
        facade.evaluate("org::eclipse::xtext::generator::Manifest::file", (Object)name, new Object[]{symbolicName, version, exported, requiredBundles, imported, activator});
    }

    public void setActivator(String activator) {
        this.activator = activator;
    }

    private String getActivator() {
        if (this.activator == null) {
            Grammar grammar = this.languageConfigs.get(0).getGrammar();
            return this.naming.basePackageUi(grammar) + ".internal." + GrammarUtil.getSimpleName((Grammar)grammar) + "Activator";
        }
        return this.activator;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.naming.setLineDelimiter(lineDelimiter);
    }

    public String getLineDelimiter() {
        return this.naming.getLineDelimiter();
    }

    private static class Plugin
    extends EMFPlugin {
        public static final Plugin INSTANCE = new Plugin();

        private Plugin() {
            super(new ResourceLocator[0]);
        }

        public ResourceLocator getPluginResourceLocator() {
            return null;
        }
    }

    private static final class EmptyPluginXmlVeto
    implements VetoStrategy {
        static Pattern PLUGIN_ELEMENT = Pattern.compile("<plugin>(.*?)</plugin>", 32);

        private EmptyPluginXmlVeto() {
        }

        public boolean hasVeto(FileHandle handle) {
            Matcher matcher = PLUGIN_ELEMENT.matcher(handle.getBuffer());
            return matcher.find() && Strings.isEmpty((String)matcher.group(1).trim());
        }
    }
}

