/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PivotTables;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.ReferringElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ValueSpecification;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.NavigationCallExpImpl;
import org.eclipse.ocl.pivot.internal.manager.TemplateSpecialisation;
import org.eclipse.ocl.pivot.library.classifier.OclTypeConformsToOperation;
import org.eclipse.ocl.pivot.library.oclany.OclComparableLessThanEqualOperation;
import org.eclipse.ocl.pivot.library.string.CGStringGetSeverityOperation;
import org.eclipse.ocl.pivot.library.string.CGStringLogDiagnosticOperation;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.OCLValue;

public class PropertyCallExpImpl
extends NavigationCallExpImpl
implements PropertyCallExp {
    public static final int PROPERTY_CALL_EXP_FEATURE_COUNT = 16;
    public static final int PROPERTY_CALL_EXP_OPERATION_COUNT = 16;
    protected Property referredProperty;

    protected PropertyCallExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.PROPERTY_CALL_EXP;
    }

    @Override
    public Property getReferredProperty() {
        if (this.referredProperty != null && this.referredProperty.eIsProxy()) {
            InternalEObject oldReferredProperty = (InternalEObject)this.referredProperty;
            this.referredProperty = (Property)this.eResolveProxy(oldReferredProperty);
            if (this.referredProperty != oldReferredProperty && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 15, (Object)oldReferredProperty, (Object)this.referredProperty));
            }
        }
        return this.referredProperty;
    }

    public Property basicGetReferredProperty() {
        return this.referredProperty;
    }

    @Override
    public void setReferredProperty(Property newReferredProperty) {
        Property oldReferredProperty = this.referredProperty;
        this.referredProperty = newReferredProperty;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldReferredProperty, (Object)this.referredProperty));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAnnotatingComments();
            }
            case 1: {
                return this.getOwnedAnnotations();
            }
            case 2: {
                return this.getOwnedComments();
            }
            case 3: {
                return this.getOwnedExtensions();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.isIsMany();
            }
            case 6: {
                return this.isIsRequired();
            }
            case 7: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 8: {
                return this.getTypeValue();
            }
            case 9: {
                return this.isIsImplicit();
            }
            case 10: {
                return this.isIsSafe();
            }
            case 11: {
                return this.getOwnedSource();
            }
            case 12: {
                return this.isIsPre();
            }
            case 13: {
                if (resolve) {
                    return this.getNavigationSource();
                }
                return this.basicGetNavigationSource();
            }
            case 14: {
                return this.getQualifiers();
            }
            case 15: {
                if (resolve) {
                    return this.getReferredProperty();
                }
                return this.basicGetReferredProperty();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                this.getAnnotatingComments().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                this.getOwnedAnnotations().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                this.getOwnedComments().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                this.getOwnedExtensions().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setName((String)newValue);
                return;
            }
            case 6: {
                this.setIsRequired((Boolean)newValue);
                return;
            }
            case 7: {
                this.setType((Type)newValue);
                return;
            }
            case 8: {
                this.setTypeValue((Type)newValue);
                return;
            }
            case 9: {
                this.setIsImplicit((Boolean)newValue);
                return;
            }
            case 10: {
                this.setIsSafe((Boolean)newValue);
                return;
            }
            case 11: {
                this.setOwnedSource((OCLExpression)newValue);
                return;
            }
            case 12: {
                this.setIsPre((Boolean)newValue);
                return;
            }
            case 13: {
                this.setNavigationSource((Property)newValue);
                return;
            }
            case 14: {
                this.getQualifiers().clear();
                this.getQualifiers().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.setReferredProperty((Property)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                return;
            }
            case 4: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setIsRequired(true);
                return;
            }
            case 7: {
                this.setType(null);
                return;
            }
            case 8: {
                this.setTypeValue(null);
                return;
            }
            case 9: {
                this.setIsImplicit(false);
                return;
            }
            case 10: {
                this.setIsSafe(false);
                return;
            }
            case 11: {
                this.setOwnedSource(null);
                return;
            }
            case 12: {
                this.setIsPre(false);
                return;
            }
            case 13: {
                this.setNavigationSource(null);
                return;
            }
            case 14: {
                this.getQualifiers().clear();
                return;
            }
            case 15: {
                this.setReferredProperty(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.annotatingComments != null && !this.annotatingComments.isEmpty();
            }
            case 1: {
                return this.ownedAnnotations != null && !this.ownedAnnotations.isEmpty();
            }
            case 2: {
                return this.ownedComments != null && !this.ownedComments.isEmpty();
            }
            case 3: {
                return this.ownedExtensions != null && !this.ownedExtensions.isEmpty();
            }
            case 4: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 5: {
                return this.isIsMany();
            }
            case 6: {
                return (this.eFlags & 0x100) == 0;
            }
            case 7: {
                return this.type != null;
            }
            case 8: {
                return this.typeValue != null;
            }
            case 9: {
                return (this.eFlags & 0x200) != 0;
            }
            case 10: {
                return (this.eFlags & 0x400) != 0;
            }
            case 11: {
                return this.ownedSource != null;
            }
            case 12: {
                return (this.eFlags & 0x800) != 0;
            }
            case 13: {
                return this.navigationSource != null;
            }
            case 14: {
                return this.qualifiers != null && !this.qualifiers.isEmpty();
            }
            case 15: {
                return this.referredProperty != null;
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    public int eDerivedOperationID(int baseOperationID, java.lang.Class<?> baseClass) {
        if (baseClass == CallExp.class) {
            switch (baseOperationID) {
                case 6: {
                    return 14;
                }
            }
            return super.eDerivedOperationID(baseOperationID, baseClass);
        }
        if (baseClass == ReferringElement.class) {
            switch (baseOperationID) {
                case 0: {
                    return 9;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.CompatibleBody((ValueSpecification)arguments.get(0));
            }
            case 3: {
                return this.isNonNull();
            }
            case 4: {
                return this.isNull();
            }
            case 5: {
                return this.validateTypeIsNotNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 14: {
                return this.validateSafeSourceCanBeNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 7: {
                return this.validateSafeSourceCannotBeMap((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 8: {
                return this.validateTypeIsNotInvalid((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 9: {
                return this.getReferredElement();
            }
            case 10: {
                return this.getSpecializedReferredPropertyOwningType();
            }
            case 11: {
                return this.getSpecializedReferredPropertyType();
            }
            case 12: {
                return this.validateCompatibleResultType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 13: {
                return this.validateNonStaticSourceTypeIsConformant((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 15: {
                return this.validateUnsafeSourceCanNotBeNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitPropertyCallExp(this);
    }

    @Override
    public Element getReferredElement() {
        return this.getReferredProperty();
    }

    @Override
    public Type getSpecializedReferredPropertyOwningType() {
        Executor executor;
        Property referredProperty = this.getReferredProperty();
        Class referencedType = referredProperty.getOwningClass();
        if (TemplateSpecialisation.needsSpecialisation(referencedType)) {
            executor = PivotUtil.getExecutor(this);
            TemplateSpecialisation templateSpecialization = new TemplateSpecialisation(executor.getCompleteEnvironment());
            Type resultType = this.getType();
            templateSpecialization.installEquivalence(resultType, referredProperty.getType());
            if (referencedType != null) {
                return templateSpecialization.getSpecialisation(referencedType);
            }
        }
        if (referencedType != null) {
            return referencedType;
        }
        executor = PivotUtil.getExecutor(this);
        return executor.getCompleteEnvironment().getOwnedStandardLibrary().getOclInvalidType();
    }

    @Override
    public Type getSpecializedReferredPropertyType() {
        Executor executor;
        Type referencedType;
        Property referredProperty = this.getReferredProperty();
        Type specializedType = referencedType = referredProperty.getType();
        if (referencedType != null && TemplateSpecialisation.needsSpecialisation(referencedType)) {
            executor = PivotUtil.getExecutor(this);
            TemplateSpecialisation templateSpecialization = new TemplateSpecialisation(executor.getCompleteEnvironment());
            Type resultType = this.getType();
            templateSpecialization.installEquivalence(resultType, referredProperty.getType());
            specializedType = templateSpecialization.getSpecialisation(referencedType);
        }
        if (specializedType != null) {
            return specializedType;
        }
        executor = PivotUtil.getExecutor(this);
        return executor.getCompleteEnvironment().getOwnedStandardLibrary().getOclInvalidType();
    }

    @Override
    public boolean validateNonStaticSourceTypeIsConformant(DiagnosticChain diagnostics, Map<Object, Object> context) {
        @NonNull String constraintName = "PropertyCallExp::NonStaticSourceTypeIsConformant";
        try {
            boolean symbol_0;
            @NonNull Executor executor = PivotUtil.getExecutor(this, context);
            @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)PivotPackage.Literals.PROPERTY_CALL_EXP___VALIDATE_NON_STATIC_SOURCE_TYPE_IS_CONFORMANT__DIAGNOSTICCHAIN_MAP);
            boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
            if (le) {
                symbol_0 = true;
            } else {
                boolean logDiagnostic;
                Serializable CAUGHT_result;
                try {
                    Boolean result;
                    Serializable CAUGHT_not;
                    try {
                        InvalidValueException CAUGHT_safe_isStatic_source;
                        try {
                            Boolean safe_isStatic_source;
                            @Nullable Property referredProperty = this.getReferredProperty();
                            @NonNull Boolean isStatic = referredProperty == null;
                            if (isStatic == Boolean.TRUE) {
                                safe_isStatic_source = null;
                            } else {
                                assert (referredProperty != null);
                                boolean isStatic_0 = referredProperty.isIsStatic();
                                safe_isStatic_source = isStatic_0;
                            }
                            CAUGHT_safe_isStatic_source = safe_isStatic_source;
                        }
                        catch (Exception e) {
                            CAUGHT_safe_isStatic_source = ValueUtil.createInvalidValue(e);
                        }
                        if (CAUGHT_safe_isStatic_source instanceof InvalidValueException) {
                            throw CAUGHT_safe_isStatic_source;
                        }
                        @Nullable Boolean not = CAUGHT_safe_isStatic_source == ValueUtil.FALSE_VALUE ? ValueUtil.TRUE_VALUE : (CAUGHT_safe_isStatic_source == ValueUtil.TRUE_VALUE ? ValueUtil.FALSE_VALUE : null);
                        CAUGHT_not = not;
                    }
                    catch (Exception e) {
                        CAUGHT_not = ValueUtil.createInvalidValue(e);
                    }
                    if (CAUGHT_not == ValueUtil.FALSE_VALUE) {
                        result = ValueUtil.TRUE_VALUE;
                    } else {
                        InvalidValueException CAUGHT_safe_conformsTo_source;
                        try {
                            Boolean safe_conformsTo_source;
                            OCLValue CAUGHT_safe_type_source;
                            Type safe_type_source;
                            @Nullable OCLExpression ownedSource = this.getOwnedSource();
                            @NonNull Boolean type = ownedSource == null;
                            if (type == Boolean.TRUE) {
                                safe_type_source = null;
                            } else {
                                Type type_0;
                                assert (ownedSource != null);
                                safe_type_source = type_0 = ownedSource.getType();
                            }
                            try {
                                CAUGHT_safe_type_source = safe_type_source;
                            }
                            catch (Exception e) {
                                CAUGHT_safe_type_source = ValueUtil.createInvalidValue(e);
                            }
                            @NonNull Boolean conformsTo = CAUGHT_safe_type_source == null;
                            if (conformsTo == Boolean.TRUE) {
                                safe_conformsTo_source = null;
                            } else {
                                if (safe_type_source == null) {
                                    throw new InvalidValueException("Null ''Type'' rather than ''OclVoid'' value required", new Object[0]);
                                }
                                @NonNull Type getSpecializedReferredPropertyOwningType = this.getSpecializedReferredPropertyOwningType();
                                boolean conformsTo_0 = OclTypeConformsToOperation.INSTANCE.evaluate(executor, (Object)safe_type_source, (Object)getSpecializedReferredPropertyOwningType);
                                safe_conformsTo_source = conformsTo_0;
                            }
                            CAUGHT_safe_conformsTo_source = safe_conformsTo_source;
                        }
                        catch (Exception e) {
                            CAUGHT_safe_conformsTo_source = ValueUtil.createInvalidValue(e);
                        }
                        if (CAUGHT_safe_conformsTo_source == ValueUtil.TRUE_VALUE) {
                            result = ValueUtil.TRUE_VALUE;
                        } else {
                            if (CAUGHT_not instanceof InvalidValueException) {
                                throw CAUGHT_not;
                            }
                            if (CAUGHT_safe_conformsTo_source instanceof InvalidValueException) {
                                throw CAUGHT_safe_conformsTo_source;
                            }
                            result = CAUGHT_not == null || CAUGHT_safe_conformsTo_source == null ? null : ValueUtil.FALSE_VALUE;
                        }
                    }
                    CAUGHT_result = result;
                }
                catch (Exception e) {
                    CAUGHT_result = ValueUtil.createInvalidValue(e);
                }
                symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "PropertyCallExp::NonStaticSourceTypeIsConformant", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
            }
            return symbol_0;
        }
        catch (Throwable e) {
            return ValueUtil.validationFailedDiagnostic("PropertyCallExp::NonStaticSourceTypeIsConformant", this, diagnostics, context, e);
        }
    }

    @Override
    public boolean validateSafeSourceCanBeNull(DiagnosticChain diagnostics, Map<Object, Object> context) {
        @NonNull String constraintName = "PropertyCallExp::SafeSourceCanBeNull";
        try {
            boolean symbol_0;
            @NonNull Executor executor = PivotUtil.getExecutor(this, context);
            @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)PivotPackage.Literals.PROPERTY_CALL_EXP___VALIDATE_SAFE_SOURCE_CAN_BE_NULL__DIAGNOSTICCHAIN_MAP);
            boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
            if (le) {
                symbol_0 = true;
            } else {
                boolean logDiagnostic;
                Serializable CAUGHT_result;
                try {
                    Boolean result;
                    boolean isSafe;
                    boolean ne;
                    @Nullable OCLExpression ownedSource = this.getOwnedSource();
                    boolean bl = ne = ownedSource != null;
                    @Nullable Boolean and = !ne ? ValueUtil.FALSE_VALUE : (!(isSafe = this.isIsSafe()) ? ValueUtil.FALSE_VALUE : ValueUtil.TRUE_VALUE);
                    if (and == ValueUtil.FALSE_VALUE) {
                        result = ValueUtil.TRUE_VALUE;
                    } else {
                        Serializable CAUGHT_not;
                        try {
                            Serializable CAUGHT_isNonNull;
                            try {
                                if (ownedSource == null) {
                                    throw new InvalidValueException("Null source for 'pivot::OCLExpression::isNonNull() : Boolean[1]'", new Object[0]);
                                }
                                boolean isNonNull = ownedSource.isNonNull();
                                CAUGHT_isNonNull = Boolean.valueOf(isNonNull);
                            }
                            catch (Exception e) {
                                CAUGHT_isNonNull = ValueUtil.createInvalidValue(e);
                            }
                            if (CAUGHT_isNonNull instanceof InvalidValueException) {
                                throw CAUGHT_isNonNull;
                            }
                            @Nullable Boolean not = CAUGHT_isNonNull == ValueUtil.FALSE_VALUE ? ValueUtil.TRUE_VALUE : (CAUGHT_isNonNull == ValueUtil.TRUE_VALUE ? ValueUtil.FALSE_VALUE : null);
                            CAUGHT_not = not;
                        }
                        catch (Exception e) {
                            CAUGHT_not = ValueUtil.createInvalidValue(e);
                        }
                        if (CAUGHT_not == ValueUtil.TRUE_VALUE) {
                            result = ValueUtil.TRUE_VALUE;
                        } else {
                            if (CAUGHT_not instanceof InvalidValueException) {
                                throw CAUGHT_not;
                            }
                            result = and == null || CAUGHT_not == null ? null : ValueUtil.FALSE_VALUE;
                        }
                    }
                    CAUGHT_result = result;
                }
                catch (Exception e) {
                    CAUGHT_result = ValueUtil.createInvalidValue(e);
                }
                symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "PropertyCallExp::SafeSourceCanBeNull", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
            }
            return symbol_0;
        }
        catch (Throwable e) {
            return ValueUtil.validationFailedDiagnostic("PropertyCallExp::SafeSourceCanBeNull", this, diagnostics, context, e);
        }
    }

    @Override
    public boolean validateUnsafeSourceCanNotBeNull(DiagnosticChain diagnostics, Map<Object, Object> context) {
        @NonNull String constraintName = "PropertyCallExp::UnsafeSourceCanNotBeNull";
        try {
            boolean symbol_0;
            @NonNull Executor executor = PivotUtil.getExecutor(this, context);
            @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)PivotPackage.Literals.PROPERTY_CALL_EXP___VALIDATE_UNSAFE_SOURCE_CAN_NOT_BE_NULL__DIAGNOSTICCHAIN_MAP);
            boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
            if (le) {
                symbol_0 = true;
            } else {
                boolean logDiagnostic;
                Serializable CAUGHT_result;
                try {
                    Boolean result;
                    Serializable CAUGHT_and;
                    try {
                        Object and;
                        boolean ne;
                        @Nullable OCLExpression ownedSource = this.getOwnedSource();
                        boolean bl = ne = ownedSource != null;
                        if (!ne) {
                            and = ValueUtil.FALSE_VALUE;
                        } else {
                            boolean isSafe = this.isIsSafe();
                            @Nullable Boolean not = !isSafe ? ValueUtil.TRUE_VALUE : (isSafe ? ValueUtil.FALSE_VALUE : null);
                            and = not == ValueUtil.FALSE_VALUE ? ValueUtil.FALSE_VALUE : (not == null ? null : ValueUtil.TRUE_VALUE);
                        }
                        CAUGHT_and = and;
                    }
                    catch (Exception e) {
                        CAUGHT_and = ValueUtil.createInvalidValue(e);
                    }
                    if (CAUGHT_and == ValueUtil.FALSE_VALUE) {
                        result = ValueUtil.TRUE_VALUE;
                    } else {
                        Serializable CAUGHT_isNonNull;
                        try {
                            @Nullable OCLExpression ownedSource_0 = this.getOwnedSource();
                            if (ownedSource_0 == null) {
                                throw new InvalidValueException("Null source for 'pivot::OCLExpression::isNonNull() : Boolean[1]'", new Object[0]);
                            }
                            boolean isNonNull = ownedSource_0.isNonNull();
                            CAUGHT_isNonNull = Boolean.valueOf(isNonNull);
                        }
                        catch (Exception e) {
                            CAUGHT_isNonNull = ValueUtil.createInvalidValue(e);
                        }
                        if (CAUGHT_isNonNull == ValueUtil.TRUE_VALUE) {
                            result = ValueUtil.TRUE_VALUE;
                        } else {
                            if (CAUGHT_and instanceof InvalidValueException) {
                                throw CAUGHT_and;
                            }
                            if (CAUGHT_isNonNull instanceof InvalidValueException) {
                                throw CAUGHT_isNonNull;
                            }
                            result = CAUGHT_and == null ? null : ValueUtil.FALSE_VALUE;
                        }
                    }
                    CAUGHT_result = result;
                }
                catch (Exception e) {
                    CAUGHT_result = ValueUtil.createInvalidValue(e);
                }
                symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "PropertyCallExp::UnsafeSourceCanNotBeNull", this, null, diagnostics, context, null, severity_0, CAUGHT_result, PivotTables.INT_0).booleanValue();
            }
            return symbol_0;
        }
        catch (Throwable e) {
            return ValueUtil.validationFailedDiagnostic("PropertyCallExp::UnsafeSourceCanNotBeNull", this, diagnostics, context, e);
        }
    }

    @Override
    public boolean validateCompatibleResultType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        @NonNull String constraintName = "PropertyCallExp::CompatibleResultType";
        try {
            boolean symbol_0;
            @NonNull Executor executor = PivotUtil.getExecutor(this, context);
            @NonNull IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(executor, (Object)PivotPackage.Literals.PROPERTY_CALL_EXP___VALIDATE_COMPATIBLE_RESULT_TYPE__DIAGNOSTICCHAIN_MAP);
            boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(executor, (Object)severity_0, (Object)PivotTables.INT_0);
            if (le) {
                symbol_0 = true;
            } else {
                boolean logDiagnostic;
                @Nullable Type type = this.getType();
                @NonNull Type getSpecializedReferredPropertyType = this.getSpecializedReferredPropertyType();
                boolean result = type != null ? type.getTypeId() == getSpecializedReferredPropertyType.getTypeId() : false;
                symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(executor, TypeId.BOOLEAN, "PropertyCallExp::CompatibleResultType", this, null, diagnostics, context, null, severity_0, result, PivotTables.INT_0).booleanValue();
            }
            return symbol_0;
        }
        catch (Throwable e) {
            return ValueUtil.validationFailedDiagnostic("PropertyCallExp::CompatibleResultType", this, diagnostics, context, e);
        }
    }
}

