/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.dsl.debug.ide.ui.provider;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gemoc.dsl.debug.ide.DSLBreakpoint;
import org.eclipse.gemoc.dsl.debug.ide.ui.DebugIdeUiPlugin;
import org.eclipse.gemoc.dsl.debug.ide.ui.provider.OverlayImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DSLLabelDecorator
extends BaseLabelProvider
implements ILabelDecorator,
IBreakpointListener {
    protected final Map<ImageDescriptor, Image> imagesCache = new HashMap<ImageDescriptor, Image>();
    private final Image breakpointEnabled = new Image((Device)Display.getDefault(), ExtendedImageRegistry.getInstance().getImageDescriptor(DebugIdeUiPlugin.INSTANCE.getImage("full/deco16/breakpoint_enabled")).getImageData());
    private final Image breakpointDisabled = new Image((Device)Display.getDefault(), ExtendedImageRegistry.getInstance().getImageDescriptor(DebugIdeUiPlugin.INSTANCE.getImage("full/deco16/breakpoint_disabled")).getImageData());
    private final Map<URI, Set<DSLBreakpoint>> breakpoints = new HashMap<URI, Set<DSLBreakpoint>>();
    private ResourceSet resourceSet;
    private final String identifier;

    public DSLLabelDecorator(String identifier) {
        this(null, identifier);
    }

    public DSLLabelDecorator(ResourceSet resourceSet, String identifier) {
        this.resourceSet = resourceSet;
        this.identifier = identifier;
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
        int n = iBreakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof DSLBreakpoint) {
                this.addBreakpoint((DSLBreakpoint)breakpoint);
            }
            ++n2;
        }
    }

    protected String getModelIdentifier() {
        return this.identifier;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (breakpoint instanceof DSLBreakpoint && breakpoint.getModelIdentifier().equals(this.getModelIdentifier())) {
            this.addBreakpoint((DSLBreakpoint)breakpoint);
            this.fireLabelProviderChanged(breakpoint);
        }
    }

    protected void fireLabelProviderChanged(IBreakpoint breakpoint) {
        Object instruction;
        if (this.resourceSet != null && (instruction = this.getElement(this.resourceSet, (DSLBreakpoint)breakpoint)) != null) {
            final LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, instruction);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DSLLabelDecorator.this.fireLabelProviderChanged(event);
                }
            });
        }
    }

    protected Object getElement(ResourceSet rs, DSLBreakpoint breakpoint) {
        return rs.getEObject(breakpoint.getURI(), false);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (breakpoint instanceof DSLBreakpoint && breakpoint.getModelIdentifier().equals(this.getModelIdentifier())) {
            this.removeBreakpoint((DSLBreakpoint)breakpoint);
            this.fireLabelProviderChanged(breakpoint);
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        try {
            if (breakpoint instanceof DSLBreakpoint && breakpoint.getModelIdentifier().equals(this.getModelIdentifier()) && delta.getAttribute("org.eclipse.debug.core.enabled") != null && breakpoint.isEnabled() != ((Boolean)delta.getAttribute("org.eclipse.debug.core.enabled")).booleanValue()) {
                this.fireLabelProviderChanged(breakpoint);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public Image decorateImage(Image image, Object element) {
        Image res;
        if (element instanceof EObject) {
            Iterator<DSLBreakpoint> it;
            Set<DSLBreakpoint> brkps = this.breakpoints.get(EcoreUtil.getURI((EObject)((EObject)element)));
            DSLBreakpoint breakpoint = brkps != null ? ((it = brkps.iterator()).hasNext() ? it.next() : null) : null;
            if (breakpoint != null) {
                try {
                    OverlayImageDescriptor descriptor = breakpoint.isEnabled() ? new OverlayImageDescriptor(image, this.breakpointEnabled) : new OverlayImageDescriptor(image, this.breakpointDisabled);
                    Image cachedImage = this.imagesCache.get((Object)descriptor);
                    if (cachedImage == null) {
                        cachedImage = descriptor.createImage();
                        this.imagesCache.put((ImageDescriptor)descriptor, cachedImage);
                    }
                    res = cachedImage;
                }
                catch (CoreException e) {
                    res = image;
                    DebugIdeUiPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.gemoc.dsl.debug.ide.ui", e.getLocalizedMessage(), (Throwable)e));
                }
            } else {
                res = image;
            }
        } else {
            res = image;
        }
        return res;
    }

    public String decorateText(String text, Object element) {
        Set<DSLBreakpoint> brkps;
        String res = element instanceof EObject ? ((brkps = this.breakpoints.get(EcoreUtil.getURI((EObject)((EObject)element)))) != null && brkps.size() != 0 ? String.valueOf(text) + " (breakpoint)" : text) : text;
        return res;
    }

    protected void addBreakpoint(DSLBreakpoint breakpoint) {
        Set<DSLBreakpoint> brkps = this.breakpoints.get(breakpoint.getURI());
        if (brkps == null) {
            brkps = new HashSet<DSLBreakpoint>();
            this.breakpoints.put(breakpoint.getURI(), brkps);
        }
        brkps.add(breakpoint);
    }

    protected void removeBreakpoint(DSLBreakpoint breakpoint) {
        Set<DSLBreakpoint> brkps = this.breakpoints.get(breakpoint.getURI());
        if (brkps != null) {
            brkps.remove(breakpoint);
        }
    }

    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        this.breakpointEnabled.dispose();
        this.breakpointDisabled.dispose();
        for (Image cachedImage : this.imagesCache.values()) {
            cachedImage.dispose();
        }
        super.dispose();
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }
}

