/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ui.contentassist;

import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecoretools.ale.Block;
import org.eclipse.emf.ecoretools.ale.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.VarRef;
import org.eclipse.emf.ecoretools.ale.core.env.IBehaviors;
import org.eclipse.emf.ecoretools.ale.implementation.BehavioredClass;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ui.contentassist.AleTemplateProposal;
import org.eclipse.emf.ecoretools.ui.contentassist.TypeUtils;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNodeWithSemanticElement;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ITemplateAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.templates.ContextTypeIdHelper;
import org.eclipse.xtext.ui.editor.templates.DefaultTemplateProposalProvider;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContext;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class AleTemplateProposalProvider
extends DefaultTemplateProposalProvider {
    private final PrefixMatcher matchesCandidatesContainingTypedText = new PrefixMatcher(){

        public boolean isCandidateMatchingPrefix(String name, String prefix) {
            String cleanName = name.toLowerCase();
            String cleanPrefix = prefix.toLowerCase();
            boolean _isEmpty = cleanPrefix.isEmpty();
            if (_isEmpty) {
                return true;
            }
            boolean _startsWith = cleanName.startsWith(cleanPrefix);
            if (_startsWith) {
                return true;
            }
            boolean _contains = cleanName.contains(cleanPrefix);
            return _contains;
        }
    };

    @Inject
    public AleTemplateProposalProvider(TemplateStore templateStore, ContextTypeRegistry registry, ContextTypeIdHelper helper) {
        super(templateStore, registry, helper);
    }

    public void createTemplates(TemplateContext templateContext, ContentAssistContext context, ITemplateAcceptor acceptor) {
        if (templateContext instanceof XtextTemplateContext) {
            String prefix = this.getOffsetPrefix(context).trim();
            EObject element = context.getCurrentModel();
            if (element instanceof VarRef) {
                String _xifexpression = null;
                boolean _contains = prefix.contains(".");
                if (_contains) {
                    int _indexOf = prefix.indexOf(".");
                    int _plus = _indexOf + 1;
                    _xifexpression = prefix.substring(_plus);
                } else {
                    _xifexpression = prefix;
                }
                String typed = _xifexpression;
                IBehaviors semantics = TypeUtils.getSemantics(element);
                EObject elementType = TypeUtils.findType((VarRef)element, semantics);
                if (elementType instanceof BehavioredClass) {
                    this.createProposalsForBehavioredClass(acceptor, (BehavioredClass)elementType, element, semantics, typed, templateContext, context);
                } else if (elementType instanceof ETypedElement) {
                    this.createProposalsForETypedElement(acceptor, (ETypedElement)elementType, element, semantics, typed, templateContext, context);
                }
            }
        }
    }

    private void createProposalsForBehavioredClass(ITemplateAcceptor acceptor, BehavioredClass clazz, EObject syntax, IBehaviors semantics, String typed, TemplateContext templateContext, ContentAssistContext context) {
        HashSet proposedOperations = CollectionLiterals.newHashSet();
        Functions.Function1 _function = method -> this.matchesCandidatesContainingTypedText.isCandidateMatchingPrefix(method.getOperationRef().getName(), typed);
        Consumer<Method> _function_1 = method -> this.createProposalFor(acceptor, method.getOperationRef(), templateContext, context, proposedOperations);
        IterableExtensions.filter((Iterable)clazz.getMethods(), (Functions.Function1)_function).forEach(_function_1);
        if (clazz instanceof ExtendedClass) {
            ExtendedClass extendedClassInEcore = (ExtendedClass)clazz;
            Functions.Function1 _function_2 = ext -> {
                String _name = extendedClassInEcore.getName();
                String _name_1 = ext.getBaseClass().getName();
                return Objects.equal((Object)_name, (Object)_name_1);
            };
            org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass extendedClassInAleScript = (org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass)IterableExtensions.findFirst((Iterable)semantics.getOpenClasses(), (Functions.Function1)_function_2);
            Functions.Function1 _function_3 = operation -> this.matchesCandidatesContainingTypedText.isCandidateMatchingPrefix(operation.getName(), typed);
            Consumer<EOperation> _function_4 = operation -> this.createProposalFor(acceptor, (EOperation)operation, templateContext, context, proposedOperations);
            IterableExtensions.filter((Iterable)extendedClassInAleScript.getBaseClass().getEOperations(), (Functions.Function1)_function_3).forEach(_function_4);
        }
    }

    private void createProposalsForETypedElement(ITemplateAcceptor acceptor, ETypedElement clazz, EObject syntax, IBehaviors semantics, String typed, TemplateContext templateContext, ContentAssistContext context) {
        if (!clazz.isMany() && clazz.getEType() instanceof EClass) {
            EClassifier _eType = clazz.getEType();
            this.createProposalsForEClass(acceptor, (EClass)_eType, syntax, semantics, typed, templateContext, context);
        }
    }

    private void createProposalsForEClass(ITemplateAcceptor acceptor, EClass clazz, EObject syntax, IBehaviors semantics, String typed, TemplateContext templateContext, ContentAssistContext context) {
        HashSet proposedOperations = CollectionLiterals.newHashSet();
        Functions.Function1 _function = operation -> this.matchesCandidatesContainingTypedText.isCandidateMatchingPrefix(operation.getName(), typed);
        Consumer<EOperation> _function_1 = operation -> this.createProposalFor(acceptor, (EOperation)operation, templateContext, context, proposedOperations);
        IterableExtensions.filter((Iterable)clazz.getEOperations(), (Functions.Function1)_function).forEach(_function_1);
        if (clazz instanceof ExtendedClass) {
            ExtendedClass extendedClassInEcore = (ExtendedClass)clazz;
            Functions.Function1 _function_2 = ext -> {
                String _name = extendedClassInEcore.getName();
                String _name_1 = ext.getBaseClass().getName();
                return Objects.equal((Object)_name, (Object)_name_1);
            };
            org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass extendedClassInAleScript = (org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass)IterableExtensions.findFirst((Iterable)semantics.getOpenClasses(), (Functions.Function1)_function_2);
            Functions.Function1 _function_3 = operation -> this.matchesCandidatesContainingTypedText.isCandidateMatchingPrefix(operation.getName(), typed);
            Consumer<EOperation> _function_4 = operation -> this.createProposalFor(acceptor, (EOperation)operation, templateContext, context, proposedOperations);
            IterableExtensions.filter((Iterable)extendedClassInAleScript.getBaseClass().getEOperations(), (Functions.Function1)_function_3).forEach(_function_4);
        }
    }

    private String createProposalFor(ITemplateAcceptor acceptor, EOperation operation, TemplateContext templateContext, ContentAssistContext context, Set<String> proposedOperations) {
        String _name = operation.getName();
        String _plus = String.valueOf(_name) + "(";
        Functions.Function1 _function = param -> {
            String _name_1 = param.getEType().getName();
            String _plus_1 = String.valueOf(_name_1) + " ";
            String _name_2 = param.getName();
            return String.valueOf(_plus_1) + _name_2;
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)operation.getEParameters(), (Functions.Function1)_function), (CharSequence)", ");
        String _plus_1 = String.valueOf(_plus) + _join;
        String _plus_2 = String.valueOf(_plus_1) + ") : ";
        String _asString = TypeUtils.asString(operation.getEType());
        String templateName = String.valueOf(_plus_2) + _asString;
        String _name_1 = operation.getName();
        String _plus_3 = String.valueOf(_name_1) + "(";
        Functions.Function1 _function_1 = param -> {
            String _name_2 = param.getName();
            String _plus_4 = "${" + _name_2;
            return String.valueOf(_plus_4) + "}";
        };
        String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map((List)operation.getEParameters(), (Functions.Function1)_function_1), (CharSequence)", ");
        String _plus_4 = String.valueOf(_plus_3) + _join_1;
        String templatePattern = String.valueOf(_plus_4) + ")";
        Template template = new Template(templateName, "", templateName, templatePattern, false);
        TemplateProposal proposal = this.doCreateProposal(template, templateContext, context, this.getImage(template), this.getRelevance(template));
        Region _replaceRegion = context.getReplaceRegion();
        Image _image = proposal.getImage();
        int _relevance = proposal.getRelevance();
        AleTemplateProposal fProposal = new AleTemplateProposal(this.matchesCandidatesContainingTypedText, template, templateContext, (IRegion)_replaceRegion, _image, _relevance);
        acceptor.accept((TemplateProposal)fProposal);
        return templateName;
    }

    private CompositeNode getBlockNode(INode node) {
        String debugDump = NodeModelUtils.compactDump((INode)node.getRootNode(), (boolean)true);
        INode current = node;
        while (!Objects.equal((Object)current, null)) {
            EObject _semanticElement;
            if (current instanceof CompositeNodeWithSemanticElement && (_semanticElement = ((CompositeNodeWithSemanticElement)current).getSemanticElement()) instanceof Block) {
                return (CompositeNode)current;
            }
            current = current.getParent();
        }
        return null;
    }

    private AbstractNode findStatementNode(INode node, int offset) {
        boolean _notEquals;
        CompositeNode block = this.getBlockNode(node);
        boolean bl = _notEquals = !Objects.equal((Object)block, null);
        if (_notEquals) {
            Functions.Function1 _function = child -> child.getTextRegion().contains(offset);
            AbstractNode candidate = (AbstractNode)IterableExtensions.findFirst((Iterable)block.basicGetChildren(), (Functions.Function1)_function);
            return candidate;
        }
        return null;
    }

    private int findStart(String text, int offset) {
        int openIndex;
        int i = offset;
        while (i > 0) {
            String frame = text.substring(i - 1, i + 1);
            if (Objects.equal((Object)frame, (Object)":=") || Objects.equal((Object)frame, (Object)"+=") || Objects.equal((Object)frame, (Object)"-=") || Objects.equal((Object)frame, (Object)"in")) {
                if (i == offset) {
                    return offset;
                }
                return i + 1;
            }
            --i;
        }
        int whileIndex = text.indexOf("while");
        if (whileIndex != -1 && (openIndex = text.indexOf("(", whileIndex)) != -1) {
            return openIndex;
        }
        int ifIndex = text.indexOf("if");
        if (ifIndex != -1) {
            int openIndex_1 = text.indexOf("(", ifIndex);
            int thenIndex = text.indexOf("then", ifIndex);
            if (openIndex_1 != -1 && (thenIndex == -1 || openIndex_1 < thenIndex)) {
                return openIndex_1;
            }
        }
        return 0;
    }

    private String getOffsetPrefix(ContentAssistContext context) {
        try {
            INode _currentNode = context.getCurrentNode();
            int _offset = context.getOffset();
            int _minus = _offset - 1;
            AbstractNode stmtNode = this.findStatementNode(_currentNode, _minus);
            if (stmtNode != null) {
                String stmtText = context.getDocument().get(stmtNode.getOffset(), stmtNode.getLength());
                int _offset_1 = context.getOffset();
                int _minus_1 = _offset_1 - 1;
                int _offset_2 = stmtNode.getOffset();
                int _minus_2 = _minus_1 - _offset_2;
                int startIndex = this.findStart(stmtText, _minus_2);
                int _offset_3 = stmtNode.getOffset();
                int startOffset = _offset_3 + startIndex;
                IXtextDocument _document = context.getDocument();
                int _offset_4 = context.getOffset();
                int _minus_3 = _offset_4 - startOffset;
                return _document.get(startOffset, _minus_3);
            }
            return "";
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

