/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.expressions;

import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeSequence;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.AbstractRuntimeExpression;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;

public class RuntimeFilterBy
extends AbstractRuntimeExpression {
    private RuntimeClock filteredClock;
    private RuntimeSequence<Integer> filteringSequence;
    private int currentDelay;

    public RuntimeFilterBy(RuntimeClock iClock, RuntimeClock clock, RuntimeSequence<Integer> sequence) {
        super(iClock);
        this.filteredClock = clock;
        this.filteringSequence = sequence;
    }

    @Override
    public void start(AbstractSemanticHelper helper) throws SimulationException {
        if (!this.canCallStart()) {
            return;
        }
        super.start(helper);
        if (this.filteredClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.filteredClock)).start(helper);
        }
        if (this.filteringSequence.isEmpty()) {
            this.terminate(helper.getUpdateHelper());
            return;
        }
        this.filteringSequence.finiteIndex = 0;
        this.filteringSequence.infiniteIndex = 0;
        this.currentDelay = this.filteringSequence.popHead();
    }

    @Override
    public void semantic(AbstractSemanticHelper helper) throws SimulationException {
        if (!this.canCallSemantic()) {
            return;
        }
        super.semantic(helper);
        if (this.filteredClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.filteredClock)).semantic(helper);
        }
        if (this.currentDelay == 1) {
            helper.semanticBDDAnd(helper.createEqual(this.filteredClock, this.getExpressionClock()));
        } else {
            helper.inhibitClock(this.getExpressionClock());
        }
        helper.registerClockUse(new RuntimeClock[]{this.filteredClock, this.getExpressionClock()});
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper helper) throws SimulationException {
        super.deathSemantic(helper);
        if (this.filteredClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.filteredClock)).deathSemantic(helper);
        }
        helper.registerDeathImplication(this.filteredClock, this.getExpressionClock());
    }

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        if (!this.canCallUpdate()) {
            return;
        }
        super.update(helper);
        if (this.filteredClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.filteredClock)).update(helper);
        }
        if (helper.clockHasFired(this.filteredClock)) {
            if (this.currentDelay == 1) {
                if (this.filteringSequence.isEmpty()) {
                    this.terminate(helper);
                } else {
                    this.currentDelay = this.filteringSequence.popHead();
                }
            } else {
                --this.currentDelay;
            }
        }
    }
}

