/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dsa.executors.explorer;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.rtd.modelstate.k3ModelState.ElementState;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.rtd.modelstate.k3ModelState.K3ModelState;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.k3.rtd.modelstate.k3ModelState.K3ModelStateFactory;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dse.IMoccmlFutureAction;

public class ControlAndRTDState
implements Serializable {
    private static final long serialVersionUID = 0L;
    public K3ModelState modelState = K3ModelStateFactory.eINSTANCE.createK3ModelState();
    public byte[] moCCState = null;
    public Map<String, Boolean> nextEventToForce = null;
    public ArrayList<IMoccmlFutureAction> futurActions = null;
    static Integer index = 0;

    public ControlAndRTDState(K3ModelState modelS, byte[] moccS, Pair<Map<String, Boolean>, ArrayList<IMoccmlFutureAction>> engineState) {
        this.modelState = modelS;
        this.moCCState = moccS;
        this.nextEventToForce = (Map)engineState.getLeft();
        this.futurActions = (ArrayList)engineState.getRight();
    }

    public boolean equals(Object state) {
        return this.equals((ControlAndRTDState)state);
    }

    public boolean equals(ControlAndRTDState state) {
        if (!Arrays.equals(state.moCCState, this.moCCState)) {
            return false;
        }
        boolean i = false;
        for (ElementState newStateElemState : state.modelState.getOwnedElementstates()) {
            boolean found = false;
            for (ElementState modelElementState : this.modelState.getOwnedElementstates()) {
                if (!this.areEquals(modelElementState, newStateElemState)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        if (this.nextEventToForce != null && !this.areEquals(state.nextEventToForce, this.nextEventToForce)) {
            return false;
        }
        return this.areEquals(state.futurActions, this.futurActions);
    }

    private boolean areEquals(ArrayList<IMoccmlFutureAction> futurActions1, ArrayList<IMoccmlFutureAction> futurActions2) {
        if (futurActions1.size() != futurActions2.size()) {
            return false;
        }
        block0: for (IMoccmlFutureAction fa1 : futurActions1) {
            for (IMoccmlFutureAction fa2 : futurActions2) {
                if (fa1.getTriggeringMSEURI().compareTo(fa2.getTriggeringMSEURI()) == 0 && fa1.getMseToBeForcedURI().compareTo(fa2.getMseToBeForcedURI()) == 0) continue block0;
            }
            return false;
        }
        return true;
    }

    private boolean areEquals(Map<String, Boolean> engineState, Map<String, Boolean> newEngineState) {
        if (engineState.size() != newEngineState.size()) {
            return false;
        }
        block0: for (Map.Entry<String, Boolean> e1 : engineState.entrySet()) {
            for (Map.Entry<String, Boolean> e2 : newEngineState.entrySet()) {
                if (e1.getKey().compareTo(e2.getKey()) == 0 && e1.getValue() == e2.getValue()) continue block0;
            }
            return false;
        }
        return true;
    }

    private boolean areEquals(ElementState modelElementState, ElementState newStateElemState) {
        if (!modelElementState.getModelElement().equals(newStateElemState.getModelElement())) {
            return false;
        }
        for (Object newStateRTD : newStateElemState.getSavedRTDs()) {
            boolean RTDfound = false;
            for (Object modelRTD : modelElementState.getSavedRTDs()) {
                if (!newStateRTD.equals(modelRTD)) continue;
                RTDfound = true;
                break;
            }
            if (RTDfound) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sbRes = new StringBuilder();
        for (ElementState elemState : this.modelState.getOwnedElementstates()) {
            try {
                EList eAllAttributes = elemState.getModelElement().eClass().getEAllAttributes();
                for (EAttribute attr : eAllAttributes) {
                    Object value;
                    if (!"name".equals(attr.getName()) || !((value = elemState.getModelElement().eGet((EStructuralFeature)attr, false)) instanceof String)) continue;
                    sbRes.append(String.valueOf((String)value) + "\n");
                    break;
                }
            }
            catch (IllegalArgumentException | SecurityException e1) {
                sbRes.append(String.valueOf(elemState.getModelElement().getClass().getName()) + index);
                index = index + 1;
            }
            for (Object rtd : elemState.getSavedRTDs()) {
                try {
                    Field f = rtd.getClass().getDeclaredField("name");
                    f.setAccessible(true);
                    sbRes.append("\t" + f.get(rtd) + ":");
                    f = rtd.getClass().getDeclaredField("value");
                    f.setAccessible(true);
                    sbRes.append("\t" + f.get(rtd) + "\n");
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.nextEventToForce != null) {
            for (String mse : this.nextEventToForce.keySet()) {
                sbRes.append(String.valueOf(mse) + "=" + this.nextEventToForce.get(mse) + "\n");
            }
        }
        if (this.futurActions != null) {
            for (IMoccmlFutureAction fa : this.futurActions) {
                sbRes.append("free " + fa.getMseToBeForcedURI() + " on " + fa.getTriggeringMSEURI() + "\n");
            }
        }
        return sbRes.toString();
    }
}

