/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.lpg;

import java.io.IOException;
import java.io.Reader;
import lpg.runtime.ILexStream;
import lpg.runtime.LexParser;
import lpg.runtime.Monitor;
import lpg.runtime.ParseTable;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.lpg.DerivedLexStream;
import org.eclipse.ocl.lpg.DerivedPrsStream;

public abstract class AbstractLexer {
    private final BasicEnvironment environment;

    public static char[] getInputChars(Reader reader) throws IOException {
        char[] buffer = new char[16384];
        int nextIndex = 0;
        while (reader.ready()) {
            int moreChars;
            if (nextIndex >= buffer.length) {
                char[] newBuffer = new char[2 * buffer.length];
                System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
                buffer = newBuffer;
            }
            if ((moreChars = reader.read(buffer, nextIndex, buffer.length - nextIndex)) > 0) {
                nextIndex += moreChars;
                continue;
            }
            if (moreChars < 0) break;
        }
        if (nextIndex != buffer.length) {
            char[] newBuffer = new char[nextIndex];
            System.arraycopy(buffer, 0, newBuffer, 0, nextIndex);
            buffer = newBuffer;
        }
        return buffer;
    }

    public AbstractLexer(BasicEnvironment environment) {
        this.environment = environment;
    }

    public BasicEnvironment getEnvironment() {
        return this.environment;
    }

    @Deprecated
    public void initialize(char[] inputChars) {
        this.reset(inputChars, null);
    }

    @Deprecated
    public void initialize(Reader reader) throws IOException {
        char[] buffer = AbstractLexer.getInputChars(reader);
        this.reset(buffer, null);
    }

    @Deprecated
    public void lexToTokens(AbstractParser parser) {
        this.lexToTokens(null, parser);
    }

    @Deprecated
    public void lexToTokens(Monitor monitor, AbstractParser parser) {
        this.lexer(monitor, parser.getIPrsStream());
    }

    public abstract int[] getKeywordKinds();

    public abstract DerivedLexStream getILexStream();

    public abstract void reset(char[] var1, String var2);

    public abstract void reset(char[] var1, String var2, int var3);

    public abstract void reset(Reader var1, String var2) throws IOException;

    public abstract void lexer(DerivedPrsStream var1);

    public abstract void lexer(Monitor var1, DerivedPrsStream var2);

    public abstract void lexer(DerivedPrsStream var1, int var2, int var3);

    public abstract void lexer(Monitor var1, DerivedPrsStream var2, int var3, int var4);

    public abstract ParseTable getParseTable();

    public abstract LexParser getParser();

    public abstract void resetKeywordLexer();

    public abstract ILexStream getLexStream();

    public abstract void reportLexicalError(int var1, int var2);
}

