/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.tool.ReconnectEdgeDescription;
import org.eclipse.sirius.viewpoint.DMappingBased;

public class ReconnectEdgeDescriptionQuery {
    private ReconnectEdgeDescription reconnectEdgeDescription;

    public ReconnectEdgeDescriptionQuery(ReconnectEdgeDescription reconnectEdgeDescription) {
        this.reconnectEdgeDescription = reconnectEdgeDescription;
    }

    public boolean isEndAuthorized(boolean source, EdgeTarget end) {
        boolean result = false;
        if (end instanceof DMappingBased) {
            result = this.isEndAuthorized(source, (DMappingBased)end);
        }
        return result;
    }

    public boolean isEndAuthorized(boolean source, DMappingBased end) {
        boolean result = false;
        result = source ? this.isValidAsSourceElement(end) : this.isValidAsTargetElement(end);
        return result;
    }

    public boolean isValidAsSourceElement(DMappingBased element) {
        Iterator<DiagramElementMapping> it = this.collectApplicableToolSourceMappings().iterator();
        return this.doCheckAtLeastOneIsInstanceOf(element, it);
    }

    public boolean isValidAsTargetElement(DMappingBased element) {
        Iterator<DiagramElementMapping> it = this.collectApplicableToolTargetMappings().iterator();
        return this.doCheckAtLeastOneIsInstanceOf(element, it);
    }

    private Iterable<DiagramElementMapping> collectApplicableToolSourceMappings() {
        ArrayList<DiagramElementMapping> sources = new ArrayList<DiagramElementMapping>();
        for (EdgeMapping edge : this.reconnectEdgeDescription.getMappings()) {
            sources.addAll((Collection<DiagramElementMapping>)edge.getSourceMapping());
        }
        return sources;
    }

    private Iterable<DiagramElementMapping> collectApplicableToolTargetMappings() {
        ArrayList<DiagramElementMapping> targets = new ArrayList<DiagramElementMapping>();
        for (EdgeMapping edge : this.reconnectEdgeDescription.getMappings()) {
            targets.addAll((Collection<DiagramElementMapping>)edge.getTargetMapping());
        }
        return targets;
    }

    private boolean doCheckAtLeastOneIsInstanceOf(DMappingBased element, Iterator<DiagramElementMapping> it) {
        while (it.hasNext()) {
            DiagramElementMapping next = it.next();
            if (!new DiagramElementMappingQuery(next).isInstanceOf(element)) continue;
            return true;
        }
        return false;
    }
}

