/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.es2as;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AssociationClass;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Profile;
import org.eclipse.ocl.pivot.ProfileApplication;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Slot;
import org.eclipse.ocl.pivot.Stereotype;
import org.eclipse.ocl.pivot.StereotypeExtender;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.External2AS;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.uml.internal.es2as.AssociationClassProperties;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClassifierTemplateParameter;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class UML2ASReferenceSwitch
extends UMLSwitch<Object> {
    private static final Logger logger = Logger.getLogger(UML2ASReferenceSwitch.class);
    protected final @NonNull UML2AS converter;
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    protected final @NonNull StandardLibraryInternal standardLibrary;
    private Set<EClass> doneWarnings = null;

    public UML2ASReferenceSwitch(@NonNull UML2AS converter) {
        this.converter = converter;
        this.environmentFactory = converter.getEnvironmentFactory();
        this.standardLibrary = converter.getStandardLibrary();
    }

    public @NonNull Object caseAssociation(Association umlAssociation) {
        assert (umlAssociation != null);
        AssociationClass asAssociationClass = this.createAssociationClassProperties(umlAssociation);
        List asSuperClasses = asAssociationClass.getSuperClasses();
        if (asSuperClasses.isEmpty()) {
            asSuperClasses.add(this.standardLibrary.getOclElementType());
        }
        return asAssociationClass;
    }

    public @NonNull Object caseAssociationClass(org.eclipse.uml2.uml.AssociationClass umlAssociationClass) {
        assert (umlAssociationClass != null);
        this.createAssociationClassProperties((Association)umlAssociationClass);
        return this.caseClass((org.eclipse.uml2.uml.Class)umlAssociationClass);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Class caseClass(org.eclipse.uml2.uml.Class umlClass) {
        assert (umlClass != null);
        Class asClass = (Class)this.converter.getCreated(Class.class, (EObject)umlClass);
        if (asClass == null) {
            return this.standardLibrary.getOclInvalidType();
        }
        @NonNull List asSuperClasses = ClassUtil.nullFree((List)asClass.getSuperClasses());
        this.doSwitchAll(Class.class, asSuperClasses, (List<? extends EObject>)umlClass.getSuperClasses());
        if (asSuperClasses.isEmpty()) {
            asSuperClasses.add(this.standardLibrary.getOclElementType());
        }
        return asClass;
    }

    public @NonNull Class caseClassifier(Classifier umlClassifier) {
        assert (umlClassifier != null);
        Class asClass = (Class)this.converter.getCreated(Class.class, (EObject)umlClassifier);
        ArrayList<Class> asSuperClasses = new ArrayList<Class>();
        if (asClass == null) {
            return this.standardLibrary.getOclInvalidType();
        }
        for (Generalization umlGeneralization : umlClassifier.getGeneralizations()) {
            Class asGeneral;
            Classifier umlGeneral = umlGeneralization.getGeneral();
            if (umlGeneral == null || (asGeneral = (Class)this.converter.getCreated(Class.class, (EObject)umlGeneral)) == null || asSuperClasses.contains(asGeneral)) continue;
            asSuperClasses.add(asGeneral);
        }
        if (asSuperClasses.isEmpty()) {
            Class oclElementType = this.standardLibrary.getOclElementType();
            asSuperClasses.add(oclElementType);
        }
        this.converter.refreshList(asClass.getSuperClasses(), asSuperClasses);
        return asClass;
    }

    public Object caseClassifierTemplateParameter(ClassifierTemplateParameter umlTemplateParameter) {
        assert (umlTemplateParameter != null);
        TemplateParameter asTemplateParameter = (TemplateParameter)this.converter.getCreated(TemplateParameter.class, (EObject)umlTemplateParameter);
        if (asTemplateParameter != null) {
            for (Classifier umlClassifier : umlTemplateParameter.getConstrainingClassifiers()) {
                assert (umlClassifier != null);
                Class asConstrainingClass = (Class)this.converter.getCreated(Class.class, (EObject)umlClassifier);
                if (asConstrainingClass == null) continue;
                asTemplateParameter.getConstrainingClasses().add(asConstrainingClass);
            }
        }
        return asTemplateParameter;
    }

    public @NonNull Object caseExtension(Extension umlExtension) {
        StereotypeExtender asTypeExtension;
        assert (umlExtension != null);
        EList memberEnds = umlExtension.getMemberEnds();
        if (memberEnds.size() == 2) {
            org.eclipse.uml2.uml.Property firstEnd = (org.eclipse.uml2.uml.Property)memberEnds.get(0);
            org.eclipse.uml2.uml.Property secondEnd = (org.eclipse.uml2.uml.Property)memberEnds.get(1);
            if (firstEnd != null && secondEnd != null) {
                Property firstProperty = (Property)this.converter.getCreated(Property.class, (EObject)firstEnd);
                Property secondProperty = (Property)this.converter.getCreated(Property.class, (EObject)secondEnd);
                if (firstProperty != null && secondProperty != null) {
                    firstProperty.setOpposite(secondProperty);
                    secondProperty.setOpposite(firstProperty);
                }
            }
        }
        if ((asTypeExtension = (StereotypeExtender)this.converter.getCreated(StereotypeExtender.class, (EObject)umlExtension)) == null) {
            return this;
        }
        org.eclipse.uml2.uml.Class umlMetaclass = umlExtension.getMetaclass();
        org.eclipse.uml2.uml.Stereotype umlStereotype = umlExtension.getStereotype();
        if (umlMetaclass != null && umlStereotype != null) {
            Class asMetaclass = (Class)this.converter.getCreated(Class.class, (EObject)umlMetaclass);
            Stereotype asStereotype = (Stereotype)this.converter.getCreated(Stereotype.class, (EObject)umlStereotype);
            if (asMetaclass != null && asStereotype != null) {
                asTypeExtension.setOwningStereotype(asStereotype);
                asTypeExtension.setClass(asMetaclass);
                if (UML2AS.ADD_TYPE_EXTENSION.isActive()) {
                    UML2AS.ADD_TYPE_EXTENSION.println(asTypeExtension.toString());
                }
                this.converter.addTypeExtension(asTypeExtension);
            }
        }
        return asTypeExtension;
    }

    public @NonNull Object caseProfileApplication(org.eclipse.uml2.uml.ProfileApplication umlProfileApplication) {
        assert (umlProfileApplication != null);
        ProfileApplication asProfileApplication = (ProfileApplication)this.converter.getCreated(ProfileApplication.class, (EObject)umlProfileApplication);
        if (asProfileApplication == null) {
            return this;
        }
        org.eclipse.uml2.uml.Profile umlProfile = umlProfileApplication.getAppliedProfile();
        if (umlProfile != null) {
            Profile asProfile = (Profile)this.converter.getCreated(Profile.class, (EObject)umlProfile);
            asProfileApplication.setAppliedProfile(asProfile);
            this.converter.addProfileApplication(asProfileApplication);
        }
        return asProfileApplication;
    }

    public @NonNull Object caseProperty(org.eclipse.uml2.uml.Property umlProperty) {
        EObject eContainer;
        Type asTargetType;
        org.eclipse.uml2.uml.Type umlTargetType;
        assert (umlProperty != null);
        Association umlAssociation = umlProperty.getAssociation();
        assert (umlAssociation == null || umlAssociation instanceof Extension);
        this.caseTypedElement((org.eclipse.uml2.uml.TypedElement)umlProperty);
        Property asProperty = (Property)this.converter.getCreated(Property.class, (EObject)umlProperty);
        if (asProperty == null) {
            return this;
        }
        if (asProperty.getName() == null && (umlTargetType = umlProperty.getType()) != null && (asTargetType = (Type)this.converter.getCreated(Type.class, (EObject)umlTargetType)) != null) {
            asProperty.setName(asTargetType.getName());
        }
        Class pivotType = null;
        if (umlAssociation != null) {
            org.eclipse.uml2.uml.Type oppositeType;
            org.eclipse.uml2.uml.Property opposite;
            if (umlProperty.getOwningAssociation() != null) {
                asProperty.setIsImplicit(true);
            }
            if ((opposite = this.getOtherEnd(umlProperty)) != null && (oppositeType = opposite.getType()) != null) {
                pivotType = (Class)this.converter.getCreated(Class.class, (EObject)oppositeType);
            }
        }
        if (pivotType == null && (eContainer = umlProperty.eContainer()) != null) {
            pivotType = (Class)this.converter.getCreated(Class.class, eContainer);
        }
        if (pivotType != null) {
            this.converter.addProperty(pivotType, asProperty);
        }
        return asProperty;
    }

    public @NonNull Object caseSlot(org.eclipse.uml2.uml.Slot umlSlot) {
        assert (umlSlot != null);
        Slot asSlot = (Slot)this.converter.getCreated(Slot.class, (EObject)umlSlot);
        if (asSlot == null) {
            return this;
        }
        StructuralFeature umlDefiningFeature = umlSlot.getDefiningFeature();
        Property asProperty = umlDefiningFeature != null ? (Property)this.converter.getCreated(Property.class, (EObject)umlDefiningFeature) : null;
        asSlot.setDefiningProperty(asProperty);
        return asSlot;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Object caseStereotype(org.eclipse.uml2.uml.Stereotype umlStereotype) {
        assert (umlStereotype != null);
        Stereotype asStereotype = (Stereotype)this.converter.getCreated(Stereotype.class, (EObject)umlStereotype);
        if (asStereotype == null) {
            return this;
        }
        @NonNull List asSuperClasses = ClassUtil.nullFree((List)asStereotype.getSuperClasses());
        this.doSwitchAll(Class.class, asSuperClasses, (List<? extends EObject>)umlStereotype.getSuperClasses());
        Class oclStereotype = this.standardLibrary.getOclStereotypeType();
        if (!asSuperClasses.contains(oclStereotype)) {
            asSuperClasses.add(oclStereotype);
        }
        this.converter.addStereotype(asStereotype);
        return asStereotype;
    }

    public @NonNull EObject caseTypedElement(org.eclipse.uml2.uml.TypedElement umlTypedElement) {
        assert (umlTypedElement != null);
        TypedElement pivotElement = (TypedElement)this.converter.getCreated(TypedElement.class, (EObject)umlTypedElement);
        if (pivotElement == null) {
            return this.standardLibrary.getOclInvalidType();
        }
        this.converter.resolveMultiplicity(pivotElement, umlTypedElement);
        return pivotElement;
    }

    private @NonNull AssociationClass createAssociationClassProperties(@NonNull Association umlAssociation) {
        AssociationClass asAssociationClass = (AssociationClass)this.converter.getCreated(AssociationClass.class, (EObject)umlAssociation);
        assert (asAssociationClass != null);
        List<@NonNull org.eclipse.uml2.uml.Property> umlMemberEnds = this.converter.getSafeMemberEnds(umlAssociation);
        AssociationClassProperties asAssociationClassProperties = new AssociationClassProperties(umlMemberEnds);
        String associationName = asAssociationClass.getName();
        if (associationName != null) {
            int i = 0;
            while (i < umlMemberEnds.size()) {
                Class asMemberClass;
                org.eclipse.uml2.uml.Property umlMemberProperty = umlMemberEnds.get(i);
                org.eclipse.uml2.uml.Type umlMemberType = umlMemberProperty.getType();
                if (umlMemberType != null && (asMemberClass = (Class)this.converter.getCreated(Class.class, (EObject)umlMemberType)) != null) {
                    Type asAssociationClassEndType = this.getToAssociationEndType((Class)asAssociationClass, umlMemberProperty, umlMemberEnds);
                    Property asMember2AssociationProperty = PivotUtil.createProperty((String)associationName, (Type)asAssociationClassEndType);
                    Property asAssociation2MemberProperty = PivotUtil.createProperty((String)this.getEndName(umlMemberProperty), (Type)asMemberClass);
                    asMember2AssociationProperty.setIsRequired(this.getToAssociationEndIsRequired(umlMemberProperty, umlMemberEnds));
                    asMember2AssociationProperty.setIsImplicit(!(umlAssociation instanceof AssociationClass));
                    asMember2AssociationProperty.setOpposite(asAssociation2MemberProperty);
                    this.converter.addProperty((Class)asAssociationClass, asAssociation2MemberProperty);
                    asAssociationClassProperties.put(null, umlMemberProperty, asAssociation2MemberProperty);
                    asAssociation2MemberProperty.setIsRequired(true);
                    asAssociation2MemberProperty.setIsImplicit(false);
                    asAssociation2MemberProperty.setOpposite(asMember2AssociationProperty);
                    this.converter.addProperty(asMemberClass, asMember2AssociationProperty);
                    asAssociationClassProperties.put(umlMemberProperty, null, asMember2AssociationProperty);
                }
                ++i;
            }
        }
        int iThis2That = 0;
        while (iThis2That < umlMemberEnds.size()) {
            Class asThatClass;
            org.eclipse.uml2.uml.Property umlThis2ThatProperty = umlMemberEnds.get(iThis2That);
            org.eclipse.uml2.uml.Type umlThatType = umlThis2ThatProperty.getType();
            if (umlThatType != null && (asThatClass = (Class)this.converter.getCreated(Class.class, (EObject)umlThatType)) != null) {
                int iThat2This = iThis2That + 1;
                while (iThat2This < umlMemberEnds.size()) {
                    Class asThisClass;
                    org.eclipse.uml2.uml.Property umlThat2ThisProperty = umlMemberEnds.get(iThat2This);
                    org.eclipse.uml2.uml.Type umlThisType = umlThat2ThisProperty.getType();
                    if (umlThisType != null && (asThisClass = (Class)this.converter.getCreated(Class.class, (EObject)umlThisType)) != null) {
                        Type asThatEndType = this.getInterMemberEndType(asThatClass, umlThis2ThatProperty, umlMemberEnds);
                        Type asThisEndType = this.getInterMemberEndType(asThisClass, umlThat2ThisProperty, umlMemberEnds);
                        Property asThis2ThatProperty = PivotUtil.createProperty((String)this.getEndName(umlThis2ThatProperty), (Type)asThatEndType);
                        Property asThat2ThisProperty = PivotUtil.createProperty((String)this.getEndName(umlThat2ThisProperty), (Type)asThisEndType);
                        asThis2ThatProperty.setIsRequired(this.getEndIsRequired(umlThis2ThatProperty));
                        asThis2ThatProperty.setIsImplicit(umlThis2ThatProperty.getOwningAssociation() != null);
                        asThis2ThatProperty.setOpposite(asThat2ThisProperty);
                        ((PivotObjectImpl)asThis2ThatProperty).setESObject((EObject)umlThis2ThatProperty);
                        this.converter.addProperty(asThisClass, asThis2ThatProperty);
                        asAssociationClassProperties.put(umlThis2ThatProperty, umlThat2ThisProperty, asThis2ThatProperty);
                        asThat2ThisProperty.setIsRequired(this.getEndIsRequired(umlThat2ThisProperty));
                        asThat2ThisProperty.setIsImplicit(umlThat2ThisProperty.getOwningAssociation() != null);
                        asThat2ThisProperty.setOpposite(asThis2ThatProperty);
                        ((PivotObjectImpl)asThat2ThisProperty).setESObject((EObject)umlThat2ThisProperty);
                        this.converter.addProperty(asThatClass, asThat2ThisProperty);
                        asAssociationClassProperties.put(umlThat2ThisProperty, umlThis2ThatProperty, asThat2ThisProperty);
                    }
                    ++iThat2This;
                }
            }
            ++iThis2That;
        }
        this.converter.addAssociationClassProperties(asAssociationClass, asAssociationClassProperties);
        return asAssociationClass;
    }

    public Object doInPackageSwitch(EObject eObject) {
        int classifierID = eObject.eClass().getClassifierID();
        return this.doSwitch(classifierID, eObject);
    }

    public <T extends Element> void doSwitchAll(@NonNull java.lang.Class<T> pivotClass, Collection<T> pivotElements, List<? extends EObject> eObjects) {
        assert (pivotElements != null);
        assert (eObjects != null);
        for (EObject eObject : eObjects) {
            EClass eClass;
            External2AS adapter;
            Resource eResource;
            if (eObject == null) continue;
            @Nullable Element pivotElement = this.converter.getCreated(pivotClass, eObject);
            if (pivotElement == null && (eResource = eObject.eResource()) != null && (adapter = UML2AS.findAdapter((Resource)eResource, (EnvironmentFactoryInternal)this.environmentFactory)) != null) {
                pivotElement = adapter.getCreated(pivotClass, eObject);
            }
            if (pivotElement == null) {
                Object doSwitchResult;
                if (!(eObject instanceof Constraint)) {
                    System.out.println("Reference switching " + eObject);
                }
                if ((doSwitchResult = this.doSwitch(eObject)) != this) {
                    Element castSwitchResult;
                    pivotElement = castSwitchResult = (Element)doSwitchResult;
                }
            }
            if (pivotElement != null) {
                pivotElements.add(pivotElement);
                continue;
            }
            if (this.doneWarnings == null) {
                this.doneWarnings = new HashSet<EClass>();
            }
            if (!this.doneWarnings.add(eClass = eObject.eClass())) continue;
            logger.warn((Object)("Failed to create a pivot representation of a UML '" + eClass.getName() + "'"));
        }
    }

    private boolean getEndIsRequired(@NonNull org.eclipse.uml2.uml.Property umlProperty) {
        return umlProperty.getLower() != 0;
    }

    private @NonNull String getEndName(@NonNull org.eclipse.uml2.uml.Property umlProperty) {
        String name = umlProperty.getName();
        if (name != null) {
            return name;
        }
        return (String)ClassUtil.nonNullState((Object)umlProperty.getType().getName());
    }

    private @NonNull Type getInterMemberEndType(@NonNull Class asClass, @NonNull org.eclipse.uml2.uml.Property umlProperty, @NonNull List<@NonNull org.eclipse.uml2.uml.Property> umlMemberEnds) {
        if (!umlProperty.isMultivalued()) {
            return asClass;
        }
        boolean isOrdered = umlProperty.isOrdered();
        boolean isUnique = umlProperty.isUnique();
        if (umlMemberEnds.size() > 2) {
            for (org.eclipse.uml2.uml.Property umlOtherProperty : umlMemberEnds) {
                if (umlOtherProperty == umlProperty || umlOtherProperty.isOrdered()) continue;
                isOrdered = false;
            }
        }
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        return metamodelManager.getCollectionType(isOrdered, isUnique, (Type)asClass, true, ValueUtil.integerValueOf((int)umlProperty.getLower()), null);
    }

    private boolean getToAssociationEndIsRequired(@NonNull org.eclipse.uml2.uml.Property umlProperty, @NonNull List<@NonNull org.eclipse.uml2.uml.Property> umlMemberEnds) {
        return umlProperty.getLower() != 0;
    }

    private @NonNull Type getToAssociationEndType(@NonNull Class asClass, @NonNull org.eclipse.uml2.uml.Property umlProperty, @NonNull List<@NonNull org.eclipse.uml2.uml.Property> umlMemberEnds) {
        if (!umlProperty.isMultivalued()) {
            return asClass;
        }
        boolean isMultivalued = false;
        boolean isOrdered = true;
        for (org.eclipse.uml2.uml.Property umlOtherProperty : umlMemberEnds) {
            if (umlOtherProperty == umlProperty) continue;
            if (umlOtherProperty.isMultivalued()) {
                isMultivalued = true;
            }
            if (umlOtherProperty.isOrdered()) continue;
            isOrdered = false;
        }
        if (!isMultivalued) {
            return asClass;
        }
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        return metamodelManager.getCollectionType(isOrdered, true, (Type)asClass, true, ValueUtil.integerValueOf((int)umlProperty.getLower()), null);
    }

    protected org.eclipse.uml2.uml.Property getOtherEnd(@NonNull org.eclipse.uml2.uml.Property umlProperty) {
        org.eclipse.uml2.uml.Property otherEnd = umlProperty.getOtherEnd();
        if (otherEnd != null) {
            return otherEnd;
        }
        Association association = umlProperty.getAssociation();
        if (association != null) {
            ArrayList memberEnds = new ArrayList(association.getMemberEnds());
            memberEnds.remove(umlProperty);
            String umlPropertyName = umlProperty.getName();
            for (org.eclipse.uml2.uml.Property aProperty : memberEnds) {
                if (aProperty.getName().equals(umlPropertyName)) continue;
                return aProperty;
            }
        }
        return otherEnd;
    }

    public @Nullable org.eclipse.uml2.uml.Property getOtherEnd(@NonNull List<org.eclipse.uml2.uml.Property> umlMemberEnds, @NonNull org.eclipse.uml2.uml.Property umlProperty) {
        for (org.eclipse.uml2.uml.Property umlMemberEnd : umlMemberEnds) {
            if (umlMemberEnd == umlProperty) continue;
            return umlMemberEnd;
        }
        return null;
    }
}

