/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.wizard.content;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.intro.config.IIntroContentProvider;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.osgi.framework.Bundle;

public class TimesquareViewer
implements IIntroContentProvider {
    private static final String HREF_BULLET = "bullet";
    private IIntroContentProviderSite site;
    private boolean disposed;
    private String id;
    private List<NewsItem> items;
    private Composite parent;
    private FormToolkit toolkit;
    private FormText formText;
    private Image bulletImage;

    public void init(IIntroContentProviderSite site) {
        this.site = site;
        this.refresh();
    }

    public void createContent(String id, PrintWriter out) {
        if (this.disposed) {
            return;
        }
        this.id = id;
        if (this.items == null) {
            this.createNewsItems();
        }
        if (this.items.size() > 0) {
            out.println("<ul id=\"news-feed\" class=\"news-list\">");
            int i = 0;
            while (i < this.items.size()) {
                NewsItem item = this.items.get(i);
                out.print("<li>");
                out.print("<a class=\"topicList\" href=\"");
                out.print(item.url);
                out.print("\">");
                out.print(item.label);
                out.print("</a>");
                out.print("</li>\n");
                ++i;
            }
            out.println("</ul>");
        }
    }

    public void createContent(String id, Composite parent, FormToolkit toolkit) {
        if (this.disposed) {
            return;
        }
        this.id = id;
        if (this.formText == null) {
            this.formText = toolkit.createFormText(parent, true);
            this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    TimesquareViewer.this.doNavigate((String)e.getHref());
                }
            });
            this.bulletImage = this.createImage((IPath)new Path("icons/arrow.gif"));
            if (this.bulletImage != null) {
                this.formText.setImage(HREF_BULLET, this.bulletImage);
            }
            this.parent = parent;
            this.toolkit = toolkit;
            this.id = id;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<form>");
        if (this.items == null) {
            this.createNewsItems();
        }
        if (this.items.size() > 0) {
            int i = 0;
            while (i < this.items.size()) {
                NewsItem item = this.items.get(i);
                buffer.append("<li style=\"image\" value=\"");
                buffer.append(HREF_BULLET);
                buffer.append("\">");
                buffer.append("<a href=\"");
                buffer.append(item.url);
                buffer.append("\">");
                buffer.append(item.label);
                buffer.append("</a>");
                buffer.append("</li>");
                ++i;
            }
        } else {
            buffer.append("<p>");
            buffer.append("</p>");
        }
        buffer.append("</form>");
        String text = buffer.toString();
        text = text.replaceAll("&{1}", "&amp;");
        this.formText.setText(text, true, false);
    }

    public void dispose() {
        if (this.bulletImage != null) {
            this.bulletImage.dispose();
            this.bulletImage = null;
        }
        this.disposed = true;
    }

    private void createNewsItems() {
        this.items = Collections.synchronizedList(new ArrayList());
        NewsItem item = new NewsItem();
        item.setLabel("New Extended CCSL");
        item.setUrl("http://org.eclipse.ui.intro/runAction?pluginId=fr.inria.aoste.timesquare.wizard&amp;class=fr.inria.aoste.timesquare.wizard.action.DemoAction&amp;paramwizard=ext");
        this.items.add(item);
        item = new NewsItem();
        item.setLabel("New CCSL lib");
        item.setUrl("http://org.eclipse.ui.intro/runAction?pluginId=fr.inria.aoste.timesquare.wizard&amp;class=fr.inria.aoste.timesquare.wizard.action.DemoAction&amp;paramwizard=lib");
        this.items.add(item);
    }

    private void refresh() {
        Thread newsWorker = new Thread(new NewsFeed());
        newsWorker.start();
    }

    private Image createImage(IPath path) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.intro");
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        try {
            url = FileLocator.toFileURL((URL)url);
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            return desc.createImage();
        }
        catch (IOException e) {
            return null;
        }
    }

    private void doNavigate(final String url) {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IIntroURL introUrl = IntroURLFactory.createIntroURL((String)url);
                if (introUrl != null) {
                    introUrl.execute();
                    return;
                }
                TimesquareViewer.this.openBrowser(url);
            }
        });
    }

    private void openBrowser(String href) {
        try {
            URL url = new URL(href);
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            support.getExternalBrowser().openURL(url);
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    class NewsFeed
    implements Runnable {
        NewsFeed() {
        }

        @Override
        public void run() {
            if (TimesquareViewer.this.disposed) {
                return;
            }
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (TimesquareViewer.this.parent != null) {
                        TimesquareViewer.this.createContent(TimesquareViewer.this.id, TimesquareViewer.this.parent, TimesquareViewer.this.toolkit);
                    }
                    TimesquareViewer.this.site.reflow((IIntroContentProvider)TimesquareViewer.this, true);
                }
            });
        }
    }

    public static class NewsItem {
        String label;
        String url;

        public NewsItem(String label, String url) {
            this.label = label;
            this.url = url;
        }

        public NewsItem() {
        }

        void setLabel(String label) {
            this.label = label;
        }

        void setUrl(String url) {
            this.url = url;
        }
    }
}

