/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.wizard.demo;

import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import fr.inria.aoste.timesquare.wizard.demo.WorkspaceModificationCreateProject;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class DemoWizard
extends BasicNewProjectResourceWizard {
    protected WizardNewProjectCreationPage mainPage;
    protected IProject newProject;
    protected IProject newProjectHandle = null;

    public void addPages() {
        this.mainPage = new WizardNewProjectCreationPage("CCSL DEMO Project page");
        this.mainPage.setDescription("Create a new CCSL DEMO project");
        this.mainPage.setTitle("CCSL DEMO project :");
        this.mainPage.setMessage("Hello");
        this.mainPage.setInitialProjectName("DemoCCSL");
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        block3: {
            this.newProject = this.createProject();
            if (this.newProject != null) break block3;
            return true;
        }
        try {
            this.updatePerspective();
            DemoWizard.selectAndReveal((IResource)this.newProject, (IWorkbenchWindow)PluginHelpers.getActiveWorkbench());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
    }

    protected IProject createProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (this.mainPage == null) {
            return this.newProject;
        }
        this.newProjectHandle = this.mainPage.getProjectHandle();
        IProjectDescription description = workspace.newProjectDescription(this.newProjectHandle.getName());
        if (!this.mainPage.useDefaults()) {
            description.setLocation(this.mainPage.getLocationPath());
        }
        WorkspaceModificationCreateProject operation = new WorkspaceModificationCreateProject(this, description);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Cannot create a CCSL demo project", (String)e.getTargetException().getMessage());
            return null;
        }
        return this.newProjectHandle;
    }

    protected void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) {
        try {
            try {
                monitor.beginTask("Create Project", 200);
                projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                projectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                ErrorConsole.printError((Throwable)ex);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

