/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.core.console;

import fr.inria.aoste.timesquare.launcher.debug.model.CCSLProcess;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class ConsoleSimulation
extends IOConsole
implements IConsole {
    private CCSLProcess iProcess = null;
    private IOConsoleOutputStream std = null;
    private IOConsoleOutputStream err = null;
    private IOConsoleOutputStream step = null;
    private InputStream input = null;
    private PrintStream consolestd;
    private PrintStream consoleerr;
    private PrintStream consolestep;

    public ConsoleSimulation(CCSLProcess process, String name) {
        super(name, null);
        this.iProcess = process;
        this.initandregister();
    }

    public ConsoleSimulation() {
        super("noconsole", null);
    }

    public final PrintStream getConsolestd() {
        return this.consolestd;
    }

    public void printStdMessageln(String message) {
        try {
            if (this.consolestd != null) {
                this.consolestd.println(message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void printStdMessage(String message) {
        try {
            if (this.consolestd != null) {
                this.consolestd.print(message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected final PrintStream getConsoleerr() {
        return this.consoleerr;
    }

    public void printErrMessageln(String message) {
        try {
            if (this.consoleerr != null) {
                this.consoleerr.println(message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void printErrMessageln(String message, Throwable _e) {
        try {
            if (this.consoleerr != null) {
                this.consoleerr.println(message);
                _e.printStackTrace(this.consoleerr);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void printErrMessage(String message) {
        try {
            if (this.consoleerr != null) {
                this.consoleerr.print(message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected final OutputStream getStd() {
        return this.std;
    }

    protected final OutputStream getErr() {
        return this.err;
    }

    public final InputStream getInput() {
        return this.input;
    }

    private void initandregister() {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        manager.addConsoles(new IConsole[]{this});
        manager.showConsoleView((IConsole)this);
        this.std = this.newOutputStream();
        this.err = this.newOutputStream();
        this.step = this.newOutputStream();
        this.input = this.getInputStream();
        this.std.setActivateOnWrite(false);
        this.err.setActivateOnWrite(false);
        this.step.setActivateOnWrite(false);
        this.std.setColor(new Color(null, 0, 0, 0));
        this.err.setColor(new Color(null, 255, 0, 0));
        this.step.setColor(new Color(null, 0, 0, 255));
        this.consolestd = new PrintStream((OutputStream)this.std);
        this.consoleerr = new PrintStream((OutputStream)this.err);
        this.consolestep = new PrintStream((OutputStream)this.step);
    }

    public void printStepSimulation(int n) {
        try {
            if (this.consolestep != null) {
                this.consolestep.println();
                this.consolestep.println("Simulation (Step " + n + ") ");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void printStep(int n, boolean replay) {
        try {
            if (this.consolestep != null) {
                this.consolestep.println("Display (Step " + n + ") ");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void printSimulationMessageln(String message) {
        try {
            if (this.consolestep != null) {
                this.consolestep.println(message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void printSimulationMessage(String message) {
        try {
            if (this.consolestep != null) {
                this.consolestep.print(message);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected final CCSLProcess getiProcess() {
        return this.iProcess;
    }

    protected void dispose() {
        super.dispose();
    }
}

