/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.debug.model;

import fr.inria.aoste.timesquare.launcher.core.inter.ICCSLProxy;
import fr.inria.aoste.timesquare.launcher.debug.model.ThreadInterface;
import java.util.HashMap;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;

public final class CCSLProcess
extends PlatformObject
implements IProcess,
IDisconnect {
    private ILaunch launch;
    private boolean isTerminated = false;
    private ThreadInterface currentCCSLThread;
    private HashMap<String, String> tableattribut = new HashMap();
    boolean disconnected = false;

    public CCSLProcess(ILaunch launch, ICCSLProxy helper) {
        this.launch = launch;
        launch.addProcess((IProcess)this);
        this.setAttribute(IProcess.ATTR_CMDLINE, "run  " + helper.get_SourceIFile());
    }

    public Thread addThread(ThreadInterface thread) {
        this.currentCCSLThread = thread;
        try {
            Thread myThread = new Thread((Runnable)this.currentCCSLThread, "CCSLProcess");
            myThread.start();
            return myThread;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getAttribute(String key) {
        return this.tableattribut.get(key);
    }

    public int getExitValue() throws DebugException {
        if (this.currentCCSLThread != null) {
            return this.currentCCSLThread.getExitValue();
        }
        return 0;
    }

    public String getLabel() {
        return "CCSL simulation process ";
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public void setAttribute(String key, String value) {
        this.tableattribut.put(key, value);
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        if (this.currentCCSLThread != null) {
            return this.isTerminated || this.currentCCSLThread.isTerminated();
        }
        return this.isTerminated;
    }

    public void terminate() throws DebugException {
        System.out.println("terminate " + this.currentCCSLThread);
        if (!this.isTerminated() && this.currentCCSLThread != null) {
            this.currentCCSLThread.terminate();
        }
        this.isTerminated = true;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    public boolean canDisconnect() {
        return true;
    }

    public void disconnect() throws DebugException {
        this.disconnected = true;
        this.currentCCSLThread.getSim().disconnect();
        DebugPlugin.getDefault().getLaunchManager().removeLaunch(this.launch);
        if (this.launch != null) {
            this.launch.removeProcess((IProcess)this);
            IProcess[] iProcessArray = this.launch.getProcesses();
            int n = iProcessArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess p = iProcessArray[n2];
                this.launch.removeProcess(p);
                ++n2;
            }
        }
        this.launch = null;
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }
}

