/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy;

import com.google.common.collect.Iterables;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.style.NodeStyleDescription;
import org.eclipse.sirius.diagram.description.style.SquareDescription;
import org.eclipse.sirius.diagram.description.style.WorkspaceImageDescription;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.tool.ToolCommandBuilder;
import org.eclipse.sirius.diagram.sequence.description.EndOfLifeMapping;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.operation.SequenceEditPartsOperations;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ExecutionEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ISequenceEventEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.LifelineEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.policy.SequenceInteractionFeedBackBuilder;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.figure.RangeGuide;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.layout.SequenceGraphicalHelper;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.EditPartsHelper;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.DNode2ItemSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class ExecutionSemanticEditPolicy
extends DNode2ItemSemanticEditPolicy {
    private RangeGuide forbiddenRangeArea;

    public Command getCommand(Request request) {
        Command superCommand = super.getCommand(request);
        Command command = this.customizeEndOfLifeCreationCommand(request, superCommand);
        return command;
    }

    private Command customizeEndOfLifeCreationCommand(Request request, Command superCommand) {
        Command command = superCommand;
        if (request instanceof CreateViewRequest) {
            CreateViewRequest cvr = (CreateViewRequest)request;
            EndOfLifeMapping endOfLifeMapping = this.getEndOfLifeMapping(cvr);
            if (cvr.getLocation().x == -1 && cvr.getLocation().y == -1 && endOfLifeMapping != null) {
                String label = superCommand != null ? superCommand.getLabel() : "";
                CompositeTransactionalCommand ctc = new CompositeTransactionalCommand(this.getEditingDomain(), label);
                if (superCommand != null) {
                    ctc.compose((IUndoableOperation)new CommandProxy(superCommand));
                }
                ChangeBoundsRequest cbr = new ChangeBoundsRequest((Object)"resize");
                cbr.setResizeDirection(4);
                cbr.getSizeDelta().height = -this.calculateHalfSizeOfEndOfLifeEditPartToCreate(endOfLifeMapping);
                ctc.compose((IUndoableOperation)new CommandProxy(this.getHost().getCommand((Request)cbr)));
                ICommandProxy iCommandProxy = new ICommandProxy((ICommand)ctc);
                iCommandProxy.setLabel(ctc.getLabel());
                command = iCommandProxy;
            }
        }
        return command;
    }

    private int calculateHalfSizeOfEndOfLifeEditPartToCreate(EndOfLifeMapping endOfLifeMapping) {
        WorkspaceImageDescription wid;
        String sizeComputationExpression;
        Integer sizeComputationInteger;
        NodeStyleDescription style = endOfLifeMapping.getStyle();
        int halfsize = 0;
        if (style instanceof SquareDescription) {
            SquareDescription sd = (SquareDescription)style;
            halfsize = sd.getHeight() * 10 / 2;
            if (halfsize < 10) {
                halfsize = 10;
            }
        } else if (style instanceof WorkspaceImageDescription && (sizeComputationInteger = Integer.valueOf(sizeComputationExpression = (wid = (WorkspaceImageDescription)style).getSizeComputationExpression())) != null) {
            halfsize = sizeComputationInteger * 10 / 2;
        }
        return halfsize;
    }

    public void showTargetFeedback(Request request) {
        this.removeForbiddenRangeFeedback();
        if (request instanceof CreateRequest && ((CreateRequest)request).getLocation() != null) {
            ISequenceEventEditPart host = (ISequenceEventEditPart)this.getHost();
            ISequenceEvent sequenceEvent = host.getISequenceEvent();
            SequenceDiagram sequenceDiagram = sequenceEvent.getDiagram();
            CreateRequest createRequest = (CreateRequest)request;
            Point location = createRequest.getLocation().getCopy();
            GraphicalHelper.screen2logical((Point)location, (GraphicalEditPart)((IGraphicalEditPart)this.getHost()));
            EventEnd startingEndPredecessor = SequenceGraphicalHelper.getEndBefore(sequenceDiagram.getSequenceDDiagram(), location.y);
            if (ToolCommandBuilder.isStartingEventEndOfCombinedFragment((SequenceDiagram)sequenceDiagram, (EventEnd)startingEndPredecessor) && startingEndPredecessor instanceof SingleEventEnd) {
                IFigure layer = this.getFeedbackLayer();
                SingleEventEnd singleEventEnd = (SingleEventEnd)startingEndPredecessor;
                ISequenceEvent ise = EventEndHelper.findISequenceEvent((SingleEventEnd)singleEventEnd, (SequenceDiagram)sequenceDiagram);
                if (layer != null && ise instanceof CombinedFragment) {
                    Range verticalRange = ise.getVerticalRange();
                    Rectangle screenRange = new Rectangle(0, verticalRange.getLowerBound(), 0, 30);
                    screenRange.performScale(GraphicalHelper.getZoom((EditPart)this.getHost()));
                    Range forbiddenRange = RangeHelper.verticalRange((Rectangle)screenRange);
                    this.forbiddenRangeArea = new RangeGuide(SequenceInteractionFeedBackBuilder.CONFLICT_FEEDBACK_COLOR, forbiddenRange, true);
                    Rectangle bounds = layer.getBounds().getCopy();
                    bounds.height = forbiddenRange.width();
                    bounds.y = forbiddenRange.getLowerBound();
                    this.forbiddenRangeArea.setBounds(bounds);
                    layer.add((IFigure)this.forbiddenRangeArea);
                }
            } else {
                super.showTargetFeedback(request);
            }
        } else {
            super.showTargetFeedback(request);
        }
    }

    public void eraseTargetFeedback(Request request) {
        this.removeForbiddenRangeFeedback();
        super.eraseTargetFeedback(request);
    }

    public EditPart getTargetEditPart(Request request) {
        Object result = super.getTargetEditPart(request);
        RequestQuery requestQuery = new RequestQuery(request);
        if (request instanceof CreateConnectionRequest && requestQuery.isStandardMessageCreation() && this.getHost() instanceof ISequenceEventEditPart && "connection end".equals(request.getType())) {
            Point firstClickLocation;
            CreateConnectionRequest createRequest = (CreateConnectionRequest)request;
            ISequenceEventEditPart ise = (ISequenceEventEditPart)this.getHost();
            if (ise instanceof ExecutionEditPart) {
                ise = (ISequenceEventEditPart)new EditPartQuery((IGraphicalEditPart)ise).getFirstAncestorOfType(LifelineEditPart.class);
            } else if (!(ise instanceof LifelineEditPart)) {
                ise = null;
            }
            EditPart source = createRequest.getSourceEditPart();
            if (source instanceof ExecutionEditPart) {
                source = (EditPart)new EditPartQuery((IGraphicalEditPart)source).getFirstAncestorOfType(LifelineEditPart.class);
            } else if (!(source instanceof LifelineEditPart)) {
                source = null;
            }
            if (ise != null && !ise.equals(source) && (firstClickLocation = SequenceEditPartsOperations.getConnectionSourceLocation(createRequest, (IGraphicalEditPart)ise)) != null) {
                GraphicalHelper.screen2logical((Point)firstClickLocation, (GraphicalEditPart)ise);
                ISequenceEvent sequenceEvent = ise.getISequenceEvent();
                Range targetRange = sequenceEvent.getVerticalRange();
                for (ExecutionEditPart potentialTarget : EditPartsHelper.getAllExecutions((IGraphicalEditPart)ise)) {
                    Range range = potentialTarget.getISequenceEvent().getVerticalRange();
                    if (!targetRange.includes(range) || !range.includes(firstClickLocation.y)) continue;
                    targetRange = range;
                    result = potentialTarget;
                }
            }
        }
        return result;
    }

    private EndOfLifeMapping getEndOfLifeMapping(CreateViewRequest createViewRequest) {
        Iterable filter = Iterables.filter((Iterable)createViewRequest.getViewDescriptors(), CreateViewRequest.ViewDescriptor.class);
        for (CreateViewRequest.ViewDescriptor viewDescriptor : filter) {
            DNode dns;
            NodeMapping actualMapping;
            EObjectAdapter eobjectAdapter;
            Object realObject;
            IAdaptable elementAdapter = viewDescriptor.getElementAdapter();
            if (!(elementAdapter instanceof EObjectAdapter) || !((realObject = (eobjectAdapter = (EObjectAdapter)elementAdapter).getRealObject()) instanceof DNode) || !((actualMapping = (dns = (DNode)realObject).getActualMapping()) instanceof EndOfLifeMapping)) continue;
            return (EndOfLifeMapping)actualMapping;
        }
        return null;
    }

    public static boolean isCombinedFragmentTitleRangeEdgeCreation(ISequenceElement sequenceElement, SequenceDiagram sequenceDiagram, Point firstClickLocation, Point secondClickLocation) {
        EventEnd finishingEndPredecessor;
        boolean result = false;
        EventEnd startingEndPredecessor = SequenceGraphicalHelper.getEndBefore(sequenceDiagram.getSequenceDDiagram(), firstClickLocation.y);
        if (ToolCommandBuilder.isStartingEventEndOfCombinedFragment((SequenceDiagram)sequenceDiagram, (EventEnd)startingEndPredecessor)) {
            result = true;
        }
        if (ToolCommandBuilder.isStartingEventEndOfCombinedFragment((SequenceDiagram)sequenceDiagram, (EventEnd)(finishingEndPredecessor = SequenceGraphicalHelper.getEndBefore(sequenceDiagram.getSequenceDDiagram(), secondClickLocation.y)))) {
            result = true;
        }
        return result;
    }

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        CompoundCommand cc = new CompoundCommand();
        this.addDestroyChildNodesCommand(cc);
        this.addDestroyShortcutsCommand(cc);
        cc.add(this.getGEFWrapper((ICommand)new DestroyElementCommand(req)));
        return cc.unwrap();
    }

    private void removeForbiddenRangeFeedback() {
        IFigure layer = this.getFeedbackLayer();
        if (this.forbiddenRangeArea != null && layer.getChildren().contains((Object)this.forbiddenRangeArea)) {
            layer.remove((IFigure)this.forbiddenRangeArea);
        }
    }

    private IFigure getFeedbackLayer() {
        IFigure layer = LayerManager.Helper.find((EditPart)this.getHost()).getLayer((Object)"Feedback Layer");
        return layer;
    }
}

