/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.stategraph.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.addon.stategraph.logic.DirectedGraph;
import org.eclipse.gemoc.addon.stategraph.logic.StateVertex;
import org.eclipse.gemoc.trace.commons.model.trace.Dimension;
import org.eclipse.gemoc.trace.commons.model.trace.State;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;
import org.eclipse.gemoc.trace.commons.model.trace.Value;
import org.eclipse.gemoc.trace.gemoc.api.ITraceExplorer;
import org.eclipse.gemoc.trace.gemoc.api.ITraceExtractor;
import org.eclipse.gemoc.trace.gemoc.api.ITraceListener;
import org.eclipse.gemoc.trace.gemoc.api.ITraceViewListener;

public class StateGraph
extends DirectedGraph<StateVertex>
implements ITraceViewListener,
ITraceListener {
    private ITraceExplorer<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> traceExplorer;
    private ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> traceExtractor;
    private final Map<State<?, ?>, StateVertex> stateToNode = new HashMap();
    private final Map<State<?, ?>, State<?, ?>> stateToEquivalentState = new HashMap();
    private final List<State<?, ?>> equivalentStates = new ArrayList();
    private BiConsumer<Boolean, StateVertex> renderCommand = null;
    private final List<Boolean> ignoredValueTraces = new ArrayList<Boolean>();

    public void setTraceExtractor(ITraceExtractor<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> traceExtractor) {
        if (this.traceExtractor != null) {
            this.traceExtractor.removeListener((ITraceViewListener)this);
        }
        this.traceExtractor = traceExtractor;
        if (this.traceExtractor != null) {
            this.traceExtractor.registerCommand((ITraceViewListener)this, () -> this.updateGraph());
        }
    }

    public void setTraceExplorer(ITraceExplorer<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> traceExplorer) {
        if (this.traceExplorer != null) {
            this.traceExplorer.removeListener((ITraceViewListener)this);
        }
        this.traceExplorer = traceExplorer;
        if (this.traceExplorer != null) {
            this.traceExplorer.registerCommand((ITraceViewListener)this, () -> this.updateCurrentState());
        }
    }

    public void setUpdateCommand(BiConsumer<Boolean, StateVertex> command) {
        this.renderCommand = command;
    }

    private void updateGraph() {
        ArrayList<Boolean> newIgnoredValueTraces = new ArrayList<Boolean>();
        for (Dimension dimension : this.traceExtractor.getDimensions()) {
            newIgnoredValueTraces.add(this.traceExtractor.isDimensionIgnored(dimension));
        }
        if (!newIgnoredValueTraces.equals(this.ignoredValueTraces)) {
            this.ignoredValueTraces.clear();
            this.ignoredValueTraces.addAll(newIgnoredValueTraces);
            this.computeStateSpace();
            this.render(false, null);
        }
    }

    private void updateCurrentState() {
        State currentState;
        StateVertex currentNode = null;
        if (this.traceExplorer != null && (currentState = this.traceExplorer.getCurrentState()) != null) {
            EObject equivalentState = (EObject)this.stateToEquivalentState.get(currentState);
            currentNode = this.stateToNode.get(equivalentState);
        }
        this.render(false, currentNode);
    }

    public void update() {
    }

    private void updateEquivalentStates(Collection<List<State<?, ?>>> equivalenceClasses) {
        equivalenceClasses.forEach(l -> {
            State equivalentState = null;
            for (State state : l) {
                if (!this.equivalentStates.contains(state)) continue;
                equivalentState = state;
                break;
            }
            if (equivalentState == null) {
                if (l.isEmpty()) {
                    return;
                }
                equivalentState = (State)l.remove(0);
                this.equivalentStates.add(equivalentState);
            } else {
                l.remove(equivalentState);
                l.forEach(s -> {
                    this.equivalentStates.remove(s);
                    this.removeVertex(this.stateToNode.remove(s));
                });
            }
            this.stateToEquivalentState.put(equivalentState, equivalentState);
            for (State otherState : l) {
                this.stateToEquivalentState.put(otherState, equivalentState);
            }
        });
    }

    private void computeStateSpace() {
        this.stateToEquivalentState.clear();
        List equivalenceClasses = this.traceExtractor.computeStateEquivalenceClasses();
        this.updateEquivalentStates(equivalenceClasses);
        int n = this.traceExtractor.getStatesTraceLength();
        List steps = this.traceExtractor.getSteps(0, n);
        ArrayList<DirectedGraph.Edge<StateVertex>> addedEdges = new ArrayList<DirectedGraph.Edge<StateVertex>>();
        while (!steps.isEmpty()) {
            State endingState;
            State startingState;
            DirectedGraph.Edge<StateVertex> addedEdge;
            Step step = (Step)steps.remove(0);
            List subSteps = this.traceExtractor.getSubSteps(step);
            if (step.getEndingState() != null && subSteps.isEmpty() && (addedEdge = this.addEdge(startingState = step.getStartingState(), endingState = step.getEndingState(), step)) != null) {
                addedEdges.add(addedEdge);
            }
            steps.addAll(0, subSteps);
        }
        ArrayList<DirectedGraph.Edge<DirectedGraph.Edge>> edgesToRemove = new ArrayList<DirectedGraph.Edge<DirectedGraph.Edge>>(this.getEdges());
        edgesToRemove.removeAll(addedEdges);
        edgesToRemove.forEach(e -> this.removeEdge(e));
    }

    public DirectedGraph.Edge<StateVertex> addEdge(State<?, ?> startState, State<?, ?> endState, Step<?> step) {
        String description;
        State<?, ?> equivalentStartState = this.stateToEquivalentState.get(startState);
        State<?, ?> equivalentEndState = this.stateToEquivalentState.get(endState);
        if (equivalentEndState == equivalentStartState || equivalentStartState == null || equivalentEndState == null) {
            return null;
        }
        StateVertex startNode = null;
        StateVertex endNode = null;
        for (Map.Entry<State<?, ?>, StateVertex> entry : this.stateToNode.entrySet()) {
            EObject entryState = (EObject)entry.getKey();
            if (startNode == null && equivalentStartState == entryState) {
                startNode = entry.getValue();
                continue;
            }
            if (endNode == null && equivalentEndState == entryState) {
                endNode = entry.getValue();
            }
            if (startNode != null && endNode != null) break;
        }
        if (startNode == null) {
            startNode = this.addVertex(new StateVertex(this.traceExtractor.getStateDescription(startState), this.traceExtractor.getStateIndex(startState)));
            this.stateToNode.put(equivalentStartState, startNode);
        } else {
            int startIndex = this.traceExtractor.getStateIndex(equivalentStartState);
            description = this.traceExtractor.getStateDescription(equivalentStartState);
            startNode.setTooltip(description);
            startNode.setIndex(startIndex);
        }
        if (endNode == null) {
            endNode = this.addVertex(new StateVertex(this.traceExtractor.getStateDescription(endState), this.traceExtractor.getStateIndex(endState)));
            this.stateToNode.put(equivalentEndState, endNode);
        } else {
            int endIndex = this.traceExtractor.getStateIndex(equivalentEndState);
            description = this.traceExtractor.getStateDescription(equivalentEndState);
            endNode.setTooltip(description);
            endNode.setIndex(endIndex);
        }
        DirectedGraph.Edge<StateVertex> result = this.getEdge(startNode, endNode);
        if (result == null) {
            result = this.addEdge(startNode, endNode);
        }
        return result;
    }

    public void clear() {
        this.stateToNode.clear();
        if (this.renderCommand != null) {
            this.renderCommand.accept(true, null);
        }
        this.update();
    }

    private void render(boolean clear, StateVertex currentVertex) {
        if (this.renderCommand != null) {
            this.renderCommand.accept(clear, currentVertex);
        }
    }

    public void statesAdded(List<State<?, ?>> states) {
        List equivalenceClasses = this.traceExtractor.computeStateEquivalenceClasses();
        this.updateEquivalentStates(equivalenceClasses);
        this.render(false, null);
    }

    public void stepsEnded(List<Step<?>> steps) {
        for (Step<?> step : steps) {
            this.addEdge(step.getStartingState(), step.getEndingState(), step);
        }
        this.render(false, null);
    }

    public void stepsStarted(List<Step<?>> steps) {
    }

    public void valuesAdded(List<Value<?>> values) {
    }

    public void dimensionsAdded(List<Dimension<?>> dimensions) {
    }
}

