/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.stategraph.logic.alg;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gemoc.addon.stategraph.logic.alg.IHullAlgorithm;

public class JarvisMarch
implements IHullAlgorithm {
    @Override
    public List<double[]> convexHull(List<double[]> points) {
        ArrayList<double[]> result = new ArrayList<double[]>();
        double[] extreme = this.findExtreme(points);
        result.add(new double[]{extreme[0], extreme[1]});
        double[] p = new double[]{extreme[0], extreme[1]};
        double[] q = new double[]{extreme[0], extreme[1]};
        while (true) {
            double[] r = new double[2];
            int i = 0;
            while (i < points.size()) {
                double[] tmp = points.get(i);
                if (tmp[0] != p[0] || tmp[1] != p[1]) {
                    r[0] = tmp[0];
                    r[1] = tmp[1];
                    int turn = this.orientation(p, q, r);
                    double dist = this.compare(this.dist(p, r), this.dist(p, q));
                    if (turn == -1 || turn == 0 && dist == 1.0) {
                        q[0] = r[0];
                        q[1] = r[1];
                    }
                }
                ++i;
            }
            if (q[0] == ((double[])result.get(0))[0] && q[1] == ((double[])result.get(0))[1]) break;
            result.add(new double[]{q[0], q[1]});
            p[0] = q[0];
            p[1] = q[1];
        }
        return result;
    }

    private int compare(double a, double b) {
        int c = Double.compare(a, b);
        if (c > 0) {
            return 1;
        }
        if (c < 0) {
            return -1;
        }
        return 0;
    }

    private double dist(double[] p, double[] q) {
        double dx = q[0] - p[0];
        double dy = q[1] - p[1];
        return dx * dx + dy * dy;
    }

    private int orientation(double[] p, double[] q, double[] r) {
        return this.compare((q[0] - p[0]) * (r[1] - p[1]) - (q[1] - p[1]) * (r[0] - p[0]), 0.0);
    }

    private double[] findExtreme(List<double[]> points) {
        double[] p = new double[]{points.get(0)[0], points.get(0)[1]};
        int i = 1;
        while (i < points.size()) {
            double x = points.get(i)[0];
            double y = points.get(i)[1];
            if (this.compare(x, p[0]) < 0 || this.compare(x, p[0]) == 0 && this.compare(y, p[1]) < 0) {
                p[0] = x;
                p[1] = y;
            }
            ++i;
        }
        return p;
    }
}

