/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures;

import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;

public class GeoShapeFigure
extends DefaultSizeNodeFigure {
    public GeoShapeFigure(int defWidth, int defHeight, int spacing) {
        super(defWidth, defHeight);
        this.setOpaque(true);
        this.setLayoutManager((LayoutManager)new StackLayout(){

            public void layout(IFigure figure) {
                Rectangle r = figure.getClientArea();
                List children = figure.getChildren();
                int i = 0;
                while (i < children.size()) {
                    IFigure child = (IFigure)children.get(i);
                    Dimension d = child.getPreferredSize(r.width, r.height);
                    d.width = Math.min(d.width, r.width);
                    d.height = Math.min(d.height, r.height);
                    Rectangle childRect = new Rectangle(r.x + (r.width - d.width) / 2, r.y + (r.height - d.height) / 2, d.width, d.height);
                    child.setBounds(childRect);
                    ++i;
                }
            }
        });
        Figure f = new Figure();
        ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
        layout.setSpacing(spacing);
        f.setLayoutManager((LayoutManager)layout);
        this.add((IFigure)f);
    }

    public IFigure getContentPane() {
        return (IFigure)this.getChildren().get(0);
    }
}

