/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.registration;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.resource.Resource;

public class EMFRegistryHelper {
    public static boolean isRegistered(URI uri) {
        return EMFRegistryHelper.isRegistered(uri.toString());
    }

    public static boolean isRegistered(String uri) {
        for (String regentry : EPackage.Registry.INSTANCE.keySet()) {
            if (!regentry.equals(uri.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isRegisteredAndLoaded(String uri) {
        Object registeredObj = EPackage.Registry.INSTANCE.get((Object)uri);
        return registeredObj instanceof EPackage;
    }

    public static boolean isDynamicallyRegistered(String uri) {
        Object pack = EPackage.Registry.INSTANCE.get((Object)uri);
        if (pack == null) {
            return false;
        }
        return pack.getClass() == EPackageImpl.class;
    }

    public static Set<String> getRegisteredChildren(String uri) {
        HashSet<String> result = new HashSet<String>();
        Object obj = EPackage.Registry.INSTANCE.get((Object)uri);
        if (obj instanceof EPackage) {
            EPackage p = (EPackage)obj;
            for (EPackage subPackage : p.getESubpackages()) {
                if (!EMFRegistryHelper.isRegistered(subPackage.getNsURI())) continue;
                result.add(subPackage.getNsURI());
            }
        }
        return result;
    }

    public static Set<String> getAllRegisteredChildren(String uri) {
        HashSet<String> result = new HashSet<String>();
        Object obj = EPackage.Registry.INSTANCE.get((Object)uri);
        if (obj instanceof EPackage) {
            EPackage p = (EPackage)obj;
            for (EPackage subPackage : p.getESubpackages()) {
                if (!EMFRegistryHelper.isRegistered(subPackage.getNsURI())) continue;
                result.add(subPackage.getNsURI());
                result.addAll(EMFRegistryHelper.getAllRegisteredChildren(subPackage.getNsURI()));
            }
        }
        return result;
    }

    public static void safeRegisterPackages(EPackage.Registry registry, EPackage pack) {
        if (!(pack.getNsURI() == null || pack.getNsURI().equals("") || EPackage.Registry.INSTANCE.containsKey((Object)pack.getNsURI()) || registry.containsKey((Object)pack.getNsURI()))) {
            registry.put((Object)pack.getNsURI(), (Object)pack);
            EList l = pack.getESubpackages();
            if (l != null) {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    EMFRegistryHelper.safeRegisterPackages(registry, (EPackage)it.next());
                }
            }
        }
    }

    public static Resource getResource(URI uri) {
        EPackage p = EPackage.Registry.INSTANCE.getEPackage(uri.toString());
        if (p != null) {
            return p.eResource();
        }
        return null;
    }
}

