/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.codegen;

import fr.inria.diverse.melange.codegen.ModelTypeGenClassGeneratorAdapter;
import fr.inria.diverse.melange.codegen.ModelTypeGenPackageGeneratorAdapter;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenBaseGeneratorAdapter;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenModelGeneratorAdapterFactory;
import org.eclipse.emf.common.notify.Adapter;

/**
 * A specialized {@link GenModelGeneratorAdapterFactory} that is used to tune
 * the generation of the Java code of {@link ModelType}.
 * 
 * @see ModelTypeGenPackageGeneratorAdapter
 * @see ModelTypeGenClassGeneratorAdapter
 */
@SuppressWarnings("all")
public class ModelTypeGeneratorAdapterFactory extends GenModelGeneratorAdapterFactory {
  protected GenBaseGeneratorAdapter overridedGenPackageGeneratorAdapter;
  
  protected GenBaseGeneratorAdapter overridedGenClassGeneratorAdapter;
  
  @Override
  public Adapter createGenPackageAdapter() {
    if ((this.overridedGenPackageGeneratorAdapter == null)) {
      ModelTypeGenPackageGeneratorAdapter _modelTypeGenPackageGeneratorAdapter = new ModelTypeGenPackageGeneratorAdapter(this);
      this.overridedGenPackageGeneratorAdapter = _modelTypeGenPackageGeneratorAdapter;
    }
    return this.overridedGenPackageGeneratorAdapter;
  }
  
  @Override
  public Adapter createGenClassAdapter() {
    if ((this.overridedGenClassGeneratorAdapter == null)) {
      ModelTypeGenClassGeneratorAdapter _modelTypeGenClassGeneratorAdapter = new ModelTypeGenClassGeneratorAdapter(this);
      this.overridedGenClassGeneratorAdapter = _modelTypeGenClassGeneratorAdapter;
    }
    return this.overridedGenClassGeneratorAdapter;
  }
}
