/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.Pair;
import org.eclipse.debug.internal.ui.actions.LaunchShortcutAction;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public class LaunchShortcutExtension
implements ILaunchShortcut2,
IPluginContribution {
    private ImageDescriptor fImageDescriptor = null;
    private List<String> fPerspectives = null;
    private ILaunchShortcut fDelegate = null;
    private Set<String> fModes = null;
    private Set<String> fAssociatedTypes = null;
    private Map<String, String> fDescriptions = null;
    private IConfigurationElement fContextualLaunchConfigurationElement = null;
    private Expression fContextualLaunchExpr = null;
    private Expression fStandardLaunchExpr = null;
    private IConfigurationElement fConfig;
    private List<Pair> fContextLabels;

    public LaunchShortcutExtension(IConfigurationElement element) {
        this.setConfigurationElement(element);
        this.registerLaunchCommandHandlers();
    }

    private void registerLaunchCommandHandlers() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
        if (handlerService != null) {
            for (String mode : this.getModes()) {
                String id = String.valueOf(this.getId()) + "." + mode;
                LaunchCommandHandler handler = new LaunchCommandHandler(this, mode);
                handlerService.activateHandler(id, (IHandler)handler);
            }
        }
    }

    private void setConfigurationElement(IConfigurationElement element) {
        this.fConfig = element;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.fConfig;
    }

    public String getLabel() {
        return this.getConfigurationElement().getAttribute("label");
    }

    public IConfigurationElement getContextualLaunchConfigurationElement() {
        IConfigurationElement[] elements;
        if (this.fContextualLaunchConfigurationElement == null && (elements = this.getConfigurationElement().getChildren("contextualLaunch")).length > 0) {
            this.fContextualLaunchConfigurationElement = elements[0];
        }
        return this.fContextualLaunchConfigurationElement;
    }

    public String getContextLabel(String mode) {
        if (this.fContextLabels == null) {
            IConfigurationElement context = this.getContextualLaunchConfigurationElement();
            if (context == null) {
                return null;
            }
            IConfigurationElement[] labels = context.getChildren("contextLabel");
            this.fContextLabels = new ArrayList<Pair>(labels.length);
            IConfigurationElement[] iConfigurationElementArray = labels;
            int n = labels.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement label = iConfigurationElementArray[n2];
                this.fContextLabels.add(new Pair(label.getAttribute("mode"), label.getAttribute("label")));
                ++n2;
            }
        }
        for (Pair p : this.fContextLabels) {
            if (!p.firstAsString().equals(mode)) continue;
            return p.secondAsString();
        }
        return this.getLabel();
    }

    public Set<String> getAssociatedConfigurationTypes() {
        if (this.fAssociatedTypes == null) {
            this.fAssociatedTypes = new HashSet<String>();
            IConfigurationElement[] children = this.fConfig.getChildren("configurationType");
            String id = null;
            IConfigurationElement[] iConfigurationElementArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                id = child.getAttribute("id");
                if (id != null) {
                    this.fAssociatedTypes.add(id);
                }
                ++n2;
            }
        }
        return this.fAssociatedTypes;
    }

    public String getShortcutDescription(String mode) {
        if (mode == null) {
            return null;
        }
        if (this.fDescriptions == null) {
            IConfigurationElement[] children;
            this.fDescriptions = new HashMap<String, String>();
            String descr = this.fConfig.getAttribute("description");
            if (descr != null) {
                for (String lmode : this.getModes()) {
                    this.fDescriptions.put(lmode, descr);
                }
            }
            IConfigurationElement[] iConfigurationElementArray = children = this.fConfig.getChildren("description");
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                String lmode = child.getAttribute("mode");
                descr = child.getAttribute("description");
                this.fDescriptions.put(lmode, descr);
                ++n2;
            }
        }
        return this.fDescriptions.get(mode);
    }

    public boolean evalEnablementExpression(IEvaluationContext context, Expression exp) throws CoreException {
        return exp != null ? exp.evaluate(context) != EvaluationResult.FALSE : false;
    }

    public Expression getContextualLaunchEnablementExpression() throws CoreException {
        if (this.fContextualLaunchExpr == null) {
            IConfigurationElement enablement;
            IConfigurationElement contextualLaunchElement = this.getContextualLaunchConfigurationElement();
            if (contextualLaunchElement == null) {
                return null;
            }
            IConfigurationElement[] elements = contextualLaunchElement.getChildren("enablement");
            IConfigurationElement iConfigurationElement = enablement = elements.length > 0 ? elements[0] : null;
            if (enablement != null) {
                this.fContextualLaunchExpr = ExpressionConverter.getDefault().perform(enablement);
            }
        }
        return this.fContextualLaunchExpr;
    }

    public Expression getShortcutEnablementExpression() throws CoreException {
        if (this.fStandardLaunchExpr == null) {
            IConfigurationElement enablement;
            IConfigurationElement[] elements = this.getConfigurationElement().getChildren("enablement");
            IConfigurationElement iConfigurationElement = enablement = elements.length > 0 ? elements[0] : null;
            if (enablement != null) {
                this.fStandardLaunchExpr = ExpressionConverter.getDefault().perform(enablement);
            }
        }
        return this.fStandardLaunchExpr;
    }

    public String getId() {
        return this.getConfigurationElement().getAttribute("id");
    }

    public String getHelpContextId() {
        return this.getConfigurationElement().getAttribute("helpContextId");
    }

    public String getCategory() {
        return this.getConfigurationElement().getAttribute("category");
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.fImageDescriptor == null) {
            this.fImageDescriptor = DebugUIPlugin.getImageDescriptor(this.getConfigurationElement(), "icon");
            if (this.fImageDescriptor == null) {
                this.fImageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
        }
        return this.fImageDescriptor;
    }

    @Deprecated
    public List<String> getPerspectives() {
        if (this.fPerspectives == null) {
            IConfigurationElement[] perspectives = this.getConfigurationElement().getChildren("perspective");
            this.fPerspectives = new ArrayList<String>(perspectives.length);
            IConfigurationElement[] iConfigurationElementArray = perspectives;
            int n = perspectives.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement perspective = iConfigurationElementArray[n2];
                this.fPerspectives.add(perspective.getAttribute("id"));
                ++n2;
            }
        }
        return this.fPerspectives;
    }

    protected ILaunchShortcut getDelegate() {
        if (this.fDelegate == null) {
            try {
                this.fDelegate = (ILaunchShortcut)this.fConfig.createExecutableExtension("class");
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return this.fDelegate;
    }

    @Override
    public void launch(IEditorPart editor, String mode) {
        ILaunchShortcut shortcut = this.getDelegate();
        if (shortcut != null) {
            shortcut.launch(editor, mode);
        }
    }

    @Override
    public void launch(ISelection selection, String mode) {
        ILaunchShortcut shortcut = this.getDelegate();
        if (shortcut != null) {
            shortcut.launch(selection, mode);
        }
    }

    public Set<String> getModes() {
        if (this.fModes == null) {
            String modes = this.getConfigurationElement().getAttribute("modes");
            if (modes == null) {
                return Collections.EMPTY_SET;
            }
            StringTokenizer tokenizer = new StringTokenizer(modes, ",");
            this.fModes = new HashSet<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                this.fModes.add(tokenizer.nextToken().trim());
            }
        }
        return this.fModes;
    }

    public String getMenuPath() {
        return this.getConfigurationElement().getAttribute("path");
    }

    public String toString() {
        return this.getId();
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.fConfig.getContributor().getName();
    }

    @Override
    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        ILaunchShortcut delegate = this.getDelegate();
        if (delegate instanceof ILaunchShortcut2) {
            return ((ILaunchShortcut2)delegate).getLaunchConfigurations(selection);
        }
        return null;
    }

    @Override
    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        ILaunchShortcut delegate = this.getDelegate();
        if (delegate instanceof ILaunchShortcut2) {
            return ((ILaunchShortcut2)delegate).getLaunchConfigurations(editorpart);
        }
        return null;
    }

    @Override
    public IResource getLaunchableResource(ISelection selection) {
        ILaunchShortcut delegate = this.getDelegate();
        if (delegate instanceof ILaunchShortcut2) {
            return ((ILaunchShortcut2)delegate).getLaunchableResource(selection);
        }
        return null;
    }

    @Override
    public IResource getLaunchableResource(IEditorPart editorpart) {
        ILaunchShortcut delegate = this.getDelegate();
        if (delegate instanceof ILaunchShortcut2) {
            return ((ILaunchShortcut2)delegate).getLaunchableResource(editorpart);
        }
        return null;
    }

    public boolean isParticipant() {
        return this.getDelegate() instanceof ILaunchShortcut2;
    }

    private static class LaunchCommandHandler
    extends AbstractHandler {
        private LaunchShortcutExtension fShortcut;
        private String fMode;

        public LaunchCommandHandler(LaunchShortcutExtension shortcut, String mode) {
            this.fShortcut = shortcut;
            this.fMode = mode;
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            LaunchShortcutAction action = new LaunchShortcutAction(this.fMode, this.fShortcut);
            if (action.isEnabled()) {
                action.run();
            } else {
                this.fShortcut.launch((ISelection)new StructuredSelection(), this.fMode);
            }
            return null;
        }
    }
}

