/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.plugin.LibraryPluginFieldData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class NewLibraryPluginCreationUpdateRefPage
extends WizardPage {
    private IPluginModelBase[] fSelected;
    private IPluginModelBase[] fUnmigrated;
    private CheckboxTableViewer pluginListViewer;
    private TablePart tablePart;
    private LibraryPluginFieldData fData;

    public NewLibraryPluginCreationUpdateRefPage(LibraryPluginFieldData data, Collection<?> initialJarPaths, Collection<?> selection) {
        super("UpdateReferences");
        this.setTitle(PDEUIMessages.UpdateBuildpathWizard_title);
        this.setDescription(PDEUIMessages.UpdateBuildpathWizard_desc);
        this.computeUnmigrated();
        this.computeSelected(selection);
        this.fData = data;
        this.tablePart = new TablePart(PDEUIMessages.UpdateBuildpathWizard_availablePlugins);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    private void computeSelected(Collection<?> initialSelection) {
        if (initialSelection == null || initialSelection.isEmpty()) {
            return;
        }
        HashSet<IPluginModelBase> selected = new HashSet<IPluginModelBase>();
        for (Object obj : initialSelection) {
            IPluginModelBase model;
            if (!(obj instanceof IProject) || (model = PluginRegistry.findModel((IProject)((IProject)obj))) == null) continue;
            selected.add(model);
        }
        this.fSelected = selected.toArray(new IPluginModelBase[selected.size()]);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        this.tablePart.createControl(container);
        this.pluginListViewer = this.tablePart.getTableViewer();
        this.pluginListViewer.setContentProvider((IContentProvider)new BuildpathContentProvider());
        this.pluginListViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        GridData gd = (GridData)this.tablePart.getControl().getLayoutData();
        gd.heightHint = 300;
        gd.widthHint = 300;
        this.pluginListViewer.setInput((Object)PDEPlugin.getDefault());
        if (this.fSelected != null && this.fSelected.length > 0) {
            this.tablePart.setSelection(this.fSelected);
        }
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.update_classpath");
    }

    private void computeUnmigrated() {
        IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
        ArrayList<IPluginModelBase> modelArray = new ArrayList<IPluginModelBase>();
        try {
            IPluginModelBase[] iPluginModelBaseArray = models;
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase model = iPluginModelBaseArray[n2];
                if (model.getUnderlyingResource().getProject().hasNature("org.eclipse.jdt.core.javanature")) {
                    modelArray.add(model);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.fUnmigrated = modelArray.toArray(new IPluginModelBase[modelArray.size()]);
    }

    public void setEnable(boolean enabled) {
        this.tablePart.setEnabled(enabled);
    }

    public void updateData() {
        IPluginModelBase[] modelBase = new IPluginModelBase[this.tablePart.getSelectionCount()];
        int i = 0;
        while (i < modelBase.length) {
            modelBase[i] = (IPluginModelBase)this.tablePart.getSelection()[i];
            ++i;
        }
        this.fData.setPluginsToUpdate(modelBase);
    }

    public class BuildpathContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            if (NewLibraryPluginCreationUpdateRefPage.this.fUnmigrated != null) {
                return NewLibraryPluginCreationUpdateRefPage.this.fUnmigrated;
            }
            return new Object[0];
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String mainLabel) {
            super(mainLabel);
        }

        @Override
        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit toolkit) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style, toolkit);
            viewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
            return viewer;
        }
    }
}

