/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class DeleteFromDiagramAction
extends DiagramAction {
    public DeleteFromDiagramAction(IWorkbenchPart part) {
        super(part);
    }

    public DeleteFromDiagramAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public void init() {
        super.init();
        this.setId("deleteFromDiagramAction");
        this.setText(DiagramUIActionsMessages.DeleteFromDiagram_ActionLabelText);
        this.setToolTipText(DiagramUIActionsMessages.DeleteFromDiagram_ActionToolTipText);
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected Request createTargetRequest() {
        GroupRequest deleteReq = new GroupRequest((Object)"delete");
        return deleteReq;
    }

    protected Command getCommand() {
        List objects = this.createOperationSet();
        if (!this.supportViews(objects) || this.isCanonical(objects)) {
            return null;
        }
        CompoundCommand deleteCC = new CompoundCommand(this.getLabel());
        for (EditPart editPart : objects) {
            deleteCC.add(editPart.getCommand(this.getTargetRequest()));
        }
        return deleteCC;
    }

    private boolean supportViews(List objects) {
        for (Object object : objects) {
            if (!(object instanceof GraphicalEditPart) || ((GraphicalEditPart)object).hasNotationView()) continue;
            return false;
        }
        return true;
    }

    protected List createOperationSet() {
        List selection = this.getSelectedObjects();
        if (selection.isEmpty() || !(selection.get(0) instanceof IGraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        return selection;
    }

    private boolean isCanonical(List selectedItems) {
        boolean isCanonical = false;
        if (!selectedItems.isEmpty()) {
            Iterator si = selectedItems.iterator();
            while (si.hasNext() && !isCanonical) {
                ConnectionEditPart connection;
                Object selected = si.next();
                if (!(selected instanceof EditPart)) continue;
                EditPart child = (EditPart)selected;
                View view = (View)child.getAdapter(View.class);
                isCanonical = view == null || view.getElement() == null || view.getElement() instanceof View ? false : (child instanceof ConnectionEditPart ? !(connection = (ConnectionEditPart)child).isSemanticConnection() || this.isCanonical(connection.getSource()) && this.isCanonical(connection.getTarget()) : this.isCanonical(child));
            }
        }
        return isCanonical;
    }

    private boolean isCanonical(EditPart ep) {
        EObject eObject = (EObject)ep.getAdapter(EObject.class);
        EditPart parent = ep.getParent();
        if (eObject != null && parent != null) {
            CanonicalEditPolicy cep = (CanonicalEditPolicy)parent.getEditPolicy((Object)"Canonical");
            return cep != null && cep.isEnabled() && cep.canCreate(eObject);
        }
        return false;
    }
}

